/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.pod.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.pod.model.UserId;

@ApiModel(description="Room Query Object. Used to specify the parameters for room search.")
public class RoomSearchCriteria {
    @JsonProperty(value="query")
    private String query = null;
    @JsonProperty(value="labels")
    private List<String> labels = null;
    @JsonProperty(value="active")
    private Boolean active = null;
    @JsonProperty(value="private")
    private Boolean _private = null;
    @JsonProperty(value="owner")
    private UserId owner = null;
    @JsonProperty(value="creator")
    private UserId creator = null;
    @JsonProperty(value="member")
    private UserId member = null;
    @JsonProperty(value="sortOrder")
    private SortOrderEnum sortOrder = null;

    public RoomSearchCriteria query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(required=true, value="The search query. Matches the room name and description.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public RoomSearchCriteria labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public RoomSearchCriteria addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @ApiModelProperty(value="A list of room tag labels whose values will be queried.")
    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public RoomSearchCriteria active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Restrict the search to active/inactive rooms. If unspecified, search all rooms.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public RoomSearchCriteria _private(Boolean _private) {
        this._private = _private;
        return this;
    }

    @ApiModelProperty(value="Restrict the search to private rooms. If unspecified, search all rooms.")
    public Boolean getPrivate() {
        return this._private;
    }

    public void setPrivate(Boolean _private) {
        this._private = _private;
    }

    public RoomSearchCriteria owner(UserId owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(value="")
    public UserId getOwner() {
        return this.owner;
    }

    public void setOwner(UserId owner) {
        this.owner = owner;
    }

    public RoomSearchCriteria creator(UserId creator) {
        this.creator = creator;
        return this;
    }

    @ApiModelProperty(value="")
    public UserId getCreator() {
        return this.creator;
    }

    public void setCreator(UserId creator) {
        this.creator = creator;
    }

    public RoomSearchCriteria member(UserId member) {
        this.member = member;
        return this;
    }

    @ApiModelProperty(value="")
    public UserId getMember() {
        return this.member;
    }

    public void setMember(UserId member) {
        this.member = member;
    }

    public RoomSearchCriteria sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(value="Sort algorithm to be used. Supports two values: \"BASIC\" (legacy algorithm) and \"RELEVANCE\" (enhanced algorithm). ")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomSearchCriteria roomSearchCriteria = (RoomSearchCriteria)o;
        return Objects.equals(this.query, roomSearchCriteria.query) && Objects.equals(this.labels, roomSearchCriteria.labels) && Objects.equals(this.active, roomSearchCriteria.active) && Objects.equals(this._private, roomSearchCriteria._private) && Objects.equals(this.owner, roomSearchCriteria.owner) && Objects.equals(this.creator, roomSearchCriteria.creator) && Objects.equals(this.member, roomSearchCriteria.member) && Objects.equals((Object)this.sortOrder, (Object)roomSearchCriteria.sortOrder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.labels, this.active, this._private, this.owner, this.creator, this.member, this.sortOrder});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomSearchCriteria {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    _private: ").append(this.toIndentedString(this._private)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SortOrderEnum {
        BASIC("BASIC"),
        RELEVANCE("RELEVANCE");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortOrderEnum fromValue(String text) {
            for (SortOrderEnum b : SortOrderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

