/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest;

import java.net.MalformedURLException;
import java.net.URL;
import org.symphonyoss.symphony.jcurl.JCurl;
import org.symphonyoss.symphony.tools.rest.console.Console;
import org.symphonyoss.symphony.tools.rest.console.ConsoleDelegate;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.model.IPod;
import org.symphonyoss.symphony.tools.rest.util.IObjective;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;
import org.symphonyoss.symphony.tools.rest.util.command.Flag;
import org.symphonyoss.symphony.tools.rest.util.command.Switch;
import org.symphonyoss.symphony.tools.rest.util.home.ISrtHome;
import org.symphonyoss.symphony.tools.rest.util.home.SrtCommandLineHome;

public abstract class SrtCommand
extends ConsoleDelegate {
    private final String programName_;
    private String name_;
    private String domain_;
    private String fqdn_;
    private int connectTimeoutMillis_ = 2000;
    private int readTimeoutMillis_ = 0;
    private ISrtHome srtHome_;
    private String keystore_ = "";
    private String storepass_ = "changeit";
    private String storetype_ = "pkcs12";
    private String truststore_ = "";
    private String trustpass_ = "changeit";
    private String trusttype_ = "jks";
    private SrtCommandLineHome parser_;
    protected final Switch verbose_ = new Switch('v', "Verbose", "Set verbose Mode", 3);
    protected final Switch interactive_ = new Switch('i', "Interactive", "Set interactive Mode", 2);
    private boolean withHostName_;

    public SrtCommand(String programName, String[] argv) {
        this(programName, new Console(System.in, System.out, System.err), null);
        this.parser_.process(argv);
    }

    public SrtCommand(String programName, IConsole console, ISrtHome srtHome) {
        super(console);
        this.programName_ = programName;
        this.parser_ = new SrtCommandLineHome(programName).withSwitch(this.verbose_).withSwitch(this.interactive_);
        this.init();
        this.srtHome_ = srtHome == null ? this.parser_.createSrtHome(this.getConsole()) : srtHome;
    }

    protected void withHostName(boolean required) {
        this.parser_.withFlag((Flag)new Flag<String>("Host Name", String.class, v -> {
            this.name_ = v;
        }).withRequired(required).withSelectionType(IPod.class));
        this.withHostName_ = true;
    }

    protected void withKeystore(boolean required) {
        ((SrtCommandLineHome)((SrtCommandLineHome)this.parser_.withFlag((Flag)new Flag<String>("Keystore File Name", String.class, v -> {
            this.keystore_ = v;
        }).withName("keystore").withRequired(required))).withFlag((Flag)new Flag<String>("Keystore Type", String.class, v -> {
            this.storetype_ = v;
        }, () -> this.getStoreTypeFromName(this.truststore_, "pkcs12")).withName("storetype"))).withFlag((Flag)new Flag<String>("Keystore Password", String.class, v -> {
            this.storepass_ = v;
        }, () -> "changeit").withName("storepass"));
    }

    protected void withTruststore(boolean required) {
        ((SrtCommandLineHome)((SrtCommandLineHome)this.parser_.withFlag((Flag)new Flag<String>("Truststore File Name", String.class, v -> {
            this.truststore_ = v;
        }).withName("truststore").withRequired(required))).withFlag((Flag)new Flag<String>("Truststore Type", String.class, v -> {
            this.trusttype_ = v;
        }, () -> this.getStoreTypeFromName(this.truststore_, "jks")).withName("trusttype"))).withFlag((Flag)new Flag<String>("Truststore Type", String.class, v -> {
            this.trustpass_ = v;
        }, () -> "changeit").withName("trustpass"));
    }

    private String getStoreTypeFromName(String fileName, String defaultValue) {
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            String suffix;
            switch (suffix = fileName.substring(i).toLowerCase()) {
                case ".p12": 
                case ".pkcs12": {
                    return "pkcs12";
                }
                case "jks": {
                    return "jks";
                }
            }
        }
        return defaultValue;
    }

    protected void init() {
    }

    public void run() {
        if (this.name_ == null) {
            this.name_ = this.getDefaultName();
        }
        this.execute(this);
        this.println();
        this.getErr().println();
        this.flush();
    }

    /*
     * Loose catch block
     */
    public void doExecute() {
        if (this.withHostName_) {
            int i = this.name_.indexOf(46);
            if (i == -1) {
                this.domain_ = ".symphony.com";
            } else {
                this.domain_ = this.name_.substring(i);
                this.name_ = this.name_.substring(0, i);
            }
            this.fqdn_ = this.name_ + this.domain_;
            this.printfln("name=" + this.name_, new Object[0]);
            this.printfln("domain=" + this.domain_, new Object[0]);
            this.println();
        }
        try {
            this.execute();
        }
        catch (ProgramFault e) {
            block15: {
                this.error((Throwable)e, "Command \"%s\" terminated unexpectedly PROGRAM FAULT.", this.name_);
                if (!this.getConsole().hasObjectives()) break block15;
                this.title("Objectives", new Object[0]);
                for (IObjective objective : this.getConsole().getObjectives()) {
                    this.printfln("%-20s %-10s %s", new Object[]{objective.getLabel(), objective.getComponentStatus(), objective.getComponentStatusMessage()});
                }
            }
            this.getConsole().flush();
        }
        catch (Throwable e2) {
            block16: {
                this.error(e2, "Command \"%s\" terminated unexpectedly.", this.name_);
                if (!this.getConsole().hasObjectives()) break block16;
                this.title("Objectives", new Object[0]);
                for (IObjective objective : this.getConsole().getObjectives()) {
                    this.printfln("%-20s %-10s %s", new Object[]{objective.getLabel(), objective.getComponentStatus(), objective.getComponentStatusMessage()});
                }
            }
            this.getConsole().flush();
            {
                catch (Throwable throwable) {
                    if (this.getConsole().hasObjectives()) {
                        this.title("Objectives", new Object[0]);
                        for (IObjective objective : this.getConsole().getObjectives()) {
                            this.printfln("%-20s %-10s %s", new Object[]{objective.getLabel(), objective.getComponentStatus(), objective.getComponentStatusMessage()});
                        }
                    }
                    this.getConsole().flush();
                    throw throwable;
                }
            }
        }
        if (this.getConsole().hasObjectives()) {
            this.title("Objectives", new Object[0]);
            for (IObjective objective : this.getConsole().getObjectives()) {
                this.printfln("%-20s %-10s %s", new Object[]{objective.getLabel(), objective.getComponentStatus(), objective.getComponentStatusMessage()});
            }
        }
        this.getConsole().flush();
    }

    protected String getDefaultName() {
        String name = this.getSrtHome().getPodManager().getDefaultPodName();
        return name;
    }

    public abstract void execute();

    public URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ProgramFault(e);
        }
    }

    public URL createURL(URL urlp, String path) {
        try {
            String url = urlp.toString();
            if (path.startsWith("/")) {
                while (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
            }
            return new URL(url + path);
        }
        catch (MalformedURLException e) {
            throw new ProgramFault(e);
        }
    }

    protected JCurl.Builder getJCurl() {
        JCurl.Builder builder = JCurl.builder().extract("token", "token").header("User-Agent", this.programName_ + " / 0.1.0 https://github.com/bruceskingle/symphony-rest-tools");
        if (this.getConnectTimeoutMillis() > 0) {
            builder.connectTimeout(this.getConnectTimeoutMillis());
        }
        if (this.getReadTimeoutMillis() > 0) {
            builder.readTimeout(this.getReadTimeoutMillis());
        }
        if (this.getKeystore() != null) {
            builder.keystore(this.getKeystore());
            builder.storepass(this.getStorepass());
            if (this.getStoretype() != null) {
                builder.storetype(this.getStoretype());
            }
        }
        if (this.getTruststore() != null) {
            builder.truststore(this.getTruststore());
            builder.trustpass(this.getTrustpass());
            if (this.getTrusttype() != null) {
                builder.storetype(this.getTrusttype());
            }
        }
        if (this.verbose_.getCount() > 0) {
            builder.verbosity(this.verbose_.getCount());
        }
        return builder;
    }

    public String getName() {
        return this.name_;
    }

    public String getDomain() {
        return this.domain_;
    }

    public String getFqdn() {
        return this.fqdn_;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis_;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis_;
    }

    public ISrtHome getSrtHome() {
        return this.srtHome_;
    }

    public String getKeystore() {
        return this.keystore_;
    }

    public String getStorepass() {
        return this.storepass_;
    }

    public String getStoretype() {
        return this.storetype_;
    }

    public String getTruststore() {
        return this.truststore_;
    }

    public String getTrustpass() {
        return this.trustpass_;
    }

    public String getTrusttype() {
        return this.trusttype_;
    }

    public String getProgramName() {
        return this.programName_;
    }

    public SrtCommandLineHome getParser() {
        return this.parser_;
    }

    public Switch getVerbose() {
        return this.verbose_;
    }

    public Switch getInteractive() {
        return this.interactive_;
    }
}

