/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.model.ISslServerConfig;
import org.symphonyoss.symphony.tools.rest.model.InvalidConfigException;
import org.symphonyoss.symphony.tools.rest.model.ModelObject;
import org.symphonyoss.symphony.tools.rest.model.ModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;

public class SslServer
extends ModelObjectContainer
implements ISslServerConfig {
    private static final String PKCS12 = "pkcs12";
    private final Set<X509Certificate> trustCerts_ = new HashSet<X509Certificate>();

    public SslServer(IModelObjectContainer parent, String typeName, JsonNode config) throws InvalidConfigException {
        super(parent, typeName, config);
    }

    @Override
    public void storeConfig(ObjectNode config, boolean includeMutable) {
        super.storeConfig(config, includeMutable);
    }

    @Override
    public Set<X509Certificate> getTrustCerts() {
        return new HashSet<X509Certificate>(this.trustCerts_);
    }

    public void importTrustStore(File trustStoreFile, String trustStorePassword) {
        try {
            KeyStore trustStore = KeyStore.getInstance(PKCS12);
            char[] password = trustStorePassword.toCharArray();
            try (FileInputStream stream = new FileInputStream(trustStoreFile);){
                trustStore.load(stream, password);
                Enumeration<String> en = trustStore.aliases();
                while (en.hasMoreElements()) {
                    Certificate cert = trustStore.getCertificate(en.nextElement());
                    if (cert instanceof X509Certificate) {
                        this.trustCerts_.add((X509Certificate)cert);
                        continue;
                    }
                    throw new ProgramFault("Unexpected certificate type " + cert.getClass().getName());
                }
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            this.addError("Unable to read truststore: " + e.getMessage());
        }
    }

    public void exportTrustStore(File trustStoreFile, String trustStorePassword) {
        try {
            KeyStore trustStore = KeyStore.getInstance(PKCS12);
            char[] password = trustStorePassword.toCharArray();
            int certIndex = 1;
            trustStore.load(null, null);
            for (X509Certificate cert : this.trustCerts_) {
                trustStore.setCertificateEntry(String.valueOf(certIndex++), cert);
            }
            try (FileOutputStream stream = new FileOutputStream(trustStoreFile);){
                trustStore.store(stream, password);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ProgramFault(e);
        }
    }

    public static class Builder
    extends ModelObject.Builder {
        private Set<X509Certificate> trustCerts_ = new HashSet<X509Certificate>();

        @Override
        public Builder setName(String name) {
            super.setName(name);
            return this;
        }

        public Builder addTrustCerts(Collection<X509Certificate> trustCerts) {
            this.trustCerts_.addAll(trustCerts);
            return this;
        }

        public Builder addTrustCert(X509Certificate trustCert) {
            this.trustCerts_.add(trustCert);
            return this;
        }

        public Set<X509Certificate> getTrustCerts() {
            return this.trustCerts_;
        }
    }
}

