/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.symphonyoss.symphony.jcurl.JCurl;
import org.symphonyoss.symphony.tools.rest.console.Console;
import org.symphonyoss.symphony.tools.rest.console.ConsoleDelegate;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.model.IPod;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;
import org.symphonyoss.symphony.tools.rest.util.command.Flag;
import org.symphonyoss.symphony.tools.rest.util.command.Switch;
import org.symphonyoss.symphony.tools.rest.util.home.ISrtHome;
import org.symphonyoss.symphony.tools.rest.util.home.SrtCommandLineHome;

public abstract class SrtCommand
extends ConsoleDelegate {
    private final String programName_;
    private String name_;
    private String domain_;
    private String fqdn_;
    private int connectTimeoutMillis_ = 2000;
    private int readTimeoutMillis_ = 0;
    private ISrtHome srtHome_;
    private String keystore_ = "";
    private String storepass_ = "changeit";
    private String storetype_ = "pkcs12";
    private String truststore_ = "";
    private String trustpass_ = "changeit";
    private String trusttype_ = "jks";
    private SrtCommandLineHome parser_;
    protected final Switch verbose_ = new Switch('v', "Verbose", "Set verbose Mode", 3);
    protected final Switch interactive_ = new Switch('i', "Interactive", "Set interactive Mode", 2);
    private boolean withHostName_;

    public SrtCommand(String programName, String[] argv) {
        this(programName, new Console(System.in, System.out, System.err), null);
        this.parser_.process(argv);
    }

    public SrtCommand(String programName, IConsole console, ISrtHome srtHome) {
        super(console);
        this.programName_ = programName;
        this.parser_ = new SrtCommandLineHome(programName).withSwitch(this.verbose_).withSwitch(this.interactive_).withSwitch(this.getQuiet());
        this.init();
        this.srtHome_ = srtHome == null ? this.parser_.createSrtHome(this.getConsole()) : srtHome;
    }

    protected void withHostName(boolean required) {
        this.parser_.withFlag((Flag)new Flag<String>("Host Name", String.class, v -> {
            String string = this.name_ = v;
        }).withRequired(required).withSelectionType(IPod.class));
        this.withHostName_ = true;
    }

    protected void withKeystore(boolean required) {
        ((SrtCommandLineHome)((SrtCommandLineHome)this.parser_.withFlag((Flag)new Flag<String>("Keystore File Name", String.class, v -> {
            String string = this.keystore_ = v;
        }).withName("keystore").withRequired(required))).withFlag((Flag)new Flag<String>("Keystore Type", String.class, v -> {
            String string = this.storetype_ = v;
        }, () -> this.getStoreTypeFromName(this.truststore_, "pkcs12")).withName("storetype"))).withFlag((Flag)new Flag<String>("Keystore Password", String.class, v -> {
            String string = this.storepass_ = v;
        }, () -> "changeit").withName("storepass"));
    }

    protected void withTruststore(boolean required) {
        ((SrtCommandLineHome)((SrtCommandLineHome)this.parser_.withFlag((Flag)new Flag<String>("Truststore File Name", String.class, v -> {
            String string = this.truststore_ = v;
        }).withName("truststore").withRequired(required))).withFlag((Flag)new Flag<String>("Truststore Type", String.class, v -> {
            String string = this.trusttype_ = v;
        }, () -> this.getStoreTypeFromName(this.truststore_, "jks")).withName("trusttype"))).withFlag((Flag)new Flag<String>("Truststore Type", String.class, v -> {
            String string = this.trustpass_ = v;
        }, () -> "changeit").withName("trustpass"));
    }

    private String getStoreTypeFromName(String fileName, String defaultValue) {
        block12: {
            String suffix;
            int i = fileName.lastIndexOf(46);
            if (i <= 0) break block12;
            switch (suffix = fileName.substring(i).toLowerCase()) {
                case ".p12": 
                case ".pkcs12": {
                    return "pkcs12";
                }
                case "jks": {
                    return "jks";
                }
            }
        }
        return defaultValue;
    }

    protected void init() {
    }

    public void run() {
        if (this.name_ == null) {
            this.name_ = this.getDefaultName();
        }
        this.execute(this);
        this.println();
        this.getErr().println();
        this.flush();
    }

    /*
     * Exception decompiling
     */
    public void doExecute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void prepareToExecute() {
        if (this.withHostName_) {
            int i = this.name_.indexOf(46);
            if (i == -1) {
                this.domain_ = ".symphony.com";
            } else {
                this.domain_ = this.name_.substring(i);
                this.name_ = this.name_.substring(0, i);
            }
            this.fqdn_ = String.valueOf(this.name_) + this.domain_;
            this.printfln("name=" + this.name_, new Object[0]);
            this.printfln("domain=" + this.domain_, new Object[0]);
            this.println();
        }
    }

    protected String getDefaultName() {
        String name = this.getSrtHome().getPodManager().getDefaultPodName();
        return name;
    }

    public abstract void execute();

    public void setSwitches(SrtCommand childCommand, Switch ... switches) {
        Map<Character, Switch> switchMap = childCommand.getParser().getSwitches();
        Switch[] switchArray = switches;
        int n = switches.length;
        int n2 = 0;
        while (n2 < n) {
            Switch sw = switchArray[n2];
            Switch childSwitch = switchMap.get(Character.valueOf(sw.getName()));
            if (childSwitch != null) {
                childSwitch.setCount(sw.getCount());
            }
            ++n2;
        }
    }

    public void setSwitch(SrtCommand childCommand, int value, Switch sw) {
        Map<Character, Switch> switchMap = childCommand.getParser().getSwitches();
        Switch childSwitch = switchMap.get(Character.valueOf(sw.getName()));
        if (childSwitch != null) {
            childSwitch.setCount(value);
        }
    }

    public void setAllFlags(SrtCommand childCommand) {
        this.setFlags(childCommand, this.getParser().getFlags());
    }

    public void setFlags(SrtCommand childCommand, Collection<Flag<?>> flags) {
        for (Flag<?> flag : flags) {
            Flag<?> childFlag;
            List<String> names = flag.getNames();
            Flag<?> flag2 = childFlag = names.isEmpty() ? childCommand.getParser().getArgSetter() : childCommand.getParser().getFlag(names.get(0));
            if (childFlag == null) continue;
            childFlag.set(flag.getValue());
        }
    }

    public URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ProgramFault(e);
        }
    }

    public URL createURL(URL urlp, String path) {
        try {
            String url = urlp.toString();
            if (path.startsWith("/")) {
                while (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
            }
            return new URL(String.valueOf(url) + path);
        }
        catch (MalformedURLException e) {
            throw new ProgramFault(e);
        }
    }

    protected JCurl.Builder getJCurl() {
        String truststore;
        String keystore;
        JCurl.Builder builder = JCurl.builder().extract("token", "token").header("User-Agent", String.valueOf(this.programName_) + " / 0.1.0 https://github.com/symphonyoss/symphony-rest-tools");
        if (this.getConnectTimeoutMillis() > 0) {
            builder.connectTimeout(this.getConnectTimeoutMillis());
        }
        if (this.getReadTimeoutMillis() > 0) {
            builder.readTimeout(this.getReadTimeoutMillis());
        }
        if ((keystore = this.getKeystore()) != null && keystore.length() > 0) {
            builder.keystore(keystore);
            builder.storepass(this.getStorepass());
            String storetype = this.getStoretype();
            if (storetype != null && storetype.length() > 0) {
                builder.storetype(storetype);
            }
        }
        if ((truststore = this.getTruststore()) != null && truststore.length() > 0) {
            builder.truststore(truststore);
            builder.trustpass(this.getTrustpass());
            String trusttype = this.getTrusttype();
            if (trusttype != null && trusttype.length() > 0) {
                builder.storetype(trusttype);
            }
        }
        if (this.verbose_.getCount() > 0) {
            builder.verbosity(this.verbose_.getCount());
        }
        return builder;
    }

    public String getName() {
        return this.name_;
    }

    public String getDomain() {
        return this.domain_;
    }

    public String getFqdn() {
        return this.fqdn_;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis_;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis_;
    }

    public ISrtHome getSrtHome() {
        return this.srtHome_;
    }

    public String getKeystore() {
        return this.keystore_;
    }

    public String getStorepass() {
        return this.storepass_;
    }

    public String getStoretype() {
        return this.storetype_;
    }

    public String getTruststore() {
        return this.truststore_;
    }

    public String getTrustpass() {
        return this.trustpass_;
    }

    public String getTrusttype() {
        return this.trusttype_;
    }

    public String getProgramName() {
        return this.programName_;
    }

    public SrtCommandLineHome getParser() {
        return this.parser_;
    }

    public Switch getVerbose() {
        return this.verbose_;
    }

    public Switch getInteractive() {
        return this.interactive_;
    }
}

