/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.command;

import java.io.IOException;
import org.symphonyoss.symphony.tools.rest.SrtCommand;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.model.IPod;
import org.symphonyoss.symphony.tools.rest.util.home.ISrtHome;

public class DeletePod
extends SrtCommand {
    private static final String PROGRAM_NAME = "DeletePod";
    private IPod pod_;

    public static void main(String[] argv) throws IOException {
        new DeletePod(argv).run();
    }

    public DeletePod(IConsole console, ISrtHome srtHome) {
        super(PROGRAM_NAME, console, srtHome);
    }

    public DeletePod(String[] argv) {
        super(PROGRAM_NAME, argv);
    }

    @Override
    protected void init() {
        super.init();
        this.withHostName(true);
    }

    @Override
    public void execute() {
        this.pod_ = this.getSrtHome().getPodManager().getPod(this.getFqdn());
        if (this.pod_ == null) {
            this.getConsole().flush();
            this.getConsole().error(String.valueOf(this.getFqdn()) + " is not a known pod.", new Object[0]);
            return;
        }
        int totalWork = 1;
        this.getConsole().beginTask(totalWork, "Deleting %s", this.getFqdn());
        try {
            this.pod_.delete();
            this.getConsole().printfln("Pod deleted.", new Object[0]);
        }
        catch (IOException e) {
            this.getConsole().error((Throwable)e, "Failed to delete: %s", e.getMessage());
        }
        this.getConsole().taskWorked(1);
    }
}

