/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.symphonyoss.symphony.tools.rest.SrtCommand;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.util.IObjective;
import org.symphonyoss.symphony.tools.rest.util.Objective;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;
import org.symphonyoss.symphony.tools.rest.util.command.CommandLineParserFault;
import org.symphonyoss.symphony.tools.rest.util.command.Flag;
import org.symphonyoss.symphony.tools.rest.util.home.IDefaultsProvider;
import org.symphonyoss.symphony.tools.rest.util.home.SrtCommandLineHome;

public class Console
implements IConsole {
    private final BufferedReader in_;
    private final PrintWriter out_;
    private final PrintWriter err_;
    private IDefaultsProvider defaultsProvider_;
    private CopyOnWriteArrayList<IObjective> objectives_ = new CopyOnWriteArrayList();
    private String taskName_;

    public Console(InputStream in, OutputStream out, OutputStream err) {
        this.in_ = new BufferedReader(new InputStreamReader(in));
        this.out_ = new PrintWriter(out);
        this.err_ = new PrintWriter(err);
    }

    public Console(BufferedReader in, PrintWriter out, PrintWriter err) {
        this.in_ = in;
        this.out_ = out;
        this.err_ = err;
    }

    public IDefaultsProvider getDefaultsProvider() {
        return this.defaultsProvider_;
    }

    @Override
    public void setDefaultsProvider(IDefaultsProvider defaultsProvider) {
        this.defaultsProvider_ = defaultsProvider;
    }

    @Override
    public String promptString(String prompt, String defaultValue) {
        String s = this.doPromptString(String.valueOf(prompt) + "[" + defaultValue + "]");
        return s.equals("") ? defaultValue : s.trim();
    }

    @Override
    public String promptString(String prompt) {
        return this.doPromptString(prompt).trim();
    }

    public String doPromptString(String prompt) {
        String line;
        this.out_.print(prompt);
        this.out_.print(": ");
        this.out_.flush();
        try {
            line = this.in_.readLine();
        }
        catch (IOException e) {
            throw new ProgramFault("Error on console input.", e);
        }
        if (line == null) {
            throw new ProgramFault("Unexpected end of file on console.");
        }
        return line;
    }

    @Override
    public boolean promptBoolean(String prompt) {
        String line;
        while ((line = this.promptString(String.valueOf(prompt) + "[n]")).length() != 0) {
            if ("y".equalsIgnoreCase(line)) {
                return true;
            }
            if ("yes".equalsIgnoreCase(line)) {
                return true;
            }
            if ("n".equalsIgnoreCase(line)) {
                return false;
            }
            if ("no".equalsIgnoreCase(line)) {
                return false;
            }
            this.out_.println("Invalid input: enter y or n.");
        }
        return false;
    }

    @Override
    public PrintWriter getOut() {
        return this.out_;
    }

    @Override
    public PrintWriter getErr() {
        return this.err_;
    }

    public void printStackTrace(Throwable e) {
        e.printStackTrace(this.err_);
    }

    @Override
    public void println() {
        this.out_.println();
    }

    @Override
    public String println(Object obj) {
        return this.doPrintf(true, obj.toString(), new Object[0]);
    }

    @Override
    public String printf(String format, Object ... args) {
        return this.doPrintf(false, format, args);
    }

    @Override
    public String printf(Locale l, String format, Object ... args) {
        return this.doPrintf(false, l, format, args);
    }

    @Override
    public String printfln(String format, Object ... args) {
        return this.doPrintf(true, format, args);
    }

    @Override
    public String title(Locale l, String format, Object ... args) {
        this.println();
        return this.doTitle(this.doPrintf(true, l, format, args));
    }

    @Override
    public String title(String format, Object ... args) {
        this.println();
        return this.doTitle(this.doPrintf(true, format, args));
    }

    private String doTitle(String s) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            b.append('=');
            ++i;
        }
        this.println(b);
        return s;
    }

    @Override
    public String printfln(Locale l, String format, Object ... args) {
        return this.doPrintf(true, l, format, args);
    }

    public String doPrintf(boolean newLine, String format, Object ... args) {
        return this.doPrint(newLine, this.format(format, args));
    }

    public String doPrintf(boolean newLine, Locale l, String format, Object ... args) {
        return this.doPrint(newLine, this.format(l, format, args));
    }

    public String doPrint(boolean newLine, String message) {
        if (newLine) {
            this.out_.println(message);
        } else {
            this.out_.print(message);
        }
        return message;
    }

    @Override
    public String error(@Nullable Throwable cause, @Nullable Locale l, String format, Object ... args) {
        String message;
        RuntimeException internalFault = null;
        try {
            message = l == null ? this.format(format, args) : this.format(l, format, args);
        }
        catch (RuntimeException e) {
            message = format;
            internalFault = e;
        }
        this.out_.flush();
        this.err_.flush();
        this.err_.println(message);
        if (cause != null) {
            cause.printStackTrace(this.err_);
        }
        if (internalFault != null) {
            this.err_.println("Additionally this exception was thrown formatting the error message above from:");
            this.err_.printf("Format   %s%n", format);
            int i = 0;
            while (i < args.length) {
                this.err_.printf("arg[%2d] %s%n", args[i]);
                ++i;
            }
            this.err_.printf("%d args in total%n", args.length);
            internalFault.printStackTrace(this.err_);
        }
        this.err_.flush();
        return message;
    }

    @Override
    public String error(Locale l, String format, Object ... args) {
        return this.error(null, l, format, args);
    }

    @Override
    public String error(@Nullable Throwable cause, String format, Object ... args) {
        return this.error(cause, null, format, args);
    }

    @Override
    public String error(String format, Object ... args) {
        return this.error(null, null, format, args);
    }

    @Override
    public void close() {
        this.err_.close();
        this.out_.close();
        try {
            this.in_.close();
        }
        catch (IOException e) {
            throw new ProgramFault(e);
        }
    }

    @Override
    public void flush() {
        this.err_.flush();
        this.out_.flush();
    }

    public boolean setParameters(SrtCommandLineHome parser, int interactiveCount) {
        boolean abort = false;
        boolean promptAll = false;
        this.printfln("Press RETURN to accept default values", new Object[0]);
        this.printfln("Enter a space to clear the default value", new Object[0]);
        this.printfln("Leading and trailing whitespace are deleted", new Object[0]);
        switch (interactiveCount) {
            case 0: {
                for (Flag<?> flag : parser.getFlags()) {
                    if (!flag.isRequired() || flag.getCount() != 0) continue;
                    this.error("A value for " + flag.getDescription() + " is required.\n", new Object[0]);
                    abort = true;
                }
                break;
            }
            case 2: {
                promptAll = true;
            }
            default: {
                for (Flag<?> flag : parser.getFlags()) {
                    boolean doAgain;
                    if (!promptAll && !flag.isRequired()) continue;
                    do {
                        doAgain = false;
                        String defaultValue = flag.getValue();
                        if (defaultValue.length() == 0) {
                            defaultValue = this.defaultsProvider_.getDefault(flag.getPrompt());
                        }
                        String value = this.promptString(flag.getPrompt(), defaultValue);
                        try {
                            flag.set(value);
                            if (!flag.isRequired() || value.length() != 0) continue;
                            this.error("A value is required\n", new Object[0]);
                            doAgain = true;
                        }
                        catch (CommandLineParserFault e) {
                            doAgain = true;
                        }
                    } while (doAgain);
                }
            }
        }
        if (!abort) {
            for (Flag<?> flag : parser.getFlags()) {
                this.defaultsProvider_.setDefault(flag.getPrompt(), flag.getValue());
            }
        }
        return abort;
    }

    @Override
    public void execute(SrtCommand srtCommand) {
        try {
            boolean abort = this.setParameters(srtCommand.getParser(), srtCommand.getInteractive().getCount());
            if (abort) {
                this.error("Aborted.", new Object[0]);
            } else {
                srtCommand.doExecute();
            }
        }
        catch (Exception e) {
            this.error((Throwable)e, "Command \"%s\" terminated unexpectedly.", srtCommand.getName());
        }
    }

    @Override
    public String beginTask(int totalWork, String format, Object ... args) {
        if (this.taskName_ != null) {
            throw new IllegalStateException("This method can be called only once per Console.");
        }
        this.taskName_ = this.format(format, args);
        return this.title(this.taskName_, new Object[0]);
    }

    @Override
    public void taskDone() {
    }

    @Override
    public boolean isTaskCanceled() {
        return false;
    }

    @Override
    public String setTaskName(String format, Object ... args) {
        this.taskName_ = this.format(format, args);
        return this.title(this.taskName_, new Object[0]);
    }

    @Override
    public String beginSubTask(String format, Object ... args) {
        if (this.taskName_ == null) {
            throw new IllegalStateException("You must call beginTask before this method.");
        }
        return this.title("%s: %s", this.taskName_, this.format(format, args));
    }

    private String format(Locale l, String format, Object ... args) {
        if (format == null) {
            return "";
        }
        return String.format(l, format, args);
    }

    private String format(String format, Object ... args) {
        if (format == null) {
            return "";
        }
        return String.format(format, args);
    }

    @Override
    public boolean taskWorked(int work) {
        return this.isTaskCanceled();
    }

    @Override
    public IObjective createObjective(String name) {
        Objective objective = new Objective(name);
        this.objectives_.add(objective);
        return objective;
    }

    @Override
    public Iterable<IObjective> getObjectives() {
        return this.objectives_;
    }

    @Override
    public Collection<IObjective> copyObjectives() {
        return Collections.unmodifiableList(this.objectives_);
    }

    @Override
    public boolean hasObjectives() {
        return !this.objectives_.isEmpty();
    }

    public void reset() {
        this.taskName_ = null;
    }
}

