/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import org.symphonyoss.symphony.tools.rest.model.IAgent;
import org.symphonyoss.symphony.tools.rest.model.IModelObject;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.model.InvalidConfigException;
import org.symphonyoss.symphony.tools.rest.model.ModelObject;
import org.symphonyoss.symphony.tools.rest.model.Pod;

public class Agent
extends ModelObject
implements IAgent {
    public static final String AGENT_URL = "agentUrl";
    public static final String TYPE_NAME = "Agent";
    private final String agentApiUrl_;
    private final Pod pod_;
    private URL url_;

    Agent(Pod pod, JsonNode config) throws InvalidConfigException {
        super((IModelObjectContainer)pod, TYPE_NAME, config);
        this.pod_ = pod;
        this.agentApiUrl_ = Agent.getRequiredTextNode(config, AGENT_URL);
        try {
            this.url_ = new URL(this.agentApiUrl_);
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigException("Invalid URL \"" + this.agentApiUrl_ + "\"");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void storeConfig(ObjectNode jsonNode, boolean includeMutable) {
        super.storeConfig(jsonNode, includeMutable);
        Agent.putIfNotNull(jsonNode, AGENT_URL, this.agentApiUrl_);
    }

    @Override
    public String getAgentApiUrl() {
        return this.agentApiUrl_;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public URL getUrl() {
        return this.url_;
    }

    @Override
    public IModelObject getParent() {
        return this.pod_;
    }

    public static class Builder
    extends ModelObject.Builder {
        private URL agentApiUrl_;

        @Override
        public Builder setName(String name) {
            super.setName(name);
            return this;
        }

        public Builder setAgentApiUrl(URL agentApiUrl) {
            this.agentApiUrl_ = agentApiUrl;
            Agent.putIfNotNull(this.jsonNode_, Agent.AGENT_URL, agentApiUrl);
            return this;
        }

        @Nullable
        public URL getAgentApiUrl() {
            return this.agentApiUrl_;
        }

        public Agent build(Pod pod) throws InvalidConfigException {
            return new Agent(pod, (JsonNode)this.jsonNode_);
        }
    }
}

