/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.symphonyoss.symphony.tools.rest.model.IDynamicComponentContainer;
import org.symphonyoss.symphony.tools.rest.model.IModelObject;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectConstructor;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.model.ModelObject;
import org.symphonyoss.symphony.tools.rest.model.ModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.model.osmosis.IComponent;
import org.symphonyoss.symphony.tools.rest.model.osmosis.IComponentListener;
import org.symphonyoss.symphony.tools.rest.util.typeutils.ISetter;

public class DynamicComponentContainer
extends ModelObjectContainer
implements IDynamicComponentContainer,
IComponentListener {
    public static final String TYPE_NAME = "DynamicComponentContainer";
    private Map<String, IModelObject> componentMap_ = new HashMap<String, IModelObject>();

    public DynamicComponentContainer(IModelObjectContainer parent) {
        super(parent, TYPE_NAME, "Dynamic Components");
    }

    public DynamicComponentContainer(IModelObjectContainer parent, String name) {
        super(parent, TYPE_NAME, name);
    }

    public DynamicComponentContainer(IModelObjectContainer parent, String typeName, String name) {
        super(parent, typeName, name);
    }

    @Override
    public IModelObject getComponent(String name) {
        return this.getComponent(name, (IModelObject parent, String componentName) -> new ModelObject((IModelObjectContainer)this, "Component", componentName), (ISetter)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IModelObject getComponent(String name, IModelObjectConstructor<? extends IModelObject> constructor, @Nullable ISetter<IModelObject> setExisting) {
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        while (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        Map<String, IModelObject> map = this.componentMap_;
        synchronized (map) {
            IModelObject component = this.componentMap_.get(name);
            if (component == null) {
                IModelObject vmo = constructor.newInstance(this, name);
                vmo.addListener(this);
                this.componentMap_.put(name, vmo);
                this.addChild(vmo);
                return vmo;
            }
            setExisting.set(component);
            return component;
        }
    }

    @Override
    public void componentStatusChanged(IComponent component) {
        this.setComponentStatusIfMoreSevere(component.getComponentStatus(), component.getComponentStatusMessage(), new Object[0]);
    }
}

