/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.model.IBuilder;
import org.symphonyoss.symphony.tools.rest.model.IModelObject;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.model.InvalidConfigException;
import org.symphonyoss.symphony.tools.rest.model.osmosis.ComponentProxy;
import org.symphonyoss.symphony.tools.rest.model.osmosis.ComponentStatus;
import org.symphonyoss.symphony.tools.rest.util.IVisitor;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;

public class ModelObject
extends ComponentProxy
implements IModelObject {
    private static final String FORMAT_1_REQUIRED_FIELD_MISSING = "Required field \"%s\" missing";
    private static final String FORMAT_1_INVALID_STATUS = "Invalid component status \"%s\"";
    public static final String NAME = "name";
    public static final String COMPONENT_STATUS = "componentStatus";
    public static final String COMPONENT_STATUS_MESSAGE = "componentStatusMessage";
    private final IModelObjectContainer parent_;
    private final String typeName_;
    private final String name_;
    private StringBuilder errorBuilder_ = new StringBuilder();
    private String errorText_ = null;

    public ModelObject(IModelObjectContainer parent, String typeName, String name) {
        this.parent_ = parent;
        this.typeName_ = typeName;
        this.name_ = name;
    }

    public ModelObject(IModelObjectContainer parent, String typeName, JsonNode config) throws InvalidConfigException {
        this(parent, typeName, ModelObject.getRequiredTextNode(config, NAME));
        ComponentStatus status = null;
        String s = ModelObject.getOptionalTextNode(config, COMPONENT_STATUS);
        if (s != null) {
            try {
                status = ComponentStatus.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                this.setComponentStatus(ComponentStatus.Failed, String.format(FORMAT_1_INVALID_STATUS, s));
            }
        }
        this.setComponentStatus(status, ModelObject.getOptionalTextNode(config, COMPONENT_STATUS_MESSAGE));
    }

    public void storeConfig(ObjectNode jsonNode, boolean includeMutable) {
        jsonNode.put(NAME, this.name_);
        if (includeMutable) {
            ModelObject.putIfNotNull(jsonNode, COMPONENT_STATUS, (Object)this.getComponentStatus());
            ModelObject.putIfNotNull(jsonNode, COMPONENT_STATUS_MESSAGE, this.getComponentStatusMessage());
        }
    }

    @Override
    public void visit(IVisitor<IModelObject> visitor) {
        visitor.visit(this);
    }

    @Override
    public IModelObject getParent() {
        return this.parent_;
    }

    @Override
    public String getTypeName() {
        return this.typeName_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode jsonNode = JsonNodeFactory.instance.objectNode();
        this.storeConfig(jsonNode, true);
        return jsonNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(String message) {
        StringBuilder stringBuilder = this.errorBuilder_;
        synchronized (stringBuilder) {
            if (this.errorText_ != null) {
                this.errorBuilder_.append("\n");
            }
            this.errorBuilder_.append(message);
            this.errorText_ = this.errorBuilder_.toString();
        }
    }

    @Override
    public String getErrorText() {
        return this.errorText_;
    }

    @Override
    public void store(File configDir, String fileName) throws IOException {
        ModelObject.store(configDir, fileName, this.toJson());
    }

    @Override
    public void store(File configDir) throws IOException {
        ModelObject.store(configDir, this.toJson());
    }

    public static void store(File configDir, ObjectNode json) throws IOException {
        ModelObject.store(configDir, "config", json);
    }

    public static void store(File configDir, String fileName, ObjectNode json) throws IOException {
        if (!configDir.isDirectory() && !configDir.mkdirs()) {
            throw new IOException("Failed to create directory " + configDir.getAbsolutePath());
        }
        File config = new File(configDir, String.valueOf(fileName) + ".json");
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(config, (Object)json);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void print(IConsole console) {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)console.getOut(), (Object)this.toJson());
            console.println();
        }
        catch (IOException e) {
            throw new ProgramFault(e);
        }
    }

    public void modelUpdated(ModelObject newPod) {
    }

    protected static void putIfNotNull(ObjectNode jsonNode, String name, Object value) {
        if (value == null) {
            jsonNode.remove(name);
        } else {
            String str = value.toString().trim();
            if (str.length() > 0) {
                jsonNode.put(name, str);
            } else {
                jsonNode.remove(name);
            }
        }
    }

    protected static JsonNode getRequiredNode(JsonNode jsonNode, String name) throws InvalidConfigException {
        JsonNode node = jsonNode.get(name);
        if (node == null) {
            throw new InvalidConfigException(String.format(FORMAT_1_REQUIRED_FIELD_MISSING, name));
        }
        return node;
    }

    @Nonnull
    protected static String getRequiredTextNode(JsonNode jsonNode, String name) throws InvalidConfigException {
        return ModelObject.getRequiredNode(jsonNode, name).asText();
    }

    @Nonnull
    protected static URL getRequiredUrlNode(JsonNode jsonNode, String name) throws InvalidConfigException {
        try {
            return new URL(ModelObject.getRequiredNode(jsonNode, name).asText());
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigException(e);
        }
    }

    protected static long getRequiredLongNode(JsonNode jsonNode, String name) throws InvalidConfigException {
        return ModelObject.getRequiredNode(jsonNode, name).asLong();
    }

    @Nullable
    protected static String getOptionalTextNode(JsonNode jsonNode, String name) {
        JsonNode node = jsonNode.get(name);
        if (node == null) {
            return null;
        }
        return node.asText();
    }

    @Nonnull
    protected static URL getOptionalUrlNode(JsonNode jsonNode, String name) throws InvalidConfigException {
        JsonNode node;
        block3: {
            try {
                node = jsonNode.get(name);
                if (node != null) break block3;
                return null;
            }
            catch (MalformedURLException e) {
                throw new InvalidConfigException(e);
            }
        }
        return new URL(node.asText());
    }

    @Nullable
    protected static Long getOptionalLongNode(JsonNode jsonNode, String name) {
        JsonNode node = jsonNode.get(name);
        if (node == null) {
            return null;
        }
        return node.asLong();
    }

    @Override
    public void resetStatus() {
        super.resetStatus();
        this.parent_.modelObjectChanged(this);
    }

    public static class Builder
    implements IBuilder {
        protected ObjectNode jsonNode_ = JsonNodeFactory.instance.objectNode();

        public JsonNode toJson() {
            return this.jsonNode_;
        }

        @Override
        public void store(File configDir, String fileName) throws IOException {
            ModelObject.store(configDir, fileName, this.jsonNode_);
        }

        @Override
        public void store(File configDir) throws IOException {
            ModelObject.store(configDir, this.jsonNode_);
        }

        public Builder setName(String name) {
            this.jsonNode_.put(ModelObject.NAME, name);
            return this;
        }

        @Nullable
        public String getName() {
            return ModelObject.getOptionalTextNode((JsonNode)this.jsonNode_, ModelObject.NAME);
        }
    }
}

