/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.symphonyoss.symphony.tools.rest.model.IModelListener;
import org.symphonyoss.symphony.tools.rest.model.IModelObject;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.model.InvalidConfigException;
import org.symphonyoss.symphony.tools.rest.model.ModelObject;
import org.symphonyoss.symphony.tools.rest.model.UrlEndpoint;
import org.symphonyoss.symphony.tools.rest.util.IVisitor;

public class ModelObjectContainer
extends ModelObject
implements IModelObjectContainer {
    @Nullable
    private final IModelObjectContainer parentContainer_;
    private List<IModelObject> childSet_ = new ArrayList<IModelObject>();
    private IModelObject[] children_ = new IModelObject[0];
    private CopyOnWriteArrayList<IModelListener> listeners_ = new CopyOnWriteArrayList();

    public ModelObjectContainer(IModelObjectContainer parentContainer, String typeName, JsonNode config) throws InvalidConfigException {
        super(parentContainer, typeName, config);
        this.parentContainer_ = parentContainer;
    }

    public ModelObjectContainer(IModelObjectContainer parent, String typeName, String name) {
        super(parent, typeName, name);
        this.parentContainer_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(IModelObject child) {
        if (child == null) {
            throw new NullPointerException("Child may not be null");
        }
        List<IModelObject> list = this.childSet_;
        synchronized (list) {
            this.childSet_.add(child);
            IModelObject[] iModelObjectArray = this.children_;
            synchronized (this.children_) {
                this.children_ = this.childSet_.toArray(new IModelObject[this.childSet_.size()]);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        {
            this.modelObjectStructureChanged(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceChild(IModelObject oldChild, IModelObject newChild) {
        if (newChild == null) {
            throw new NullPointerException("newChild may not be null");
        }
        List<IModelObject> list = this.childSet_;
        synchronized (list) {
            if (oldChild != null) {
                this.childSet_.remove(oldChild);
            }
            this.childSet_.add(newChild);
            IModelObject[] iModelObjectArray = this.children_;
            synchronized (this.children_) {
                this.children_ = this.childSet_.toArray(new IModelObject[this.childSet_.size()]);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        {
            this.modelObjectStructureChanged(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(IModelObject oldChild) {
        List<IModelObject> list = this.childSet_;
        synchronized (list) {
            if (oldChild != null) {
                this.childSet_.remove(oldChild);
            }
            IModelObject[] iModelObjectArray = this.children_;
            synchronized (this.children_) {
                this.children_ = this.childSet_.toArray(new IModelObject[this.childSet_.size()]);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        {
            this.modelObjectStructureChanged(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(IVisitor<IModelObject> visitor) {
        super.visit(visitor);
        IModelObject[] iModelObjectArray = this.children_;
        synchronized (this.children_) {
            IModelObject[] iModelObjectArray2 = this.children_;
            int n = this.children_.length;
            int n2 = 0;
            while (n2 < n) {
                IModelObject component = iModelObjectArray2[n2];
                visitor.visit(component);
                ++n2;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildren() {
        IModelObject[] iModelObjectArray = this.children_;
        synchronized (this.children_) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.children_.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IModelObject[] getChildren() {
        IModelObject[] iModelObjectArray = this.children_;
        synchronized (this.children_) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.children_;
        }
    }

    public void addSimpleChild(String typeName, String name) {
        if (name != null) {
            this.addChild(new ModelObject((IModelObjectContainer)this, typeName, name));
        }
    }

    public void addUrlEndpoint(String typeName, String name, URL url) {
        if (url != null) {
            this.addChild(new UrlEndpoint(this, typeName, name, url));
        }
    }

    @Override
    public void modelObjectChanged(IModelObject modelObject) {
        for (IModelListener listener : this.listeners_) {
            listener.modelObjectChanged(modelObject);
        }
        if (this.parentContainer_ != null) {
            this.parentContainer_.modelObjectChanged(modelObject);
        }
    }

    @Override
    public void modelObjectStructureChanged(IModelObject modelObject) {
        for (IModelListener listener : this.listeners_) {
            listener.modelObjectStructureChanged(modelObject);
        }
        if (this.parentContainer_ != null) {
            this.parentContainer_.modelObjectStructureChanged(modelObject);
        }
    }

    @Override
    public void addListener(IModelListener listener) {
        this.listeners_.add(listener);
    }

    @Override
    public void removeListener(IModelListener listener) {
        this.listeners_.remove(listener);
    }
}

