/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.symphonyoss.symphony.tools.rest.ISrtSelectable;
import org.symphonyoss.symphony.tools.rest.model.Agent;
import org.symphonyoss.symphony.tools.rest.model.DynamicComponentContainer;
import org.symphonyoss.symphony.tools.rest.model.IModelObject;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectConstructor;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.model.IPod;
import org.symphonyoss.symphony.tools.rest.model.IPodManager;
import org.symphonyoss.symphony.tools.rest.model.InvalidConfigException;
import org.symphonyoss.symphony.tools.rest.model.ModelObject;
import org.symphonyoss.symphony.tools.rest.model.PodManager;
import org.symphonyoss.symphony.tools.rest.model.Principal;
import org.symphonyoss.symphony.tools.rest.model.SslServer;
import org.symphonyoss.symphony.tools.rest.util.typeutils.ISetter;

public class Pod
extends SslServer
implements IPod,
ISrtSelectable {
    public static final String TYPE_NAME = "Pod";
    public static final String WEB_TYPE_NAME = "WebServer";
    public static final String TYPE_KEY_MANAGER = "KeyManager";
    public static final String TYPE_SESSION_AUTH = "SessionAuth";
    public static final String TYPE_KEY_AUTH = "KeyAuth";
    private static final String FORMAT_1_AGENTS_NO_ARRAY = "Agents element \"%s\" must be an array";
    private static final String FORMAT_1_PRINCIPALS_NO_ARRAY = "Principals element \"%s\" must be an array";
    private static final String POD_ID = "pod.id";
    private static final String AGENTS = "agents";
    private static final String PRINCIPALS = "principals";
    private static final String POD_URL = "podUrl";
    private static final String WEB_URL = "webUrl";
    private static final String WEB_TITLE = "webTitle";
    private static final String KEY_MANAGER_URL = "keymanagerUrl";
    private static final String SESSION_AUTH_URL = "sessionauthUrl";
    private static final String KEY_AUTH_URL = "keyauthUrl";
    private static final String POD_API_URL = "podApiUrl";
    private final URL keyManagerUrl_;
    private final URL podUrl_;
    private final URL webUrl_;
    private final String webTitle_;
    private final URL podApiUrl_;
    private final URL sessionAuthUrl_;
    private final URL keyAuthUrl_;
    private Long podId_;
    private final PodManager manager_;
    private Map<String, Agent> agentMap_ = new HashMap<String, Agent>();
    private Map<String, Principal> principalMap_ = new HashMap<String, Principal>();
    private DynamicComponentContainer dynamicContainer_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pod(PodManager manager, JsonNode config) throws InvalidConfigException {
        super((IModelObjectContainer)manager, config.get(POD_URL) != null ? TYPE_NAME : WEB_TYPE_NAME, config);
        JsonNode principalsNode;
        this.manager_ = manager;
        this.podUrl_ = Pod.getOptionalUrlNode(config, POD_URL);
        this.webUrl_ = Pod.getOptionalUrlNode(config, WEB_URL);
        this.webTitle_ = Pod.getOptionalTextNode(config, WEB_TITLE);
        this.keyManagerUrl_ = Pod.getOptionalUrlNode(config, KEY_MANAGER_URL);
        this.sessionAuthUrl_ = Pod.getOptionalUrlNode(config, SESSION_AUTH_URL);
        this.keyAuthUrl_ = Pod.getOptionalUrlNode(config, KEY_AUTH_URL);
        this.podApiUrl_ = Pod.getOptionalUrlNode(config, POD_API_URL);
        this.addUrlEndpoint(TYPE_KEY_MANAGER, "Key Manager", this.keyManagerUrl_);
        this.addUrlEndpoint(TYPE_SESSION_AUTH, "Session Auth", this.sessionAuthUrl_);
        this.addUrlEndpoint(TYPE_KEY_AUTH, "Key Auth", this.keyAuthUrl_);
        this.podId_ = Pod.getOptionalLongNode(config, POD_ID);
        JsonNode agentsNode = config.get(AGENTS);
        if (agentsNode != null) {
            if (agentsNode.isArray()) {
                Map<String, Agent> map = this.agentMap_;
                synchronized (map) {
                    for (JsonNode node : (ArrayNode)agentsNode) {
                        Agent agent = new Agent(this, node);
                        this.addAgent(agent);
                    }
                }
            } else {
                throw new InvalidConfigException(String.format(FORMAT_1_AGENTS_NO_ARRAY, AGENTS));
            }
        }
        if ((principalsNode = config.get(PRINCIPALS)) != null) {
            if (principalsNode.isArray()) {
                Map<String, Principal> map = this.principalMap_;
                synchronized (map) {
                    for (JsonNode node : (ArrayNode)principalsNode) {
                        Principal principal = new Principal(this, node);
                        Principal oldAgent = this.principalMap_.put(principal.getName(), principal);
                        if (oldAgent == null) continue;
                        oldAgent.modelUpdated(principal);
                    }
                }
            } else {
                throw new InvalidConfigException(String.format(FORMAT_1_PRINCIPALS_NO_ARRAY, AGENTS));
            }
        }
    }

    public Agent addAgent(Agent agent) {
        Agent oldAgent = this.agentMap_.put(agent.getName(), agent);
        if (oldAgent != null) {
            oldAgent.modelUpdated(agent);
        }
        this.replaceChild(oldAgent, agent);
        return agent;
    }

    public Agent addAgent(Agent.Builder agentBuilder) throws InvalidConfigException {
        return this.addAgent(agentBuilder.build(this));
    }

    public Principal addPrincipal(Principal principal) {
        Principal oldPrincipal = this.principalMap_.put(principal.getName(), principal);
        if (oldPrincipal != null) {
            oldPrincipal.modelUpdated(principal);
        }
        this.replaceChild(oldPrincipal, principal);
        return principal;
    }

    @Override
    public Principal addPrincipal(Principal.Builder principalBuilder) {
        return this.addPrincipal(principalBuilder.build(this));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeConfig(ObjectNode config, boolean includeMutable) {
        ObjectNode node;
        super.storeConfig(config, includeMutable);
        Pod.putIfNotNull(config, POD_URL, this.podUrl_);
        Pod.putIfNotNull(config, WEB_URL, this.webUrl_);
        Pod.putIfNotNull(config, WEB_TITLE, this.webTitle_);
        Pod.putIfNotNull(config, KEY_MANAGER_URL, this.keyManagerUrl_);
        Pod.putIfNotNull(config, SESSION_AUTH_URL, this.sessionAuthUrl_);
        Pod.putIfNotNull(config, KEY_AUTH_URL, this.keyAuthUrl_);
        Pod.putIfNotNull(config, POD_API_URL, this.podApiUrl_);
        if (includeMutable) {
            Pod.putIfNotNull(config, POD_ID, this.podId_);
        }
        Map<String, ModelObject> map = this.agentMap_;
        synchronized (map) {
            if (!this.agentMap_.isEmpty()) {
                ArrayNode agentsNode = config.putArray(AGENTS);
                for (Agent agent : this.agentMap_.values()) {
                    node = agentsNode.addObject();
                    agent.storeConfig(node, includeMutable);
                }
            }
        }
        map = this.principalMap_;
        synchronized (map) {
            if (!this.principalMap_.isEmpty()) {
                ArrayNode principalsNode = config.putArray(PRINCIPALS);
                for (Principal principal : this.principalMap_.values()) {
                    node = principalsNode.addObject();
                    principal.storeConfig(node, includeMutable);
                }
            }
        }
    }

    @Override
    public IPodManager getManager() {
        return this.manager_;
    }

    public void modelUpdated(Pod newPod) {
    }

    @Override
    public URL getUrl() {
        return this.podUrl_ == null ? this.webUrl_ : this.podUrl_;
    }

    @Override
    public Long getPodId() {
        return this.podId_;
    }

    @Override
    public URL getKeyManagerUrl() {
        return this.keyManagerUrl_;
    }

    @Override
    public URL getPodUrl() {
        return this.podUrl_;
    }

    @Override
    public URL getWebUrl() {
        return this.webUrl_;
    }

    @Override
    public String getWebTitle() {
        return this.webTitle_;
    }

    @Override
    public URL getPodApiUrl() {
        return this.podApiUrl_;
    }

    @Override
    public URL getSessionAuthUrl() {
        return this.sessionAuthUrl_;
    }

    @Override
    public URL getKeyAuthUrl() {
        return this.keyAuthUrl_;
    }

    @Override
    public void save() throws IOException {
        this.manager_.save(this);
    }

    @Override
    public void delete() throws IOException {
        this.manager_.deletePod(this);
    }

    public synchronized DynamicComponentContainer getDynamicContainer() {
        if (this.dynamicContainer_ == null) {
            this.dynamicContainer_ = new DynamicComponentContainer((IModelObjectContainer)this, "PodServer", "Pod Components");
            this.addChild(this.dynamicContainer_);
        }
        return this.dynamicContainer_;
    }

    @Override
    public IModelObject getComponent(String name) {
        return this.getDynamicContainer().getComponent(name, (IModelObject parent, String componentName) -> new ModelObject((IModelObjectContainer)this, "Component", componentName), (ISetter)null);
    }

    @Override
    public IModelObject getComponent(String name, IModelObjectConstructor<? extends IModelObject> constructor, @Nullable ISetter<IModelObject> setExisting) {
        return this.getDynamicContainer().getComponent(name, (IModelObject parent, String componentName) -> new ModelObject((IModelObjectContainer)this, "Component", componentName), (ISetter)setExisting);
    }

    @Override
    public Class<? extends IModelObject> getSelectionType() {
        return IPod.class;
    }

    public static class Builder
    extends SslServer.Builder {
        private URL podUrl_;
        private URL podApiUrl_;
        private URL webUrl_;
        private URL keyManagerUrl_;
        private URL keyAuthUrl_;
        private URL sessionAuthUrl_;

        @Override
        public Builder setName(String name) {
            super.setName(name);
            return this;
        }

        @Override
        public Builder addTrustCerts(Collection<X509Certificate> trustCerts) {
            super.addTrustCerts(trustCerts);
            return this;
        }

        @Override
        public Builder addTrustCert(X509Certificate trustCert) {
            super.addTrustCert(trustCert);
            return this;
        }

        public Builder setPodUrl(URL podUrl) {
            this.podUrl_ = podUrl;
            Pod.putIfNotNull(this.jsonNode_, Pod.POD_URL, podUrl);
            return this;
        }

        public Builder setWebUrl(URL webUrl) {
            this.webUrl_ = webUrl;
            Pod.putIfNotNull(this.jsonNode_, Pod.WEB_URL, webUrl);
            return this;
        }

        public Builder setWebTitle(String webTitle) {
            Pod.putIfNotNull(this.jsonNode_, Pod.WEB_TITLE, webTitle);
            return this;
        }

        public Builder setKeyManagerUrl(URL keyManagerUrl) {
            this.keyManagerUrl_ = keyManagerUrl;
            Pod.putIfNotNull(this.jsonNode_, Pod.KEY_MANAGER_URL, keyManagerUrl);
            return this;
        }

        public Builder setSessionAuthUrl(URL sessionAuthUrl) {
            this.sessionAuthUrl_ = sessionAuthUrl;
            Pod.putIfNotNull(this.jsonNode_, Pod.SESSION_AUTH_URL, sessionAuthUrl);
            return this;
        }

        public Builder setKeyAuthUrl(URL keyAuthUrl) {
            this.keyAuthUrl_ = keyAuthUrl;
            Pod.putIfNotNull(this.jsonNode_, Pod.KEY_AUTH_URL, keyAuthUrl);
            return this;
        }

        public Builder setPodApiUrl(URL podApiUrl) {
            this.podApiUrl_ = podApiUrl;
            Pod.putIfNotNull(this.jsonNode_, Pod.POD_API_URL, podApiUrl);
            return this;
        }

        @Nullable
        public URL getPodUrl() {
            return this.podUrl_;
        }

        @Nullable
        public URL getPodApiUrl() {
            return this.podApiUrl_;
        }

        @Nullable
        public URL getWebUrl() {
            return this.webUrl_;
        }

        @Nullable
        public String getWebTitle() {
            return Pod.getOptionalTextNode((JsonNode)this.jsonNode_, Pod.WEB_TITLE);
        }

        @Nullable
        public URL getKeyManagerUrl() {
            return this.keyManagerUrl_;
        }

        @Nullable
        public URL getKeyAuthUrl() {
            return this.keyAuthUrl_;
        }

        @Nullable
        public URL getSessionAuthUrl() {
            return this.sessionAuthUrl_;
        }

        public Pod build(PodManager manager) throws InvalidConfigException {
            return new Pod(manager, (JsonNode)this.jsonNode_);
        }
    }
}

