/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.symphonyoss.symphony.tools.rest.model.Agent;
import org.symphonyoss.symphony.tools.rest.model.FileSystemModelObjectManager;
import org.symphonyoss.symphony.tools.rest.model.IPod;
import org.symphonyoss.symphony.tools.rest.model.IPodManager;
import org.symphonyoss.symphony.tools.rest.model.InvalidConfigException;
import org.symphonyoss.symphony.tools.rest.model.Pod;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;

public class PodManager
extends FileSystemModelObjectManager
implements IPodManager {
    private Map<String, Pod> podMap_ = new HashMap<String, Pod>();
    private boolean allLoaded_;

    public PodManager(File configDir) {
        super(null, "Pod Manager", "PodManager", configDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Map<String, Pod> map = this.podMap_;
        synchronized (map) {
            if (this.allLoaded_) {
                return this.podMap_.size();
            }
        }
        String[] names = this.getConfigDir().list();
        if (names == null) {
            return 0;
        }
        return names.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getDefaultPodName() {
        Map<String, Pod> map = this.podMap_;
        synchronized (map) {
            if (this.allLoaded_) {
                Set<String> keySet = this.podMap_.keySet();
                if (keySet.size() == 1) {
                    return keySet.iterator().next();
                }
                return null;
            }
        }
        String[] names = this.getConfigDir().list();
        if (names.length == 1) {
            return names[0];
        }
        return null;
    }

    @Override
    public Set<IPod> getAll() {
        this.loadAll();
        return new HashSet<IPod>(this.podMap_.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAll() {
        if (!this.allLoaded_) {
            Map<String, Pod> map = this.podMap_;
            synchronized (map) {
                File[] fileArray = this.getConfigDir().listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (this.podMap_.get(file.getName()) == null) {
                        try {
                            Pod newPod = this.loadPod(file);
                            this.podMap_.put(file.getName(), newPod);
                            this.addChild(newPod);
                        }
                        catch (IOException | InvalidConfigException e) {
                            throw new ProgramFault("Failed to read pod config", e);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pod getPod(String hostName) {
        Map<String, Pod> map = this.podMap_;
        synchronized (map) {
            block6: {
                if (this.podMap_.containsKey(hostName)) break block6;
                File configDir = this.getConfigPath(hostName);
                try {
                    Pod pod = this.loadPod(configDir);
                    this.podMap_.put(hostName, pod);
                    this.addChild(pod);
                    return pod;
                }
                catch (IOException | InvalidConfigException e) {
                    return null;
                }
            }
        }
        return this.podMap_.get(hostName);
    }

    private Pod loadPod(File configDir) throws JsonProcessingException, IOException, InvalidConfigException {
        File podConfig = new File(configDir, "config.json");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(podConfig);
        return new Pod(this, jsonNode);
    }

    @Override
    public IPod save(IPod pod) throws IOException {
        File configDir = this.getConfigPath(pod.getName());
        pod.store(configDir);
        return pod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPod createOrUpdatePod(Pod.Builder podConfig, Agent.Builder agentBuilder) throws InvalidConfigException, IOException {
        Pod oldPod;
        File configDir = this.getConfigPath(podConfig.getName());
        Pod newPod = podConfig.build(this);
        if (agentBuilder.getAgentApiUrl() != null) {
            newPod.addAgent(agentBuilder);
        }
        newPod.store(configDir);
        Map<String, Pod> map = this.podMap_;
        synchronized (map) {
            oldPod = this.podMap_.put(podConfig.getName(), newPod);
            this.replaceChild(oldPod, newPod);
        }
        if (oldPod != null) {
            oldPod.modelUpdated(newPod);
        }
        return newPod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePod(Pod oldPod) throws IOException {
        File configDir = this.getConfigPath(oldPod.getName());
        this.deleteRecursively(configDir);
        Map<String, Pod> map = this.podMap_;
        synchronized (map) {
            this.podMap_.remove(oldPod.getName());
            this.removeChild(oldPod);
        }
        oldPod.modelUpdated(null);
    }

    private void deleteRecursively(File f) {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File ff = fileArray[n2];
                this.deleteRecursively(ff);
                ++n2;
            }
        }
        f.delete();
    }
}

