/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.cert.CertificateParsingException;
import org.symphonyoss.symphony.jcurl.JCurl;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.model.IPod;
import org.symphonyoss.symphony.tools.rest.model.InvalidConfigException;
import org.symphonyoss.symphony.tools.rest.model.ModelObject;
import org.symphonyoss.symphony.tools.rest.model.Pod;
import org.symphonyoss.symphony.tools.rest.model.osmosis.ComponentStatus;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;

public class Principal
extends ModelObject {
    public static final String TYPE_NAME = "Principal";
    private static final String SESSION_INFO = "/v2/sessioninfo";
    private static final String USER_NAME = "username";
    private static final String USER_ID = "id";
    private static final String CERTIFICATE = "certificate";
    private static final String SKEY = "skey";
    private static final String KMSESSION = "kmsession";
    private final String certificate_;
    private String userName_;
    private long userId_;
    private String skey_;
    private String kmsession_;
    private final Pod pod_;

    public Principal(Pod pod, JsonNode config) throws InvalidConfigException {
        super((IModelObjectContainer)pod, TYPE_NAME, config);
        this.pod_ = pod;
        this.userName_ = Principal.getOptionalTextNode(config, USER_NAME);
        this.userId_ = Principal.getRequiredLongNode(config, USER_ID);
        this.certificate_ = Principal.getOptionalTextNode(config, CERTIFICATE);
        this.skey_ = Principal.getOptionalTextNode(config, SKEY);
        this.kmsession_ = Principal.getOptionalTextNode(config, KMSESSION);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void storeConfig(ObjectNode config, boolean includeMutable) {
        super.storeConfig(config, includeMutable);
        Principal.putIfNotNull(config, USER_NAME, this.userName_);
        Principal.putIfNotNull(config, USER_ID, this.userId_);
        Principal.putIfNotNull(config, CERTIFICATE, this.certificate_);
        if (includeMutable) {
            Principal.putIfNotNull(config, SKEY, this.skey_);
            Principal.putIfNotNull(config, KMSESSION, this.kmsession_);
        }
    }

    public static Principal newInstance(IConsole console, IPod pod, String skey, String kmsession) throws IOException {
        Builder builder = Principal.newBuilder().setSkey(skey).setKmsession(kmsession);
        console.printfln("Validating session", new Object[0]);
        JCurl jcurl = JCurl.builder().header("sessionToken", skey).extract(KMSESSION, KMSESSION).build();
        try {
            HttpURLConnection con = jcurl.connect(pod.getPodApiUrl() + SESSION_INFO);
            JCurl.Response response = jcurl.processResponse(con);
            JsonNode json = response.getJsonNode();
            console.println(json);
            builder.setUserId(Principal.getRequiredLongNode(json, USER_ID));
            builder.setName(Principal.getRequiredTextNode(json, USER_NAME));
        }
        catch (IOException | CertificateParsingException | InvalidConfigException e) {
            console.error((Throwable)e, "Unable to validate user", new Object[0]);
        }
        Principal principal = pod.addPrincipal(builder);
        pod.save();
        principal.setComponentStatus(ComponentStatus.OK, "Logged In");
        return principal;
    }

    public static class Builder
    extends ModelObject.Builder {
        @Override
        public Builder setName(String name) {
            super.setName(name);
            return this;
        }

        public Builder setUserName(String userName) {
            Principal.putIfNotNull(this.jsonNode_, Principal.USER_NAME, userName);
            return this;
        }

        public Builder setUserId(long userId) {
            Principal.putIfNotNull(this.jsonNode_, Principal.USER_ID, userId);
            return this;
        }

        public Builder setCertificate(String certificate) {
            Principal.putIfNotNull(this.jsonNode_, Principal.CERTIFICATE, certificate);
            return this;
        }

        public Builder setSkey(String skey) {
            Principal.putIfNotNull(this.jsonNode_, Principal.SKEY, skey);
            return this;
        }

        public Builder setKmsession(String kmSesion) {
            Principal.putIfNotNull(this.jsonNode_, Principal.KMSESSION, kmSesion);
            return this;
        }

        public Principal build(Pod pod) {
            try {
                return new Principal(pod, (JsonNode)this.jsonNode_);
            }
            catch (InvalidConfigException e) {
                throw new ProgramFault(e);
            }
        }
    }
}

