/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.model.osmosis;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.symphonyoss.symphony.tools.rest.model.osmosis.ComponentStatus;
import org.symphonyoss.symphony.tools.rest.model.osmosis.IComponent;
import org.symphonyoss.symphony.tools.rest.model.osmosis.IComponentListener;

public class Component
implements IComponent {
    private ComponentStatus status_;
    private String statusMessage_;
    private CopyOnWriteArrayList<IComponentListener> listeners_ = new CopyOnWriteArrayList();

    public Component() {
        this(ComponentStatus.Initializing, "Initializing...");
    }

    protected Component(ComponentStatus status, String statusMessage) {
        this.status_ = status;
        this.statusMessage_ = statusMessage;
    }

    @Override
    public String getComponentStatusMessage() {
        return this.statusMessage_;
    }

    @Override
    @Nullable
    public ComponentStatus getComponentStatus() {
        return this.status_;
    }

    protected void setComponentStatusOK() {
        this.setComponentStatus(ComponentStatus.OK, "", new Object[0]);
    }

    protected synchronized void setComponentStatus(ComponentStatus status, String statusMessageFormat, Object ... args) {
        this.status_ = status;
        if (statusMessageFormat == null) {
            this.statusMessage_ = "";
        } else {
            try {
                this.statusMessage_ = String.format(statusMessageFormat, args);
            }
            catch (RuntimeException e) {
                this.statusMessage_ = String.valueOf(statusMessageFormat) + " (formatting failed " + e + ")";
            }
        }
        this.notifyListeners();
    }

    protected void resetStatus() {
        this.status_ = null;
        this.statusMessage_ = "Unknown";
    }

    public void notifyListeners() {
        for (IComponentListener listener : this.listeners_) {
            listener.componentStatusChanged(this);
        }
    }

    @Override
    public void addListener(IComponentListener listener) {
        this.listeners_.add(listener);
    }

    @Override
    public void removeListener(IComponentListener listener) {
        this.listeners_.remove(listener);
    }

    protected synchronized void setComponentStatusIfMoreSevere(ComponentStatus status, String statusMessageFormat, Object ... args) {
        if (status.isMoreSevereThan(this.status_)) {
            this.setComponentStatus(status, statusMessageFormat, args);
        }
    }
}

