/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.probe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.x500.X500Principal;
import org.symphonyoss.symphony.jcurl.JCurl;
import org.symphonyoss.symphony.tools.rest.SrtCommand;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.model.IPod;
import org.symphonyoss.symphony.tools.rest.model.osmosis.ComponentStatus;
import org.symphonyoss.symphony.tools.rest.util.IObjective;
import org.symphonyoss.symphony.tools.rest.util.home.ISrtHome;

public class CheckCerts
extends SrtCommand {
    private static final String PROGRAM_NAME = "CheckCerts";
    private static final String WE_CANT_TELL = "We cannot tell if these certs are good for this pod.";
    private static final String CERTS_ARE_GOOD_SERVER = "This truststore is good for this pod.";
    private static final String CERTS_ARE_GOOD = "These certs are good for this pod.";
    private static final String CERTS_ARE_BAD_TRUST = "Server certs not in truststore.";
    private static final String CERTS_ARE_BAD_AUTH = "Client cert is NOT valid.";
    private static final String CERTS_ARE_BAD_ACCOUNT = "Client cert is valid, auth failed FORBIDDEN.";
    private static final String UNKNOWN_CERT = "Received fatal alert: certificate_unknown";
    private static final String BAD_CERT = "Received fatal alert: bad_unknown";
    private static final String AUTHENTICATED = "Authenticated OK";
    private static final String CERTS_ARE_BAD_UNKNOWN = "Client cert is valid, auth failed %d.";
    private static final Object ERROR = "ERROR";
    private static final Object WARNING = "WARNING";
    private IPod pod_;
    private String clientCertCommonName_;
    private IObjective keystoreObjective_;
    private IObjective truststoreObjective_;
    private IObjective sessionAuthObjective_;
    private IObjective keyAuthObjective_;
    private IObjective podObjective_;

    public static void main(String[] argv) throws IOException {
        new CheckCerts(argv).run();
    }

    public CheckCerts(IConsole console, ISrtHome srtHome) {
        super(PROGRAM_NAME, console, srtHome);
    }

    public CheckCerts(String[] argv) {
        super(PROGRAM_NAME, argv);
    }

    @Override
    protected void init() {
        super.init();
        this.withHostName(true);
        this.withKeystore(true);
        this.withTruststore(true);
        this.keystoreObjective_ = this.createObjective("Validate Keystore");
        this.truststoreObjective_ = this.createObjective("Validate Truststore");
        this.podObjective_ = this.createObjective("Connect to Pod");
        this.sessionAuthObjective_ = this.createObjective("Authenticate to Pod");
        this.keyAuthObjective_ = this.createObjective("Authenticate to Key Manager");
    }

    @Override
    public void execute() {
        int totalWork = 10;
        this.beginTask(totalWork, "Check Certs", new Object[0]);
        this.pod_ = this.getSrtHome().getPodManager().getPod(this.getFqdn());
        if (this.pod_ == null) {
            this.flush();
            this.error(String.valueOf(this.getFqdn()) + " is not a known pod. Try probe instead?", new Object[0]);
            return;
        }
        this.title("Pod Configuration", new Object[0]);
        this.pod_.print(this.getConsole());
        this.println();
        if (this.validateKeyStore("KeyStore", this.getKeystore(), this.getStoretype(), this.getStorepass().toCharArray(), true, this.keystoreObjective_) != null) {
            return;
        }
        if (this.validateKeyStore("TrustStore", this.getTruststore(), this.getTrusttype(), this.getTrustpass().toCharArray(), false, this.truststoreObjective_) != null) {
            return;
        }
        if (this.pod_.getPodUrl() == null) {
            this.error("No pod URL for this pod.", new Object[0]);
        } else {
            this.println("Checking Pod");
            this.println("=============");
            this.probe("Pod", this.createURL(this.pod_.getPodUrl(), "/webcontroller/HealthCheck"), false, this.podObjective_);
        }
        if (this.pod_.getSessionAuthUrl() == null) {
            this.error("No session auth URL for this pod.", new Object[0]);
        } else {
            this.println("Checking Session Auth");
            this.println("=====================");
            this.probe("Session Auth", this.createURL(this.pod_.getSessionAuthUrl(), "/v1/authenticate"), true, this.sessionAuthObjective_);
        }
        if (this.pod_.getPodUrl() == null) {
            this.sessionAuthObjective_.setObjectiveStatus(ComponentStatus.Failed, this.error("No key manager URL for this pod.", new Object[0]), new Object[0]);
        } else {
            this.println("Checking Key Manager");
            this.println("====================");
            this.probe("Key Manager", this.pod_.getKeyManagerUrl(), false, null);
        }
        if (this.pod_.getKeyAuthUrl() == null) {
            this.keyAuthObjective_.setObjectiveStatus(ComponentStatus.Failed, this.error("No key auth URL for this pod.", new Object[0]), new Object[0]);
        } else {
            this.println("Checking Key Auth");
            this.println("=================");
            this.probe("Key Auth", this.createURL(this.pod_.getKeyAuthUrl(), "/v1/authenticate"), true, this.keyAuthObjective_);
        }
    }

    private String validateKeyStore(String name, String keystore, String storetype, char[] storepass, boolean isKeyStore, IObjective objective) {
        boolean warn = false;
        this.beginSubTask("Validate %s %s", name, keystore);
        try {
            File keyStoreFile = new File(keystore);
            if (!keyStoreFile.isFile()) {
                objective.setObjectiveStatus(ComponentStatus.Failed, "Not a file", new Object[0]);
                String string = this.error("%s is not a valid file", name);
                return string;
            }
            if (!keyStoreFile.canRead()) {
                objective.setObjectiveStatus(ComponentStatus.Failed, "Not readable", new Object[0]);
                String string = this.error("%s is not readable", name);
                return string;
            }
            KeyStore keyStore = storetype == null ? KeyStore.getInstance(KeyStore.getDefaultType()) : KeyStore.getInstance(storetype);
            try {
                Throwable throwable = null;
                Object var11_20 = null;
                try (FileInputStream in = new FileInputStream(keyStoreFile);){
                    keyStore.load(in, storepass);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                objective.setObjectiveStatus(ComponentStatus.Failed, "Not valid keystore file (%s)", e);
                String string = this.error((Throwable)e, "%s is not readable", name);
                this.println();
                return string;
            }
            ArrayList<String> aliases = new ArrayList<String>();
            Enumeration<String> it = keyStore.aliases();
            while (it.hasMoreElements()) {
                aliases.add(it.nextElement());
            }
            if (aliases.isEmpty()) {
                objective.setObjectiveStatus(ComponentStatus.Failed, "Empty Keystore", new Object[0]);
                String string = this.error("%s is empty", name);
                return string;
            }
            if (isKeyStore && aliases.size() != 1) {
                warn = true;
                objective.setObjectiveStatus(ComponentStatus.Warning, "Keystore has multiple entries", new Object[0]);
                this.error("%s has %d entries", name, aliases.size());
            } else {
                this.printfln("%s has %d entries", name, aliases.size());
            }
            for (String alias : aliases) {
                if (keyStore.isCertificateEntry(alias)) {
                    Certificate cert = keyStore.getCertificate(alias);
                    if (cert == null) {
                        this.error("%-20s is an unreadable Trusted Certificate", alias);
                        continue;
                    }
                    this.printfln("%-20s is a Trusted Certificate", alias);
                    X509Certificate x509Cert = (X509Certificate)cert;
                    String dn = x509Cert.getSubjectX500Principal().getName();
                    String cn = CheckCerts.getCommonName(x509Cert.getSubjectX500Principal());
                    this.printfln("                     %-20s %s", cn, dn);
                    this.validateCert(alias, x509Cert, objective);
                    continue;
                }
                if (!keyStore.isKeyEntry(alias)) continue;
                try {
                    Key key = keyStore.getKey(alias, storepass);
                    this.printfln("%-20s is a %s Private Key", alias, key.getAlgorithm());
                    Certificate[] certs = keyStore.getCertificateChain(alias);
                    if (certs == null) {
                        this.error("There are no certificates attached to this private key", new Object[0]);
                        continue;
                    }
                    int i = 0;
                    Certificate[] certificateArray = certs;
                    int n = certs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Certificate cert = certificateArray[n2];
                        X509Certificate x509Cert = (X509Certificate)cert;
                        String dn = x509Cert.getSubjectX500Principal().getName();
                        String cn = CheckCerts.getCommonName(x509Cert.getSubjectX500Principal());
                        this.printfln("        cert[%02d] %-20s %s", i++, cn, dn);
                        this.validateCert(alias, x509Cert, objective);
                        if (isKeyStore && this.clientCertCommonName_ == null) {
                            this.clientCertCommonName_ = cn;
                        }
                        ++n2;
                    }
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    String string = this.printfln("%-20s is an unreadable Private Key (%s)", alias, e.getMessage());
                    this.println();
                    return string;
                }
            }
            if (!warn) {
                if (isKeyStore) {
                    objective.setObjectiveStatus(ComponentStatus.OK, "Account Name: %s", this.clientCertCommonName_);
                } else {
                    objective.setObjectiveStatusOK();
                }
            }
            return null;
        }
        catch (KeyStoreException e) {
            objective.setObjectiveStatus(ComponentStatus.Failed, "Invalid keystore type \"%s\"", storetype);
            String string = this.error((Throwable)e, "Unable to validate keystore", new Object[0]);
            return string;
        }
        finally {
            this.println();
        }
    }

    private void validateCert(X509Certificate x509Cert, IObjective objective) {
        String dn = x509Cert.getSubjectX500Principal().getName();
        String cn = CheckCerts.getCommonName(x509Cert.getSubjectX500Principal());
        this.validateCert(cn, x509Cert, objective);
    }

    private void validateCert(String alias, X509Certificate x509Cert, IObjective objective) {
        Date now = new Date();
        if (x509Cert.getNotBefore().after(now)) {
            this.printfln("                     %-20s %s", ERROR, "Certificate is not valid until " + x509Cert.getNotBefore());
            if (objective != null) {
                objective.setObjectiveStatus(ComponentStatus.Error, "Certificate \"%s\" is not valid until %s", alias, x509Cert.getNotBefore());
            }
        }
        if (x509Cert.getNotAfter().before(now)) {
            this.printfln("                     %-20s %s", ERROR, "Certificate expired on " + x509Cert.getNotBefore());
            if (objective != null) {
                objective.setObjectiveStatus(ComponentStatus.Error, "Certificate \"%s\" expired on %s", alias, x509Cert.getNotAfter());
            }
        }
    }

    private String probe(String name, URL url, boolean authenticate, IObjective objective) {
        HttpURLConnection connection;
        JCurl jCurl;
        JCurl.Builder builder;
        try {
            builder = this.getJCurl().trustAllCertificates(true).trustAllHostnames(true);
            if (authenticate) {
                builder.method(JCurl.HttpMethod.POST);
            }
            jCurl = builder.build();
            connection = jCurl.connect(url);
            this.println(String.valueOf(name) + " is reachable bypasssing server cert checks, status: " + connection.getResponseCode());
            JCurl.Response jcr = jCurl.processResponse(connection);
            Certificate[] certs = jcr.getServerCertificates();
            this.println("Server cert chain is:");
            Certificate[] certificateArray = certs;
            int n = certs.length;
            int n2 = 0;
            while (n2 < n) {
                Certificate cert = certificateArray[n2];
                X509Certificate x509Cert = (X509Certificate)cert;
                this.println(x509Cert.getSubjectX500Principal().getName());
                this.validateCert(x509Cert, objective);
                ++n2;
            }
        }
        catch (SSLHandshakeException e) {
            if (authenticate) {
                if (objective != null) {
                    objective.setObjectiveStatus(ComponentStatus.Failed, CERTS_ARE_BAD_AUTH, new Object[0]);
                }
                return this.error("%s is NOT reachable - Client Cert Rejected%n%s%n", name, CERTS_ARE_BAD_AUTH);
            }
            if (objective != null) {
                objective.setObjectiveStatus(ComponentStatus.Failed, WE_CANT_TELL, new Object[0]);
            }
            return this.error("%s is NOT reachable (SSL problem)%n%s%n", name, WE_CANT_TELL);
        }
        catch (IOException e) {
            if (objective != null) {
                objective.setObjectiveStatus(ComponentStatus.Failed, WE_CANT_TELL, new Object[0]);
            }
            return this.error((Throwable)e, "%s is NOT reachable%n%s%n", name, WE_CANT_TELL);
        }
        catch (CertificateParsingException e) {
            if (objective != null) {
                objective.setObjectiveStatus(ComponentStatus.Failed, WE_CANT_TELL, new Object[0]);
            }
            return this.error((Throwable)e, "%s is reachable but we can't parse their certificates.%n%s%n", name, WE_CANT_TELL);
        }
        try {
            builder = this.getJCurl();
            if (authenticate) {
                builder.method(JCurl.HttpMethod.POST);
            }
            jCurl = builder.build();
            connection = jCurl.connect(url);
            if (authenticate) {
                if (connection.getResponseCode() == 200) {
                    if (objective != null) {
                        objective.setObjectiveStatus(ComponentStatus.OK, AUTHENTICATED, new Object[0]);
                    }
                    return this.printf("%s is reachable%n", name, CERTS_ARE_GOOD);
                }
                if (connection.getResponseCode() == 401) {
                    if (objective != null) {
                        objective.setObjectiveStatus(ComponentStatus.Failed, CERTS_ARE_BAD_ACCOUNT, new Object[0]);
                    }
                    return this.printfln("%s is reachable, but authentication is rejected%nThe account \"%s\" probably does not exist in this pod.%n%s", name, this.clientCertCommonName_, CERTS_ARE_BAD_ACCOUNT);
                }
                if (objective != null) {
                    objective.setObjectiveStatus(ComponentStatus.Error, CERTS_ARE_BAD_UNKNOWN, connection.getResponseCode());
                }
                return this.error("%s is reachable, with unexpected status: %d", name, connection.getResponseCode());
            }
            if (objective != null) {
                objective.setObjectiveStatus(ComponentStatus.OK, CERTS_ARE_GOOD_SERVER, new Object[0]);
            }
            return this.printf("%s is reachable, status: %d%n", name, connection.getResponseCode(), CERTS_ARE_GOOD_SERVER);
        }
        catch (SSLHandshakeException e) {
            if (objective != null) {
                objective.setObjectiveStatus(ComponentStatus.Error, CERTS_ARE_BAD_TRUST, new Object[0]);
            }
            return this.error("%s is NOT reachable - SSL Problem%n%s%n", name, CERTS_ARE_BAD_TRUST);
        }
        catch (IOException e) {
            if (objective != null) {
                objective.setObjectiveStatus(ComponentStatus.Failed, WE_CANT_TELL, new Object[0]);
            }
            return this.error((Throwable)e, "%s is NOT reachable.%n%s", name, WE_CANT_TELL);
        }
    }

    private static String getCommonName(X500Principal principal) {
        Pattern p = Pattern.compile("(^|,)CN=([^,]*)(,|$)");
        Matcher m = p.matcher(principal.getName());
        m.find();
        try {
            return m.group(2);
        }
        catch (IllegalStateException e) {
            return principal.getName();
        }
    }
}

