/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.probe;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateParsingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.symphonyoss.symphony.jcurl.JCurl;
import org.symphonyoss.symphony.tools.rest.SrtCommand;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.model.IModelObject;
import org.symphonyoss.symphony.tools.rest.model.IModelObjectContainer;
import org.symphonyoss.symphony.tools.rest.model.IPod;
import org.symphonyoss.symphony.tools.rest.model.ModelObject;
import org.symphonyoss.symphony.tools.rest.model.osmosis.ComponentStatus;
import org.symphonyoss.symphony.tools.rest.util.IObjective;
import org.symphonyoss.symphony.tools.rest.util.home.ISrtHome;

public class CheckPod
extends SrtCommand {
    private static final String PROGRAM_NAME = "CheckPod";
    private static final String CANNOT_CONNECT = "Cannot Connect";
    private IPod pod_;
    private boolean structureChange_;
    private Set<IModelObject> changedComponents_ = new HashSet<IModelObject>();
    private IObjective podObjective_;

    public static void main(String[] argv) throws IOException {
        new CheckPod(argv).run();
    }

    public CheckPod(IConsole console, ISrtHome srtHome) {
        super(PROGRAM_NAME, console, srtHome);
    }

    public CheckPod(String[] argv) {
        super(PROGRAM_NAME, argv);
    }

    @Override
    protected void init() {
        super.init();
        this.withHostName(true);
        this.withKeystore(false);
        this.withTruststore(false);
        this.podObjective_ = this.createObjective("Check Pod");
    }

    public IObjective getPodObjective() {
        return this.podObjective_;
    }

    @Override
    public void execute() {
        this.pod_ = this.getSrtHome().getPodManager().getPod(this.getFqdn());
        if (this.pod_ == null) {
            this.flush();
            this.error(String.valueOf(this.getFqdn()) + " is not a known pod. Try probe instead?", new Object[0]);
            return;
        }
        if (this.getQuiet().getCount() == 0) {
            this.println("Pod Configuration");
            this.println("=================");
            this.pod_.print(this.getConsole());
            this.println();
        }
        int totalWork = 1;
        this.beginTask(totalWork, "Checking %s", this.getFqdn());
        this.probePod();
        this.taskWorked(1);
    }

    private void probePod() {
        try {
            this.println("Checking Pod");
            this.println("=============");
            this.pod_.visit(component -> component.resetStatus());
            URL url = this.createURL(this.pod_.getPodUrl(), "/webcontroller/HealthCheck");
            JCurl jCurl = this.getJCurl().build();
            HttpURLConnection connection = jCurl.connect(url);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: 
                case 500: {
                    break;
                }
                default: {
                    this.println("Healthcheck failed.");
                    this.pod_.setComponentStatus(ComponentStatus.Failed, "Error " + connection.getResponseCode());
                    this.pod_.getManager().modelObjectChanged(this.pod_);
                    return;
                }
            }
            JCurl.Response response = jCurl.processResponse(connection);
            JsonNode healthJson = response.getJsonNode();
            if (healthJson == null) {
                this.println("This looks a lot like a Symphony Pod, but it isn't");
                this.pod_.setComponentStatus(ComponentStatus.Failed, "Non-JSON response from HealthCheck");
                this.pod_.getManager().modelObjectChanged(this.pod_);
                return;
            }
            if (!healthJson.isObject()) {
                this.println("This looks like a Symphony Pod, but the healthcheck returns something other than an object");
                this.println(healthJson);
                this.pod_.setComponentStatus(ComponentStatus.Failed, String.format("Received a JSON %s from HealthCheck, but we expect an object", healthJson.getNodeType()));
                this.pod_.getManager().modelObjectChanged(this.pod_);
                return;
            }
            Iterator it = healthJson.fieldNames();
            int failedComponents = 0;
            int totalComponents = 0;
            while (it.hasNext()) {
                String name = (String)it.next();
                boolean healthy = healthJson.get(name).asBoolean();
                this.printf("%30s %s\n", name, healthy);
                this.pod_.getComponent(name, (parent, componentName) -> {
                    ModelObject component = new ModelObject((IModelObjectContainer)this.pod_, "Component", componentName);
                    this.structureChange_ = true;
                    return component;
                }, existingComponent -> {
                    boolean bl = this.changedComponents_.add((IModelObject)existingComponent);
                }).setComponentStatus(healthy ? ComponentStatus.OK : ComponentStatus.Failed, "");
                if (!healthy) {
                    ++failedComponents;
                }
                ++totalComponents;
            }
            switch (responseCode) {
                case 200: {
                    this.println("Pod is healthy.");
                    if (failedComponents == 0) {
                        this.pod_.setComponentStatus(ComponentStatus.OK, "Healthcheck OK");
                        this.podObjective_.setObjectiveStatusOK();
                        break;
                    }
                    String msg = String.format("Healthcheck OK but %d of %d non-critical components failed", failedComponents, totalComponents);
                    this.pod_.setComponentStatus(ComponentStatus.Error, msg);
                    this.podObjective_.setObjectiveStatus(ComponentStatus.Error, msg, new Object[0]);
                    break;
                }
                case 500: {
                    this.println("Pod is unwell.");
                    String msg = String.format("Healthcheck FAILED (%d of %d components failed)", failedComponents, totalComponents);
                    this.pod_.setComponentStatus(ComponentStatus.Failed, msg);
                    this.podObjective_.setObjectiveStatus(ComponentStatus.Failed, msg, new Object[0]);
                    break;
                }
                default: {
                    String msg = "Unexpected Error " + responseCode;
                    this.pod_.setComponentStatus(ComponentStatus.Failed, msg);
                    this.podObjective_.setObjectiveStatus(ComponentStatus.Failed, msg, new Object[0]);
                    return;
                }
            }
            if (this.structureChange_) {
                this.pod_.getManager().modelObjectStructureChanged(this.pod_);
            } else {
                for (IModelObject component2 : this.changedComponents_) {
                    this.pod_.getManager().modelObjectChanged(component2);
                }
            }
        }
        catch (IOException | CertificateParsingException e) {
            this.error((Throwable)e, "Cannot connect to pod", new Object[0]);
            this.pod_.setComponentStatus(ComponentStatus.Stopped, CANNOT_CONNECT);
            this.podObjective_.setObjectiveStatus(ComponentStatus.Stopped, CANNOT_CONNECT, new Object[0]);
            this.pod_.getManager().modelObjectChanged(this.pod_);
        }
    }
}

