/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.probe;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.MalformedURLException;
import java.net.URL;
import org.symphonyoss.symphony.jcurl.JCurl;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;

public class Probe {
    private final int port_;
    private final String basePath_;
    private final String hostName_;
    private final URL baseUrl_;
    private URL probeUrl_;
    private String expectedContentType_;
    private int httpStatus_;
    private JCurl.Response jcurlResponse_;
    private boolean failed_ = true;
    private boolean failedCertAuth_;
    private boolean unhealthy_;
    private boolean valid_;

    public Probe(String name, String suffix, String domain, int port, String basePath) {
        try {
            this.port_ = port;
            this.basePath_ = basePath;
            this.hostName_ = String.valueOf(name) + suffix + domain;
            this.probeUrl_ = this.baseUrl_ = new URL("https://" + this.hostName_ + (port == 443 ? "" : ":" + this.port_) + this.basePath_);
        }
        catch (MalformedURLException e) {
            throw new ProgramFault(e);
        }
    }

    public Probe setProbePath(String probePath, String expectedContentType) {
        String base = this.baseUrl_.toString();
        while (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        try {
            this.probeUrl_ = new URL(String.valueOf(base) + probePath);
        }
        catch (MalformedURLException e) {
            throw new ProgramFault(e);
        }
        this.expectedContentType_ = expectedContentType;
        this.failed_ = true;
        this.unhealthy_ = false;
        this.valid_ = false;
        this.jcurlResponse_ = null;
        return this;
    }

    public boolean isFailed() {
        return this.failed_;
    }

    public boolean setFailed(boolean failed) {
        this.failed_ = failed;
        return this.failed_;
    }

    public JsonNode getJsonNode() {
        if (this.jcurlResponse_ == null) {
            return null;
        }
        return this.jcurlResponse_.getJsonNode();
    }

    public String getHostName() {
        return this.hostName_;
    }

    public URL getBaseUrl() {
        return this.baseUrl_;
    }

    public URL getProbeUrl() {
        return this.probeUrl_;
    }

    public String getExpectedContentType() {
        return this.expectedContentType_;
    }

    public JCurl.Response getJcurlResponse() {
        return this.jcurlResponse_;
    }

    public JCurl.Response setJcurlResponse(JCurl.Response jcurlResponse) {
        this.jcurlResponse_ = jcurlResponse;
        return this.jcurlResponse_;
    }

    public int getHttpStatus() {
        return this.httpStatus_;
    }

    public int setHttpStatus(int httpStatus) {
        this.httpStatus_ = httpStatus;
        return this.httpStatus_;
    }

    public boolean isFailedCertAuth() {
        return this.failedCertAuth_;
    }

    public boolean setFailedCertAuth(boolean failedCertAuth) {
        this.failedCertAuth_ = failedCertAuth;
        return this.failedCertAuth_;
    }

    public int getPort() {
        return this.port_;
    }

    public boolean isResponseTypeValid() {
        return this.expectedContentType_ == null || this.jcurlResponse_.getContentType().equals(this.expectedContentType_);
    }

    public String getHostNameAndPort() {
        return String.valueOf(this.hostName_) + ":" + this.port_;
    }

    public boolean isUnhealthy() {
        return this.unhealthy_;
    }

    public void setUnhealthy(boolean unhealty) {
        this.unhealthy_ = unhealty;
    }

    public boolean isValid() {
        return this.valid_;
    }

    public void setValid(boolean valid) {
        this.valid_ = valid;
    }
}

