/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.probe;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLHandshakeException;
import org.symphonyoss.symphony.jcurl.JCurl;
import org.symphonyoss.symphony.tools.rest.Srt;
import org.symphonyoss.symphony.tools.rest.SrtCommand;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.model.Agent;
import org.symphonyoss.symphony.tools.rest.model.IPod;
import org.symphonyoss.symphony.tools.rest.model.InvalidConfigException;
import org.symphonyoss.symphony.tools.rest.model.Pod;
import org.symphonyoss.symphony.tools.rest.model.osmosis.ComponentStatus;
import org.symphonyoss.symphony.tools.rest.probe.Probe;
import org.symphonyoss.symphony.tools.rest.probe.ScanResponse;
import org.symphonyoss.symphony.tools.rest.util.IObjective;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;
import org.symphonyoss.symphony.tools.rest.util.SubTaskMonitor;
import org.symphonyoss.symphony.tools.rest.util.command.Switch;
import org.symphonyoss.symphony.tools.rest.util.home.ISrtHome;

public class ProbePod
extends SrtCommand {
    private static final String PROGRAM_NAME = "ProbePod";
    private static final int[] POD_PORTS = new int[]{443, 8443};
    private static final int[] AUTH_PORTS = new int[]{8444, 8445, 8446};
    private static final int[] AgentPorts = new int[]{443, 8444, 8445, 8446};
    private static final String[] SUFFIXES = new String[]{"-api", ""};
    private static final int PROBE_POD_WORK = 6;
    private static final int AUTH_PROBE_WORK = 1;
    private static final int AGENT_PROBE_WORK = 1;
    private static final int SAVE_CONFIG_WORK = 2;
    private static final String WEBSITE_NOT_POD = "This is a website but not a pod";
    private static final String PROBING = "Probing...";
    private static final String NO_WEB_SERVER = "There is no web server here";
    private static final String UNABLE_TO_LOCATE_URL = "Unable to locate URL";
    private static final String UNABLE_TO_AUTHENTICATE = "Unable to authenticate";
    private boolean podHealthy_;
    private int podId_;
    private ScanResponse sessionAuthResponse_;
    private ScanResponse keyAuthResponse_;
    private Probe sessionInfoResult_;
    private ScanResponse agentResponse_;
    private Pod.Builder podConfig_ = Pod.newBuilder();
    private Agent.Builder agentConfig_ = Agent.newBuilder();
    private Set<X509Certificate> serverCerts_ = new HashSet<X509Certificate>();
    private Switch overwriteConfig_;
    private IObjective podObjective_;
    private IObjective keyManagerObjective_;
    private IObjective podApiObjective_;
    private IObjective agentObjective_;
    private IObjective sessionAuthObjective_;
    private IObjective keyAuthObjective_;
    private String sessionToken_;
    private String keymanagerToken_;

    public static void main(String[] argv) throws IOException {
        new ProbePod(argv).run();
    }

    public ProbePod(IConsole console, ISrtHome srtHome) {
        super(PROGRAM_NAME, console, srtHome);
    }

    public ProbePod(String[] argv) {
        super(PROGRAM_NAME, argv);
    }

    @Override
    protected void init() {
        super.init();
        this.withHostName(true);
        this.withKeystore(false);
        this.withTruststore(false);
        this.overwriteConfig_ = new Switch('s', "Overwrite Config", "Overwrite any existingsaved config for this pod", 1);
        this.getParser().withSwitch(this.overwriteConfig_);
        this.podObjective_ = this.createObjective("Locate Pod");
        this.sessionAuthObjective_ = this.createObjective("Locate Session Auth Endpoint");
        this.podApiObjective_ = this.createObjective("Locate Pod API Endpoint");
        this.keyManagerObjective_ = this.createObjective("Locate Key Manager");
        this.keyAuthObjective_ = this.createObjective("Locate Key Manager Auth Endpoint");
        this.agentObjective_ = this.createObjective("Locate Agent");
    }

    @Override
    protected JCurl.Builder getJCurl() {
        JCurl.Builder builder = super.getJCurl().trustAllHostnames(true).trustAllCertificates(true);
        return builder;
    }

    @Override
    public void execute() {
        Iterator<X509Certificate> keyManagerDomain;
        this.podConfig_.setName(this.getFqdn());
        IPod pod = this.getSrtHome().getPodManager().getPod(this.getFqdn());
        int totalWork = 6 * POD_PORTS.length + 1 + 1 + 2;
        this.beginTask(totalWork, "Probing %s for a Pod", this.getFqdn());
        this.podObjective_.setObjectiveStatus(ComponentStatus.Starting, PROBING, new Object[0]);
        this.podApiObjective_.setObjectiveStatus(ComponentStatus.Starting, PROBING, new Object[0]);
        this.sessionAuthObjective_.setObjectiveStatus(ComponentStatus.Starting, PROBING, new Object[0]);
        this.println("Probing for Pod");
        this.println("===============");
        int skippedWork = 6 * POD_PORTS.length;
        int[] nArray = POD_PORTS;
        int n = POD_PORTS.length;
        int n2 = 0;
        while (n2 < n) {
            int port = nArray[n2];
            if (this.isTaskCanceled()) {
                return;
            }
            this.probePod(port);
            skippedWork -= 6;
            if (this.podConfig_.getPodUrl() != null) break;
            ++n2;
        }
        if (skippedWork > 0) {
            this.taskWorked(skippedWork);
        }
        if (this.podConfig_.getWebUrl() == null) {
            this.flush();
            this.error("Probe did not even find a website.", new Object[0]);
            this.podObjective_.setObjectiveStatus(ComponentStatus.Failed, NO_WEB_SERVER, new Object[0]);
            this.podObjective_.setObjectiveStatus(ComponentStatus.Failed, NO_WEB_SERVER, new Object[0]);
            this.podApiObjective_.setObjectiveStatus(ComponentStatus.Failed, NO_WEB_SERVER, new Object[0]);
            this.sessionAuthObjective_.setObjectiveStatus(ComponentStatus.Failed, NO_WEB_SERVER, new Object[0]);
            return;
        }
        if (this.podConfig_.getPodUrl() == null) {
            this.println();
            this.println("Probe Reveals a Website but no Pod");
            this.println("==================================");
            String format = "%-20s=%s\n";
            this.printf(format, "Web URL", this.podConfig_.getWebUrl());
            this.println();
            this.podObjective_.setObjectiveStatus(ComponentStatus.Failed, WEBSITE_NOT_POD, new Object[0]);
            this.podApiObjective_.setObjectiveStatus(ComponentStatus.Failed, WEBSITE_NOT_POD, new Object[0]);
            this.sessionAuthObjective_.setObjectiveStatus(ComponentStatus.Failed, WEBSITE_NOT_POD, new Object[0]);
            return;
        }
        if (this.isTaskCanceled()) {
            return;
        }
        this.podObjective_.setObjectiveStatusOK();
        if (this.podConfig_.getPodApiUrl() == null) {
            this.podApiObjective_.setObjectiveStatus(ComponentStatus.Failed, UNABLE_TO_LOCATE_URL, new Object[0]);
        } else {
            this.podApiObjective_.setObjectiveStatusOK();
        }
        if (this.podConfig_.getSessionAuthUrl() == null) {
            this.sessionAuthObjective_.setObjectiveStatus(ComponentStatus.Failed, UNABLE_TO_LOCATE_URL, new Object[0]);
        } else if (this.sessionToken_ == null) {
            this.sessionAuthObjective_.setObjectiveStatus(ComponentStatus.Warning, UNABLE_TO_AUTHENTICATE, new Object[0]);
        } else {
            this.sessionAuthObjective_.setObjectiveStatusOK();
        }
        if (this.podConfig_.getKeyManagerUrl() == null) {
            this.println("No podInfo, try to look for an in-cloud key manager...");
            this.podConfig_.setKeyManagerUrl(this.createURL(this.podConfig_.getPodUrl(), "/relay"));
        }
        if (this.podConfig_.getKeyManagerUrl() == null) {
            this.podObjective_.setObjectiveStatus(ComponentStatus.Failed, "Can't get podinfo", new Object[0]);
            return;
        }
        this.keyManagerObjective_.setObjectiveStatus(ComponentStatus.Starting, PROBING, new Object[0]);
        URL kmUrl = this.podConfig_.getKeyManagerUrl();
        String keyManagerName = kmUrl.getHost();
        int i = keyManagerName.indexOf(46);
        if (i == -1) {
            keyManagerDomain = ".symphony.com";
        } else {
            keyManagerDomain = keyManagerName.substring(i);
            keyManagerName = keyManagerName.substring(0, i);
        }
        this.println("keyManagerName=" + keyManagerName);
        this.println("keyManagerDomain=" + (String)((Object)keyManagerDomain));
        this.println("Found key manager at " + this.podConfig_.getKeyManagerUrl());
        this.keyManagerObjective_.setObjectiveStatusOK();
        if (this.isTaskCanceled()) {
            return;
        }
        this.println();
        this.println("Probing for API Keyauth");
        this.println("=======================");
        this.keyAuthObjective_.setObjectiveStatus(ComponentStatus.Starting, PROBING, new Object[0]);
        SubTaskMonitor subTaskMonitor = new SubTaskMonitor(this.getConsole(), "Probing for API Keyauth", 1);
        this.keyAuthResponse_ = this.probeAuth("Key Auth", "/keyauth", keyManagerName, (String)((Object)keyManagerDomain));
        if (this.keyAuthResponse_ != null) {
            this.podConfig_.setKeyAuthUrl(this.getUrl(this.keyAuthResponse_, "token"));
            String token = this.getTag(this.keyAuthResponse_, "token");
            if (token != null) {
                this.keymanagerToken_ = token;
                this.getSrtHome().saveSessionToken(this.getFqdn(), "keyManagerToken", token);
            }
        }
        if (this.podConfig_.getSessionAuthUrl() == null) {
            this.keyAuthObjective_.setObjectiveStatus(ComponentStatus.Failed, UNABLE_TO_LOCATE_URL, new Object[0]);
        } else if (this.keymanagerToken_ == null) {
            this.keyAuthObjective_.setObjectiveStatus(ComponentStatus.Warning, UNABLE_TO_AUTHENTICATE, new Object[0]);
        } else {
            this.keyAuthObjective_.setObjectiveStatusOK();
        }
        if (subTaskMonitor.worked(1)) {
            return;
        }
        this.agentObjective_.setObjectiveStatus(ComponentStatus.Starting, PROBING, new Object[0]);
        subTaskMonitor = new SubTaskMonitor(this.getConsole(), "Probing for API Agent", 1);
        this.println();
        this.println("Probing for API Agent");
        this.println("=====================");
        this.agentResponse_ = this.probeAgent(this.getName(), this.getDomain());
        URL agentUrl = this.getUrl(this.agentResponse_, null);
        if (agentUrl != null) {
            this.agentConfig_.setName(agentUrl.getHost());
            this.agentConfig_.setAgentApiUrl(agentUrl);
            this.agentObjective_.setObjectiveStatusOK();
        } else {
            this.agentObjective_.setObjectiveStatus(ComponentStatus.Failed, UNABLE_TO_LOCATE_URL, new Object[0]);
        }
        if (subTaskMonitor.worked(1)) {
            return;
        }
        this.println();
        this.println("Probe Successful");
        this.println("================");
        String format = "%-20s=%s\n";
        this.printf(format, "Web URL", this.podConfig_.getWebUrl());
        this.printf(format, "Pod URL", this.podConfig_.getPodUrl());
        this.printf(format, "Pod ID", this.podId_);
        this.printf(format, "Key Manager URL", this.podConfig_.getKeyManagerUrl());
        this.printf(format, "Session Auth URL", this.podConfig_.getSessionAuthUrl());
        this.printf(format, "Key Auth URL", this.podConfig_.getKeyAuthUrl());
        this.printf(format, "Pod API URL", this.podConfig_.getPodApiUrl());
        this.printf(format, "Agent API URL", this.agentConfig_.getAgentApiUrl());
        if (this.getKeystore() != null) {
            this.println();
            this.printf(format, "Client cert", this.getKeystore());
            if (this.sessionInfoResult_.isFailed()) {
                this.println("This cert was not accepted for authentication");
            } else {
                this.println("We authenticated as");
                String[] stringArray = Srt.SESSION_INFO_FIELDS;
                int n3 = Srt.SESSION_INFO_FIELDS.length;
                int n4 = 0;
                while (n4 < n3) {
                    String field = stringArray[n4];
                    this.printf(format, "userInfo." + field, this.sessionInfoResult_.getJcurlResponse().getTag(field));
                    ++n4;
                }
            }
        }
        this.println();
        if (this.isTaskCanceled()) {
            return;
        }
        this.println("Root server certs:");
        for (X509Certificate cert : this.podConfig_.getTrustCerts()) {
            this.println(cert.getSubjectX500Principal().getName());
        }
        this.println();
        this.println("End server certs:");
        for (X509Certificate cert : this.serverCerts_) {
            this.println(cert.getSubjectX500Principal().getName());
        }
        if (this.isTaskCanceled()) {
            return;
        }
        if (pod == null || this.overwriteConfig_.getCount() > 0) {
            System.err.println("OK");
        }
        if (pod == null || this.overwriteConfig_.getCount() > 0) {
            SubTaskMonitor subTaskMonitor2 = new SubTaskMonitor(this.getConsole(), "Saving Configuration", 2);
            try {
                this.getSrtHome().getPodManager().createOrUpdatePod(this.podConfig_, this.agentConfig_);
            }
            catch (IOException | InvalidConfigException e) {
                this.error((Throwable)e, "Faild to save config:", new Object[0]);
            }
            if (subTaskMonitor2.worked(1)) {
                return;
            }
            this.error("Finished.", new Object[0]);
        }
    }

    private URL getUrl(ScanResponse scanResponse, String token) {
        URL url = null;
        if (scanResponse.getValidProbe() != null) {
            url = scanResponse.getValidProbe().getBaseUrl();
            if (token == null) {
                this.println("Found " + scanResponse.getName() + " endpoint at " + url);
            } else if (this.getTag(scanResponse, token) != null) {
                this.println("Found " + scanResponse.getName() + " endpoint at " + url + " and we authenticated!");
            } else {
                this.println("Found " + scanResponse.getName() + " endpoint at " + url + " but we failed to authenticate.");
            }
        } else {
            List<Probe> certAuthProbes = scanResponse.getCertAuthProbes();
            if (certAuthProbes.size() == 1) {
                url = certAuthProbes.get(0).getBaseUrl();
                this.println("Found probable " + scanResponse.getName() + " endpoint at " + url);
            } else if (certAuthProbes.size() > 1) {
                for (Probe p : certAuthProbes) {
                    this.println("Found possible " + scanResponse.getName() + " endpoint at " + p.getBaseUrl());
                }
            } else {
                this.println("Failed to find any " + scanResponse.getName() + " endpoint");
            }
        }
        return url;
    }

    private void probePod(int port) {
        SubTaskMonitor subTaskMonitor = new SubTaskMonitor(this.getConsole(), "Probing Port " + port, 6);
        Probe probe = new Probe(this.getName(), "", this.getDomain(), port, "/");
        this.doProbe(probe);
        if (probe.isFailed()) {
            if (this.probeNonSSL(port)) {
                this.println("This is a non-SSL website");
            } else {
                this.println("This is not a website");
            }
            subTaskMonitor.done();
            return;
        }
        if (this.podConfig_.getWebUrl() == null) {
            this.podConfig_.setWebUrl(probe.getProbeUrl());
        }
        if (subTaskMonitor.worked(1)) {
            return;
        }
        probe = new Probe(this.getName(), this.getDomain(), "", port, "/").setProbePath("/client/index.html", "text/html");
        this.doProbe(probe);
        if (probe.isFailed()) {
            this.println("This is a website but not a Symphony Pod");
            subTaskMonitor.done();
            return;
        }
        Probe healthCheckResult = new Probe(this.getName(), "", this.getDomain(), port, "/").setProbePath("/webcontroller/HealthCheck", "application/json");
        JCurl jcurl = this.getJCurl().build();
        this.doProbe(jcurl, healthCheckResult, 200, 500);
        if (healthCheckResult.isFailed()) {
            this.println("This looks quite like a Symphony Pod, but it isn't");
            subTaskMonitor.done();
            return;
        }
        if (subTaskMonitor.worked(1)) {
            return;
        }
        JsonNode healthJson = healthCheckResult.getJsonNode();
        if (healthJson == null) {
            this.println("This looks a lot like a Symphony Pod, but it isn't");
            subTaskMonitor.done();
            return;
        }
        if (!healthJson.isObject()) {
            this.println("This looks like a Symphony Pod, but the healthcheck returns something other than an object");
            this.println(healthJson);
            subTaskMonitor.done();
            return;
        }
        this.podConfig_.setPodUrl(this.createUrl("https://" + this.getFqdn() + (port == 443 ? "" : ":" + port)));
        this.podHealthy_ = true;
        healthJson.fields().forEachRemaining(field -> {
            if (!((JsonNode)field.getValue()).asBoolean()) {
                this.println(String.valueOf((String)field.getKey()) + " is UNHEALTHY");
                this.podHealthy_ = false;
            }
        });
        if (this.podHealthy_) {
            this.println("We found a Symphony Pod!");
        } else {
            this.println("We found a Symphony Pod, but it's not feeling well");
        }
        this.println();
        this.println("Probing for API Sessionauth");
        this.println("===========================");
        this.sessionAuthResponse_ = this.probeAuth("Session Auth", "/sessionauth", this.getName(), this.getDomain());
        if (subTaskMonitor.worked(1)) {
            return;
        }
        if (this.sessionAuthResponse_ != null) {
            String field2;
            String token = this.getTag(this.sessionAuthResponse_, "token");
            if (token != null) {
                this.sessionToken_ = token;
                this.getSrtHome().saveSessionToken(this.getFqdn(), "sessionToken", token);
            }
            this.podConfig_.setSessionAuthUrl(this.getUrl(this.sessionAuthResponse_, "token"));
            JCurl.Builder builder = this.getJCurl();
            String[] stringArray = Srt.SESSION_INFO_FIELDS;
            int n = Srt.SESSION_INFO_FIELDS.length;
            int n2 = 0;
            while (n2 < n) {
                field2 = stringArray[n2];
                builder.extract(field2, field2);
                ++n2;
            }
            this.cookieAuth(builder);
            this.sessionInfoResult_ = new Probe(this.getName(), this.getDomain(), "", port, "/pod").setProbePath("/v2/sessioninfo", "application/json");
            this.doProbe(builder.build(), this.sessionInfoResult_, new int[0]);
            this.println("JSON=" + this.sessionInfoResult_.getJsonNode());
            if (this.sessionInfoResult_.isFailed()) {
                this.println("Failed to connect to POD API");
                this.podConfig_.setPodApiUrl(this.sessionInfoResult_.getBaseUrl());
            } else {
                this.podConfig_.setPodApiUrl(this.sessionInfoResult_.getBaseUrl());
                this.println("found pod API endpoint at " + this.podConfig_.getPodApiUrl());
                stringArray = Srt.SESSION_INFO_FIELDS;
                n = Srt.SESSION_INFO_FIELDS.length;
                n2 = 0;
                while (n2 < n) {
                    field2 = stringArray[n2];
                    this.printf("%-20s=%s\n", field2, this.sessionInfoResult_.getJcurlResponse().getTag(field2));
                    ++n2;
                }
            }
        }
        if (subTaskMonitor.worked(1)) {
            return;
        }
        JCurl.Builder builder = this.getJCurl().expect(401).expect(200);
        this.cookieAuth(builder);
        Probe checkAuthResult = new Probe(this.getName(), this.getDomain(), "", port, "/").setProbePath("/login/checkauth?type=user", "application/json");
        this.doProbe(builder.build(), checkAuthResult, 200, 401);
        if (subTaskMonitor.worked(1)) {
            return;
        }
        if (checkAuthResult.isFailed()) {
            this.println("Can't do checkauth from this Pod.");
            subTaskMonitor.done();
            return;
        }
        JsonNode checkAuthJson = checkAuthResult.getJsonNode();
        if (checkAuthJson == null) {
            this.println("Invalid checkAuth response");
            subTaskMonitor.done();
            return;
        }
        JsonNode km = checkAuthJson.get("keymanagerUrl");
        if (km == null) {
            this.println("Invalid checkAuth response");
        } else {
            this.podConfig_.setKeyManagerUrl(this.createURL(km.asText()));
            this.println("keyManagerUrl is " + this.podConfig_.getKeyManagerUrl());
        }
        builder = this.getJCurl();
        this.cookieAuth(builder);
        Probe podInfoResult = new Probe(this.getName(), this.getDomain(), "", port, "/").setProbePath("/webcontroller/public/podInfo", "application/json");
        this.doProbe(builder.build(), podInfoResult, new int[0]);
        if (subTaskMonitor.worked(1)) {
            return;
        }
        if (podInfoResult.isFailed()) {
            this.println("Can't get podInfo from this Pod.");
            subTaskMonitor.done();
            return;
        }
        JsonNode podInfoJson = podInfoResult.getJsonNode();
        if (podInfoJson == null) {
            this.println("Invalid podInfo response");
            subTaskMonitor.done();
            return;
        }
        JsonNode podInfoJsonData = podInfoJson.get("data");
        if (podInfoJsonData == null || !podInfoJsonData.isObject()) {
            this.println("This looks like a Symphony Pod, but the podInfo returns something unexpected");
            this.println(podInfoJson);
            subTaskMonitor.done();
            return;
        }
        this.podId_ = podInfoJsonData.get("podId").asInt();
        this.podConfig_.setKeyManagerUrl(this.createURL(podInfoJsonData.get("keyManagerUrl").asText()));
        subTaskMonitor.done();
    }

    private URL createUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ProgramFault(e);
        }
    }

    @Nonnull
    private ScanResponse probeAuth(String title, String basePath, String name, String domain) {
        ScanResponse response = new ScanResponse(title);
        String[] stringArray = SUFFIXES;
        int n = SUFFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            int[] nArray = AUTH_PORTS;
            int n3 = AUTH_PORTS.length;
            int n4 = 0;
            while (n4 < n3) {
                int authPort = nArray[n4];
                Probe probe = new Probe(name, suffix, domain, authPort, basePath);
                JCurl jcurl = this.getJCurl().method(JCurl.HttpMethod.POST).extract("token", "token").build();
                probe.setProbePath("/v1/authenticate", "application/json");
                this.doProbe(jcurl, probe, new int[0]);
                if (!probe.isFailed()) {
                    probe.setValid(true);
                }
                response.add(probe);
                ++n4;
            }
            ++n2;
        }
        return response;
    }

    @Nonnull
    private ScanResponse probeAgent(String name, String domain) {
        ScanResponse response = new ScanResponse("Agent API");
        String[] stringArray = SUFFIXES;
        int n = SUFFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            int[] nArray = AgentPorts;
            int n3 = AgentPorts.length;
            int n4 = 0;
            while (n4 < n3) {
                int authPort = nArray[n4];
                Probe agentProbe = new Probe(name, suffix, domain, authPort, "/agent");
                this.probeAgent(agentProbe);
                response.add(agentProbe);
                ++n4;
            }
            ++n2;
        }
        return response;
    }

    private void probeAgent(Probe probe) {
        JCurl.Builder builder = this.getJCurl().method(JCurl.HttpMethod.POST).data("{ \"message\": \"Hello World\"}");
        this.headerAuth(builder);
        probe.setProbePath("/v1/util/echo", "application/json");
        this.doProbe(builder.build(), probe, new int[0]);
        if (probe.isFailed()) {
            return;
        }
        probe.setValid(true);
    }

    private void doProbe(Probe probe) {
        this.doProbe(this.getJCurl().build(), probe, new int[0]);
    }

    private void doProbe(JCurl jcurl, Probe probe, int ... expectedStatus) {
        block20: {
            try {
                this.println("Probing " + probe.getProbeUrl() + "...");
                HttpURLConnection connection = jcurl.connect(probe.getProbeUrl());
                boolean ok = false;
                int status = connection.getResponseCode();
                probe.setHttpStatus(status);
                if (expectedStatus.length == 0) {
                    ok = status == 200;
                } else {
                    int[] nArray = expectedStatus;
                    int n = expectedStatus.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int exp = nArray[n2];
                        if (status == exp) {
                            ok = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!ok) {
                    this.println("Failed with HTTP status " + probe.getHttpStatus());
                    return;
                }
                JCurl.Response jcr = probe.setJcurlResponse(jcurl.processResponse(connection));
                Certificate[] certs = jcr.getServerCertificates();
                X509Certificate cert = (X509Certificate)certs[certs.length - 1];
                this.podConfig_.addTrustCert(cert);
                this.println("Root server cert " + cert.getSubjectX500Principal().getName());
                cert = (X509Certificate)certs[0];
                this.println("End server cert " + cert.getSubjectX500Principal().getName());
                this.serverCerts_.add(cert);
                if (!probe.isResponseTypeValid()) {
                    return;
                }
                try {
                    probe.setFailed(false);
                }
                catch (SSLHandshakeException e) {
                    String msg = e.getMessage().toLowerCase();
                    if (msg.contains("bad_certificate") || msg.contains("certificate_unknown")) {
                        probe.setFailedCertAuth(true);
                        this.println("Certificate auth required for " + probe.getHostNameAndPort());
                        break block20;
                    }
                    this.println("SSL problem to " + probe.getHostNameAndPort());
                }
                catch (UnknownHostException e) {
                    this.println(String.valueOf(probe.getHostName()) + " is not a valid host name");
                }
                catch (ConnectException | SocketTimeoutException e) {
                    this.println("Cannot connect to " + probe.getHostNameAndPort());
                }
                catch (IOException | CertificateParsingException e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.flush();
            }
        }
    }

    private JCurl.Builder headerAuth(JCurl.Builder builder) {
        String token = this.getTag(this.sessionAuthResponse_, "token");
        if (token != null) {
            builder.header("sessionToken", token);
        }
        if ((token = this.getTag(this.keyAuthResponse_, "token")) != null) {
            builder.header("keyManagerToken", token);
        }
        return builder;
    }

    private String getTag(ScanResponse scanResponse, String tag) {
        if (scanResponse == null) {
            return null;
        }
        Probe probe = scanResponse.getValidProbe();
        if (probe == null) {
            return null;
        }
        return probe.getJcurlResponse().getTag(tag);
    }

    private JCurl.Builder cookieAuth(JCurl.Builder builder) {
        StringBuilder s = new StringBuilder();
        String token = this.getTag(this.sessionAuthResponse_, "token");
        if (token != null) {
            s = this.appendCookie(s, "skey", token);
        }
        if ((token = this.getTag(this.keyAuthResponse_, "token")) != null) {
            s = this.appendCookie(s, "kmsession", token);
        }
        if (s != null) {
            builder.header("Cookie", s.toString());
        }
        return builder;
    }

    private StringBuilder appendCookie(StringBuilder s, String name, String value) {
        if (s == null) {
            s = new StringBuilder();
        } else {
            s.append(";");
        }
        s.append(name);
        s.append("=");
        s.append(value);
        return s;
    }

    private boolean probeNonSSL(int port) {
        JCurl jcurl = this.getJCurl().build();
        try {
            URL url = new URL("http://" + this.getFqdn() + ":" + port);
            HttpURLConnection connection = jcurl.connect(url);
            this.println("response from " + url + " = " + connection.getResponseCode());
            if (connection.getResponseCode() == 200) {
                this.podConfig_.setWebUrl(url);
                return true;
            }
            return false;
        }
        catch (MalformedURLException e) {
            throw new ProgramFault(e);
        }
        catch (IOException e) {
            return false;
        }
    }
}

