/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;

public class CertificateUtils {
    private static JcaX509CertificateConverter x509Converter_ = new JcaX509CertificateConverter().setProvider("BC");

    public static String encode(Collection<X509Certificate> x509CertificateChain) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var3_5 = null;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new OutputStreamWriter(bos));){
                for (X509Certificate cert : x509CertificateChain) {
                    pemWriter.writeObject((Object)cert);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return bos.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new ProgramFault(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] decode(String certData) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (PEMParser pemReader = new PEMParser((Reader)new StringReader(certData));){
                Object certificate;
                ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
                while ((certificate = pemReader.readObject()) != null) {
                    if (certificate instanceof X509Certificate) {
                        result.add((X509Certificate)certificate);
                        continue;
                    }
                    if (certificate instanceof X509CertificateHolder) {
                        JcaX509CertificateConverter jcaX509CertificateConverter = x509Converter_;
                        synchronized (jcaX509CertificateConverter) {
                            result.add(x509Converter_.getCertificate((X509CertificateHolder)certificate));
                            continue;
                        }
                    }
                    throw new ProgramFault("Certificate decode resulted in " + certificate.getClass());
                }
                return result.toArray(new X509Certificate[result.size()]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CertificateException e) {
            throw new IOException("Failed to decode certificate", e);
        }
    }
}

