/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.util.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;
import org.symphonyoss.symphony.tools.rest.util.command.CommandLineParserFault;
import org.symphonyoss.symphony.tools.rest.util.command.Flag;
import org.symphonyoss.symphony.tools.rest.util.command.Switch;

public class CommandLineParser {
    private static final String EM_DASH = "\u2014";
    private String commandName_;
    private Map<String, Flag<?>> flagMap_ = new HashMap();
    private List<Flag<?>> flags_ = new ArrayList();
    private Flag<?> argSetter_;
    private int argc_;
    private Map<Character, Switch> switches_ = new HashMap<Character, Switch>();

    public CommandLineParser(String commandName) {
        this.commandName_ = commandName;
    }

    public CommandLineParser withSwitch(Switch aswitch) {
        if (this.switches_.put(Character.valueOf(aswitch.getName()), aswitch) != null) {
            throw new ProgramFault("Duplicate switch \"" + aswitch.getName() + "\"");
        }
        if (this.flagMap_.containsKey(String.valueOf(aswitch.getName()))) {
            throw new ProgramFault("Switch duplicates flag \"" + aswitch.getName() + "\"");
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandLineParser withFlag(Flag<?> flag) {
        if (flag.getNames().isEmpty()) {
            if (this.argSetter_ != null) throw new ProgramFault("Only one nameless Flag is allowed");
            this.argSetter_ = flag;
        } else {
            for (String name : flag.getNames()) {
                if (name.length() == 1 && this.switches_.containsKey(Character.valueOf(name.charAt(0)))) {
                    throw new ProgramFault("Flag duplicates switch \"" + name + "\"");
                }
                if (this.flagMap_.put(name, flag) == null) continue;
                throw new ProgramFault("Duplicate flag \"" + name + "\"");
            }
        }
        this.flags_.add(flag);
        return this;
    }

    public String getUsage() {
        StringBuilder s = new StringBuilder("Usage: ");
        s.append(this.commandName_);
        if (!this.switches_.isEmpty()) {
            s.append(" [-");
            for (Character c : this.switches_.keySet()) {
                s.append(c);
            }
            s.append("]");
        }
        for (Flag flag : this.flags_) {
            String close = "";
            String sep = "";
            s.append(" ");
            if (!flag.isRequired()) {
                s.append("[");
            }
            if (flag.getNames().size() > 1) {
                s.append("[");
                close = "] ";
            } else {
                close = flag.getNames().isEmpty() ? "" : " ";
            }
            for (String name : flag.getNames()) {
                s.append(sep);
                sep = " | ";
                if (name.length() > 1) {
                    s.append("--");
                } else {
                    s.append("-");
                }
                s.append(name);
            }
            s.append(close);
            s.append(flag.getPrompt().replaceAll("  *", "_"));
            if (!flag.isRequired()) {
                s.append("]");
            }
            if (!flag.isDuplicatesAllowed()) continue;
            s.append("...");
        }
        return s.toString();
    }

    public void process(String[] argv) {
        while (this.argc_ < argv.length) {
            String arg;
            if ((arg = argv[this.argc_++]).startsWith("--")) {
                this.handleFlag(arg.substring(2), arg, argv);
                continue;
            }
            if (arg.startsWith(EM_DASH)) {
                this.handleFlag(arg.substring(1), arg, argv);
                continue;
            }
            if (arg.startsWith("-")) {
                char[] flags = arg.toCharArray();
                int i = 1;
                while (i < flags.length) {
                    Switch s = this.switches_.get(Character.valueOf(flags[i]));
                    if (s == null) {
                        throw new CommandLineParserFault("Unrecognized switch \"" + arg + "\"");
                    }
                    s.increment();
                    ++i;
                }
                continue;
            }
            if (this.argSetter_ == null) {
                throw new CommandLineParserFault("Invalid argument \"" + arg + "\"");
            }
            --this.argc_;
            this.set(null, this.argSetter_, argv);
        }
    }

    private void handleFlag(String flagName, String arg, String[] argv) {
        Flag<?> flag = this.flagMap_.get(flagName);
        if (flag == null) {
            throw new CommandLineParserFault("Unrecognized flag \"" + arg + "\"");
        }
        this.set(arg, flag, argv);
    }

    private void set(String flagName, Flag<?> flag, String[] argv) {
        if (!flag.checkCount()) {
            if (flagName == null) {
                throw new CommandLineParserFault("Duplicate argument values not allowed");
            }
            throw new CommandLineParserFault("Duplicate values for flag \"" + flagName + "\" not allowed");
        }
        if (this.argc_ >= argv.length) {
            if (flagName == null) {
                throw new CommandLineParserFault("Insufficient argument values");
            }
            throw new CommandLineParserFault("Insufficient values for flag \"" + flagName + "\"");
        }
        flag.set(argv[this.argc_++]);
    }

    public String getCommandName() {
        return this.commandName_;
    }

    public List<Flag<?>> getFlags() {
        return this.flags_;
    }

    public Flag<?> getFlag(String name) {
        return this.flagMap_.get(name);
    }

    public Flag<?> getArgSetter() {
        return this.argSetter_;
    }

    public Map<Character, Switch> getSwitches() {
        return this.switches_;
    }
}

