/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.util.home;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Properties;
import org.symphonyoss.symphony.tools.rest.console.IConsole;
import org.symphonyoss.symphony.tools.rest.model.IPodManager;
import org.symphonyoss.symphony.tools.rest.model.PodManager;
import org.symphonyoss.symphony.tools.rest.util.ProgramFault;
import org.symphonyoss.symphony.tools.rest.util.command.CommandLineParserFault;
import org.symphonyoss.symphony.tools.rest.util.home.ISrtHome;

public class SrtHome
implements ISrtHome {
    private final File home_;
    private final String setBy_;
    private final File configDir_;
    private final File sessionDir_;
    private final IConsole console_;
    private final IPodManager podManager_;
    private File defaultsFile_;
    private Properties defaultsProps_;

    public SrtHome(IConsole console) {
        this(console, null, null);
    }

    public SrtHome(IConsole console, String homeStr, String setBy) {
        this.console_ = console;
        this.console_.setDefaultsProvider(this);
        Builder builder = new Builder(homeStr, setBy);
        this.home_ = builder.builderHome_;
        this.setBy_ = builder.setBy_;
        this.console_.printfln("SRT_HOME set by " + this.setBy_, new Object[0]);
        if (!this.home_.exists()) {
            throw new CommandLineParserFault("SRT_HOME \"" + this.home_.getAbsolutePath() + "\" set by " + this.setBy_ + " does not exist.");
        }
        this.configDir_ = new File(this.home_, "config");
        this.configDir_.mkdirs();
        this.sessionDir_ = new File(this.home_, "session");
        this.sessionDir_.mkdirs();
        this.podManager_ = new PodManager(this.configDir_);
        this.defaultsFile_ = new File(this.home_, "defaults.properties");
        this.defaultsProps_ = new Properties();
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (FileReader reader = new FileReader(this.defaultsFile_);){
                this.defaultsProps_.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            throw new ProgramFault("Unable to read defaults file \"" + this.defaultsFile_.getAbsolutePath() + "\"", e);
        }
    }

    @Override
    public File getHome() {
        return this.home_;
    }

    public String getSetBy() {
        return this.setBy_;
    }

    @Override
    public File getConfigDir(String name) {
        return new File(this.configDir_, name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveSessionToken(String hostName, String tokenName, String token) {
        File dir = new File(this.sessionDir_, hostName);
        dir.mkdirs();
        File file = new File(dir, tokenName);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    try (PrintWriter p = new PrintWriter(fos);){
                        p.println(token);
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProgramFault("Unable to save session token " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public IPodManager getPodManager() {
        return this.podManager_;
    }

    @Override
    public String getDefault(String label) {
        return this.defaultsProps_.getProperty(this.labelToPropName(label), "");
    }

    @Override
    public void setDefault(String label, String name) {
        String current = this.defaultsProps_.getProperty(label = this.labelToPropName(label));
        if (current != null && current.equals(name)) {
            return;
        }
        this.defaultsProps_.setProperty(label, name);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileWriter writer = new FileWriter(this.defaultsFile_);){
                this.defaultsProps_.store(writer, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProgramFault("Unable to write defaults file \"" + this.defaultsFile_.getAbsolutePath() + "\"", e);
        }
    }

    private String labelToPropName(String label) {
        return label.replaceAll("  *", "");
    }

    private class Builder {
        private File builderHome_;
        private String setBy_;

        public Builder(String homeStr, String setBy) {
            this.setHome(homeStr, setBy);
            if (this.builderHome_ == null) {
                this.setHome(System.getProperty("SRT_HOME"), "System Property");
            }
            if (this.builderHome_ == null) {
                this.setHome(System.getenv("SRT_HOME"), "Environment Variable");
            }
            if (this.builderHome_ == null) {
                this.builderHome_ = new File(new File(System.getProperty("user.home")), ".srt");
                this.setBy_ = "Default";
                if (!this.builderHome_.exists()) {
                    try {
                        Path dir = this.builderHome_.toPath();
                        Files.createDirectory(dir, new FileAttribute[0]);
                        SrtHome.this.console_.printfln("Default home area \"" + this.builderHome_.getAbsolutePath() + "\" created.", new Object[0]);
                        try {
                            Files.setPosixFilePermissions(dir, EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
                        }
                        catch (UnsupportedOperationException e) {
                            SrtHome.this.console_.printfln("But we are unable to make this drectory read only to the owner, this is expected when running on Windows.", new Object[0]);
                        }
                    }
                    catch (IOException e) {
                        throw new CommandLineParserFault("Cannot create default home area \"" + this.builderHome_.getAbsolutePath() + "\"", e);
                    }
                }
            }
        }

        private void setHome(String homeStr, String setBy) {
            if (homeStr != null && !(homeStr = homeStr.trim()).isEmpty()) {
                this.builderHome_ = new File(homeStr);
                this.setBy_ = setBy;
            }
        }
    }
}

