/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.util.command;

import java.util.ArrayList;
import java.util.List;
import org.symphonyoss.symphony.tools.rest.model.IModelObject;
import org.symphonyoss.symphony.tools.rest.util.typeutils.IGetter;
import org.symphonyoss.symphony.tools.rest.util.typeutils.ISetter;
import org.symphonyoss.symphony.tools.rest.util.typeutils.TypeConverterFactory;

public class Flag<T> {
    private final String prompt_;
    private final ISetter<String> stringSetter_;
    private final ISetter<T> setter_;
    private final IGetter<T> defaultGetter_;
    private String help_;
    private List<String> names_ = new ArrayList<String>();
    private boolean required_;
    private boolean duplicatesAllowed_;
    private int count_;
    private String value_ = "";
    private Class<? extends IModelObject> selectionType_;

    public Flag(String prompt, Class<T> type, ISetter<T> setter) {
        this(prompt, type, setter, null);
    }

    public Flag(String prompt, final Class<T> type, final ISetter<T> setter, IGetter<T> defaultGetter) {
        this.help_ = this.prompt_ = prompt;
        this.setter_ = new ISetter<T>(){

            @Override
            public void set(T value) {
                setter.set(value);
                Flag.this.value_ = value.toString();
            }
        };
        this.defaultGetter_ = defaultGetter;
        this.stringSetter_ = new ISetter<String>(){

            @Override
            public void set(String value) {
                setter.set(TypeConverterFactory.getConverter(String.class, type).convert(value));
                Flag.this.value_ = value;
            }
        };
    }

    public Flag<T> withSelectionType(Class<? extends IModelObject> selectionType) {
        this.selectionType_ = selectionType;
        return this;
    }

    public Class<? extends IModelObject> getSelectionType() {
        return this.selectionType_;
    }

    public boolean isRequired() {
        return this.required_;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed_;
    }

    public Flag<T> withRequired(boolean required) {
        this.required_ = required;
        return this;
    }

    public Flag<T> withDuplicatesAllowed(boolean duplicatesAllowed) {
        this.duplicatesAllowed_ = duplicatesAllowed;
        return this;
    }

    public Flag<T> withName(String name) {
        this.names_.add(name);
        return this;
    }

    public String getHelp() {
        return this.help_;
    }

    public Flag<T> withHelp(String help) {
        this.help_ = help;
        return this;
    }

    public String getPrompt() {
        return this.prompt_;
    }

    public boolean checkCount() {
        return this.duplicatesAllowed_ || this.count_ == 0;
    }

    public int getCount() {
        return this.count_;
    }

    public List<String> getNames() {
        return this.names_;
    }

    public String getDescription() {
        if (this.names_.isEmpty()) {
            return this.prompt_ + " parameter";
        }
        String name = this.names_.get(0);
        return "flag " + (name.length() > 1 ? "--" : "-") + name + " (" + this.prompt_ + ")";
    }

    public String getValue() {
        if (this.defaultGetter_ != null && this.value_.length() == 0) {
            return this.defaultGetter_.get().toString();
        }
        return this.value_;
    }

    public void set(String value) {
        ++this.count_;
        if (value == null) {
            throw new NullPointerException("Null values are not allowed");
        }
        this.stringSetter_.set(value);
    }
}

