/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.tools.rest.util.typeutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.symphonyoss.symphony.tools.rest.util.typeutils.ITypeConverter;

public class TypeConverterFactory {
    private static Map<Class<?>, Map<Class<?>, ?>> converterMap_ = new HashMap();
    private static Map<Class<?>, ITypeConverter<String, ?>> stringConverterMap_ = new HashMap();

    public static <S, T> ITypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
        Map<Class<?>, ?> map = converterMap_.get(sourceType);
        if (map.containsKey(targetType)) {
            return (ITypeConverter)map.get(targetType);
        }
        try {
            Constructor constructor = targetType.getConstructor(sourceType);
            ITypeConverter<Object, Object> converter = v -> {
                try {
                    return constructor.newInstance(v);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            map.put(targetType, converter);
            return converter;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new RuntimeException("Unable to convert from " + sourceType.getName() + " to " + targetType.getName());
        }
    }

    @Nonnull
    public String foo() {
        return null;
    }

    static {
        converterMap_.put(String.class, stringConverterMap_);
        stringConverterMap_.put(String.class, v -> v);
        stringConverterMap_.put(Integer.class, v -> Integer.parseInt(v));
        stringConverterMap_.put(Short.class, v -> Short.parseShort(v));
        stringConverterMap_.put(Long.class, v -> Long.parseLong(v));
        stringConverterMap_.put(Double.class, v -> Double.parseDouble(v));
        stringConverterMap_.put(Float.class, v -> Float.valueOf(Float.parseFloat(v)));
        stringConverterMap_.put(Boolean.class, v -> Boolean.parseBoolean(v));
    }
}

