/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.jcurl;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.UUID;

class MultipartUtility {
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private String charset = "utf-8";
    private OutputStream outputStream;
    private DataOutputStream writer;
    private HttpURLConnection httpConn;

    MultipartUtility(HttpURLConnection httpConn) throws IOException {
        this.httpConn = httpConn;
        this.httpConn.setDoOutput(true);
        this.boundary = this.buildBoundary();
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.outputStream = httpConn.getOutputStream();
        this.writer = new DataOutputStream(this.outputStream);
    }

    private String buildBoundary() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("----MultipartBoundary----");
        sb.append(UUID.randomUUID());
        sb.append("--");
        return sb.toString();
    }

    public void addHeaderField(String name, String value) throws IOException {
        this.writer.writeBytes(name + ": " + value + LINE_FEED);
        this.writer.flush();
    }

    void addFormField(String name, String value) throws IOException {
        this.writer.writeBytes("--" + this.boundary + LINE_FEED);
        this.writer.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"" + LINE_FEED);
        this.writer.writeBytes("Content-Type: text/plain; charset=" + this.charset + LINE_FEED);
        this.writer.writeBytes(LINE_FEED);
        this.writer.writeBytes(value + LINE_FEED);
        this.writer.flush();
    }

    void addFilePart(String fieldName, File uploadFile) throws IOException {
        String fileName = uploadFile.getName();
        this.writer.writeBytes("--" + this.boundary + LINE_FEED);
        this.writer.writeBytes("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"" + LINE_FEED);
        this.writer.writeBytes("Content-Type: " + URLConnection.guessContentTypeFromName(fileName) + LINE_FEED);
        this.writer.writeBytes("Content-Transfer-Encoding: binary\r\n");
        this.writer.writeBytes(LINE_FEED);
        this.writer.flush();
        byte[] uploadData = Files.readAllBytes(uploadFile.toPath());
        this.writer.write(uploadData);
        this.writer.writeBytes(LINE_FEED);
        this.outputStream.flush();
        this.writer.flush();
    }

    void finish() throws IOException {
        this.writer.writeBytes(LINE_FEED);
        this.writer.flush();
        this.writer.writeBytes("--" + this.boundary + "--" + LINE_FEED);
        this.writer.close();
    }
}

