/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.synchronoss.cpo.CpoResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpoBlockingResultSet<E>
implements CpoResultSet<E>,
Iterator<E> {
    private static Logger logger = Logger.getLogger((String)CpoBlockingResultSet.class.getName());
    private static final long serialVersionUID = 1L;
    private int capacity = 0;
    private AtomicInteger aInt = new AtomicInteger(0);
    private ThreadLocal<E> tlObj = new ThreadLocal();
    ArrayBlockingQueue<E> abe = null;
    HashMap<Thread, Thread> producers = new HashMap();
    HashMap<Thread, Thread> consumers = new HashMap();
    boolean done = false;

    public CpoBlockingResultSet(int capacity) {
        this.capacity = capacity;
        this.abe = new ArrayBlockingQueue(capacity);
    }

    public CpoBlockingResultSet(int capacity, boolean fair, Collection<? extends E> c) {
        this.capacity = capacity;
        this.abe = new ArrayBlockingQueue<E>(capacity, fair, c);
    }

    public CpoBlockingResultSet(int capacity, boolean fair) {
        this.capacity = capacity;
        this.abe = new ArrayBlockingQueue(capacity, fair);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.producers.put(Thread.currentThread(), Thread.currentThread());
        logger.debug((Object)"Put Called");
        this.abe.put(e);
        this.aInt.incrementAndGet();
    }

    @Override
    public boolean hasNext() {
        logger.debug((Object)"hasNext Called");
        E ret = this.tlObj.get();
        if (this.isDone() && this.abe.size() == 0 && ret == null) {
            return false;
        }
        if (ret == null) {
            try {
                this.tlObj.set(this.take());
            }
            catch (InterruptedException ie) {
                if (this.isDone() && this.abe.size() == 0) {
                    return false;
                }
                try {
                    this.tlObj.set(this.take());
                }
                catch (InterruptedException ie2) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int size() {
        return this.aInt.get();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E next() throws NoSuchElementException {
        logger.debug((Object)"next Called");
        E ret = this.tlObj.get();
        if (ret == null) {
            try {
                ret = this.take();
            }
            catch (InterruptedException ie) {
                if (this.isDone() && this.abe.size() == 0) {
                    throw new NoSuchElementException();
                }
                try {
                    ret = this.take();
                }
                catch (InterruptedException ie2) {
                    throw new NoSuchElementException();
                }
            }
        } else {
            this.tlObj.set(null);
        }
        return ret;
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    @Override
    public E take() throws InterruptedException {
        this.consumers.put(Thread.currentThread(), Thread.currentThread());
        logger.debug((Object)"Take Called");
        return this.abe.take();
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    @Override
    public void cancel() {
        this.setDone(true);
        for (Thread t : this.consumers.values()) {
            if (t == Thread.currentThread()) continue;
            t.interrupt();
        }
        for (Thread t : this.producers.values()) {
            if (t == Thread.currentThread()) continue;
            t.interrupt();
        }
    }

    @Override
    public int getFetchSize() {
        return this.capacity;
    }
}

