/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.synchronoss.cpo.jdbc.JdbcCallableStatement;
import org.synchronoss.cpo.jdbc.JdbcDataSource;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcConnection
implements Connection {
    private Connection connection_ = null;
    private JdbcDataSource datasource_ = null;
    int TRANSACTION_NONE = 0;
    int TRANSACTION_READ_UNCOMMITTED = 1;
    int TRANSACTION_READ_COMMITTED = 2;
    int TRANSACTION_REPEATABLE_READ = 4;
    int TRANSACTION_SERIALIZABLE = 8;

    private JdbcConnection() {
    }

    public JdbcConnection(JdbcDataSource jds, Connection connection) {
        this.setConnection(connection);
        this.setDataSource(jds);
    }

    protected Connection getConnection() throws SQLException {
        if (this.connection_ == null) {
            throw new SQLException("Connection is closed, cannot perform requested operation");
        }
        return this.connection_;
    }

    protected void setConnection(Connection connection) {
        this.connection_ = connection;
    }

    protected JdbcDataSource getDataSource() throws SQLException {
        if (this.datasource_ == null) {
            throw new SQLException("Connection is closed, cannot perform requested operation");
        }
        return this.datasource_;
    }

    protected void setDataSource(JdbcDataSource datasource) {
        this.datasource_ = datasource;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.getConnection().createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new JdbcPreparedStatement(this.getDataSource().getCachedPreparedStatement(this.getConnection(), sql));
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new JdbcCallableStatement(this.getDataSource().getCachedCallableStatement(this.getConnection(), sql));
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.getConnection().nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getConnection().setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    @Override
    public void close() throws SQLException {
        this.getDataSource().free(this.getConnection());
        this.setConnection(null);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getConnection() == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.getConnection().setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.getConnection().isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.getConnection().setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getConnection().getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.getConnection().setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.getConnection().getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getConnection().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getConnection().clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new JdbcPreparedStatement(this.getDataSource().getCachedPreparedStatement(this.getConnection(), sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new JdbcCallableStatement(this.getDataSource().getCachedCallableStatement(this.getConnection(), sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.getConnection().getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getConnection().setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.getConnection().setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getConnection().getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.getConnection().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getConnection().setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.getConnection().rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getConnection().releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new JdbcPreparedStatement(this.getDataSource().getCachedPreparedStatement(this.getConnection(), sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new JdbcCallableStatement(this.getDataSource().getCachedCallableStatement(this.getConnection(), sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new JdbcPreparedStatement(this.getDataSource().getCachedPreparedStatement(this.getConnection(), sql, autoGeneratedKeys));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new JdbcPreparedStatement(this.getDataSource().getCachedPreparedStatement(this.getConnection(), sql, columnIndexes));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new JdbcPreparedStatement(this.getDataSource().getCachedPreparedStatement(this.getConnection(), sql, columnNames));
    }
}

