/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.synchronoss.cpo.CpoAdapter;
import org.synchronoss.cpo.CpoArrayResultSet;
import org.synchronoss.cpo.CpoBlockingResultSet;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoObject;
import org.synchronoss.cpo.CpoOrderBy;
import org.synchronoss.cpo.CpoResultSet;
import org.synchronoss.cpo.CpoTrxAdapter;
import org.synchronoss.cpo.CpoWhere;
import org.synchronoss.cpo.jdbc.BindAttribute;
import org.synchronoss.cpo.jdbc.JdbcAttribute;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcCpoOrderBy;
import org.synchronoss.cpo.jdbc.JdbcCpoTrxAdapter;
import org.synchronoss.cpo.jdbc.JdbcCpoWhere;
import org.synchronoss.cpo.jdbc.JdbcDataSource;
import org.synchronoss.cpo.jdbc.JdbcDataSourceInfo;
import org.synchronoss.cpo.jdbc.JdbcMetaClass;
import org.synchronoss.cpo.jdbc.JdbcParameter;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcCpoAdapter
implements CpoAdapter {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)JdbcCpoAdapter.class.getName());
    private static final String[] GROUP_IDS = new String[]{"CREATE", "UPDATE", "DELETE", "RETRIEVE", "LIST", "PERSIST", "EXIST", "EXECUTE"};
    private static final String CREATE_GROUP = GROUP_IDS[0];
    private static final String UPDATE_GROUP = GROUP_IDS[1];
    private static final String DELETE_GROUP = GROUP_IDS[2];
    private static final String RETRIEVE_GROUP = GROUP_IDS[3];
    private static final String LIST_GROUP = GROUP_IDS[4];
    private static final String PERSIST_GROUP = GROUP_IDS[5];
    private static final String EXIST_GROUP = GROUP_IDS[6];
    private static final String EXECUTE_GROUP = GROUP_IDS[7];
    private static HashMap<String, HashMap<String, JdbcMetaClass<?>>> dataSourceMap_ = new HashMap();
    private Context context_ = null;
    private DataSource readDataSource_ = null;
    private DataSource writeDataSource_ = null;
    private DataSource metaDataSource_ = null;
    private String metaDataSourceName_ = null;
    private String dbTablePrefix = "";
    private boolean invalidReadConnection_ = false;
    private boolean metaEqualsWrite_ = false;
    private boolean batchUpdatesSupported_ = false;

    protected JdbcCpoAdapter() {
    }

    public JdbcCpoAdapter(JdbcDataSourceInfo jdsi) throws CpoException {
        this(null, jdsi);
    }

    public JdbcCpoAdapter(JdbcDataSourceInfo jdsiMeta, JdbcDataSourceInfo jdsiTrx) throws CpoException {
        if (jdsiMeta != null) {
            this.setDbTablePrefix(jdsiMeta.getDbTablePrefix());
            this.setMetaDataSource(this.getDataSource(jdsiMeta));
            this.setMetaDataSourceName(jdsiMeta.getDataSourceName());
        } else {
            this.setDbTablePrefix(jdsiTrx.getDbTablePrefix());
            this.setMetaDataSource(this.getDataSource(jdsiTrx));
            this.setMetaDataSourceName(jdsiTrx.getDataSourceName());
            this.metaEqualsWrite_ = true;
        }
        this.setWriteDataSource(this.getDataSource(jdsiTrx));
        this.setReadDataSource(this.getWriteDataSource());
        this.processDatabaseMetaData();
    }

    public JdbcCpoAdapter(JdbcDataSourceInfo jdsiMeta, JdbcDataSourceInfo jdsiWrite, JdbcDataSourceInfo jdsiRead) throws CpoException {
        this.setDbTablePrefix(jdsiMeta.getDbTablePrefix());
        this.setMetaDataSource(this.getDataSource(jdsiMeta));
        this.setWriteDataSource(this.getDataSource(jdsiWrite));
        this.setReadDataSource(this.getDataSource(jdsiRead));
        this.setMetaDataSourceName(jdsiMeta.getDataSourceName());
        this.processDatabaseMetaData();
    }

    protected JdbcCpoAdapter(DataSource metaSource, String metaSourceName, boolean batchSupported, String dbTablePrefix) throws CpoException {
        this.setDbTablePrefix(dbTablePrefix);
        this.setMetaDataSource(metaSource);
        this.setMetaDataSourceName(metaSourceName);
        this.batchUpdatesSupported_ = batchSupported;
    }

    private DataSource getDataSource(JdbcDataSourceInfo jdsi) throws CpoException {
        DataSource ds;
        try {
            if (jdsi.getConnectionType() == 4) {
                Context ctx = jdsi.getJndiCtx();
                if (ctx == null) {
                    ctx = new InitialContext();
                }
                ds = (DataSource)ctx.lookup(jdsi.getJndiName());
            } else {
                ds = new JdbcDataSource(jdsi);
            }
        }
        catch (Exception e) {
            throw new CpoException("Error instantiating DataSource", e);
        }
        return ds;
    }

    private void processDatabaseMetaData() throws CpoException {
        Connection c = null;
        try {
            c = this.getWriteConnection();
            DatabaseMetaData dmd = c.getMetaData();
            this.batchUpdatesSupported_ = dmd.supportsBatchUpdates();
            this.closeConnection(c);
        }
        catch (Exception e) {
            logger.fatal((Object)e, (Throwable)e);
            throw new CpoException("Could Not Retrieve Database Meta Data", e);
        }
        finally {
            this.closeConnection(c);
        }
    }

    @Override
    public void clearMetaClass(Object obj) {
        if (obj != null) {
            Class<?> objClass = obj.getClass();
            String className = objClass.getName();
            this.clearMetaClass(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearMetaClass(String className) {
        HashMap<String, HashMap<String, JdbcMetaClass<?>>> hashMap = this.getDataSourceMap();
        synchronized (hashMap) {
            HashMap<String, JdbcMetaClass<?>> metaClassMap = this.getMetaClassMap();
            metaClassMap.remove(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearMetaClass() {
        HashMap<String, HashMap<String, JdbcMetaClass<?>>> hashMap = this.getDataSourceMap();
        synchronized (hashMap) {
            HashMap<String, JdbcMetaClass<?>> metaClassMap = this.getMetaClassMap();
            metaClassMap.clear();
        }
    }

    @Override
    public <T> long insertObject(T obj) throws CpoException {
        return this.processUpdateGroup(obj, CREATE_GROUP, null);
    }

    @Override
    public <T> long insertObject(String name, T obj) throws CpoException {
        return this.processUpdateGroup(obj, CREATE_GROUP, name);
    }

    @Override
    public <T> long insertObjects(Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, CREATE_GROUP, (String)null);
    }

    @Override
    public <T> long insertObjects(String name, Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, CREATE_GROUP, name);
    }

    @Override
    public <T> long deleteObject(T obj) throws CpoException {
        return this.processUpdateGroup(obj, DELETE_GROUP, null);
    }

    @Override
    public <T> long deleteObject(String name, T obj) throws CpoException {
        return this.processUpdateGroup(obj, DELETE_GROUP, name);
    }

    @Override
    public <T> long deleteObjects(Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, DELETE_GROUP, (String)null);
    }

    @Override
    public <T> long deleteObjects(String name, Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, DELETE_GROUP, name);
    }

    @Override
    public <T> T executeObject(T object) throws CpoException {
        return this.processExecuteGroup(null, object, object);
    }

    @Override
    public <T> T executeObject(String name, T object) throws CpoException {
        return this.processExecuteGroup(name, object, object);
    }

    @Override
    public <T, C> T executeObject(String name, C criteria, T result) throws CpoException {
        return this.processExecuteGroup(name, criteria, result);
    }

    @Override
    public <T> long existsObject(T obj) throws CpoException {
        return this.existsObject(null, obj);
    }

    @Override
    public <T> long existsObject(String name, T obj) throws CpoException {
        Connection c = null;
        Connection meta = null;
        long objCount = -1L;
        try {
            c = this.getReadConnection();
            meta = this.metaEqualsWrite_ ? c : this.getMetaConnection();
            objCount = this.existsObject(name, obj, c, meta);
        }
        catch (Exception e) {
            throw new CpoException("existsObjects(String, Object) failed", e);
        }
        finally {
            this.closeConnection(c);
            this.closeConnection(meta);
        }
        return objCount;
    }

    protected <T> long existsObject(String name, T obj, Connection con, Connection metaCon) throws CpoException {
        Statement ps = null;
        ResultSet rs = null;
        JdbcQuery jq = null;
        long objCount = 0L;
        Logger localLogger = logger;
        try {
            JdbcMetaClass<T> jmc = this.getMetaClass(obj, metaCon);
            ArrayList<JdbcQuery> queryGroup = jmc.getQueryGroup(EXIST_GROUP, name);
            localLogger = Logger.getLogger((String)jmc.getJmcClass().getName());
            for (int i = 0; i < queryGroup.size(); ++i) {
                jq = queryGroup.get(i);
                JdbcPreparedStatementFactory jpsf = new JdbcPreparedStatementFactory(con, this, jmc, jq, obj);
                ps = jpsf.getPreparedStatement();
                long qCount = 0L;
                localLogger.info((Object)jq.getText());
                rs = ps.executeQuery();
                jpsf.release();
                ResultSetMetaData rsmd = rs.getMetaData();
                if (rsmd.getColumnCount() == 1 && rs.next()) {
                    try {
                        qCount = rs.getLong(1);
                    }
                    catch (Exception e) {
                        qCount = 1L;
                    }
                    if (rs.next()) {
                        qCount = 2L;
                    }
                }
                while (rs.next()) {
                    ++qCount;
                }
                objCount += qCount;
                rs.close();
                ps.close();
                rs = null;
                ps = null;
            }
        }
        catch (SQLException e) {
            String msg = "existsObject(name, obj, con) failed:";
            if (jq != null) {
                msg = msg + jq.getText();
            }
            localLogger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
        }
        return objCount;
    }

    @Override
    public CpoOrderBy newOrderBy(String attribute, boolean ascending) throws CpoException {
        return new JdbcCpoOrderBy(attribute, ascending);
    }

    @Override
    public CpoOrderBy newOrderBy(String attribute, boolean ascending, String function) throws CpoException {
        return new JdbcCpoOrderBy(attribute, ascending, function);
    }

    @Override
    public CpoWhere newWhere() throws CpoException {
        return new JdbcCpoWhere();
    }

    @Override
    public <T> CpoWhere newWhere(int logical, String attr, int comp, T value) throws CpoException {
        return new JdbcCpoWhere(logical, attr, comp, value);
    }

    @Override
    public <T> CpoWhere newWhere(int logical, String attr, int comp, T value, boolean not) throws CpoException {
        return new JdbcCpoWhere(logical, attr, comp, value, not);
    }

    @Override
    public <T> long persistObject(T obj) throws CpoException {
        return this.processUpdateGroup(obj, PERSIST_GROUP, null);
    }

    @Override
    public <T> long persistObject(String name, T obj) throws CpoException {
        return this.processUpdateGroup(obj, PERSIST_GROUP, name);
    }

    @Override
    public <T> long persistObjects(Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, PERSIST_GROUP, (String)null);
    }

    @Override
    public <T> long persistObjects(String name, Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, PERSIST_GROUP, name);
    }

    @Override
    public <T> T retrieveObject(T obj) throws CpoException {
        T o = this.processSelectGroup(obj, null);
        return o;
    }

    @Override
    public <T> T retrieveObject(String name, T obj) throws CpoException {
        T o = this.processSelectGroup(obj, name);
        return o;
    }

    @Override
    public <T, C> T retrieveObject(String name, C criteria, T result, CpoWhere where, Collection<CpoOrderBy> orderBy) throws CpoException {
        Iterator<T> it = this.processSelectGroup(name, criteria, result, where, orderBy, true).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public <T, C> Collection<T> retrieveObjects(String name, C criteria, T result, CpoWhere where, Collection<CpoOrderBy> orderBy) throws CpoException {
        return this.processSelectGroup(name, criteria, result, where, orderBy, false);
    }

    @Override
    public <T, C> CpoResultSet<T> retrieveObjects(String name, C criteria, T result, CpoWhere where, Collection<CpoOrderBy> orderBy, int queueSize) throws CpoException {
        CpoBlockingResultSet resultSet = new CpoBlockingResultSet(queueSize);
        RetrieverThread<T, C> retrieverThread = new RetrieverThread<T, C>(name, criteria, result, where, orderBy, false, resultSet);
        retrieverThread.start();
        return resultSet;
    }

    @Override
    @Deprecated
    public <T> long transactObjects(Collection<CpoObject<T>> coll) throws CpoException {
        Connection c = null;
        Connection meta = null;
        long updateCount = 0L;
        try {
            c = this.getWriteConnection();
            meta = this.metaEqualsWrite_ ? c : this.getMetaConnection();
            updateCount = this.transactObjects(coll, c, meta);
            this.commitConnection(c);
        }
        catch (Exception e) {
            try {
                this.rollbackConnection(c);
            }
            catch (Exception re) {
                // empty catch block
            }
            if (e instanceof CpoException) {
                throw (CpoException)e;
            }
            throw new CpoException("transactObjects(Collection coll) failed", e);
        }
        finally {
            this.closeConnection(c);
            this.closeConnection(meta);
        }
        return updateCount;
    }

    @Deprecated
    protected <T> long transactObjects(Collection<CpoObject<T>> coll, Connection c, Connection meta) throws CpoException {
        long updateCount = 0L;
        for (CpoObject<T> cpoObject : coll) {
            if (cpoObject.getObject() instanceof Collection) {
                updateCount += this.processUpdateGroup(cpoObject.getObject(), GROUP_IDS[cpoObject.getOperation()], cpoObject.getName(), c, meta);
                continue;
            }
            updateCount += this.processUpdateGroup(cpoObject.getObject(), GROUP_IDS[cpoObject.getOperation()], cpoObject.getName(), c, meta);
        }
        return updateCount;
    }

    @Override
    public <T> long updateObject(T obj) throws CpoException {
        return this.processUpdateGroup(obj, UPDATE_GROUP, null);
    }

    @Override
    public <T> long updateObject(String name, T obj) throws CpoException {
        return this.processUpdateGroup(obj, UPDATE_GROUP, name);
    }

    @Override
    public <T> long updateObjects(Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, UPDATE_GROUP, (String)null);
    }

    @Override
    public <T> long updateObjects(String name, Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, UPDATE_GROUP, name);
    }

    protected void setContext(Context context) throws CpoException {
        try {
            this.context_ = context == null ? new InitialContext() : context;
        }
        catch (NamingException e) {
            throw new CpoException("Error setting Context", e);
        }
    }

    protected Context getContext() {
        return this.context_;
    }

    protected HashMap<String, HashMap<String, JdbcMetaClass<?>>> getDataSourceMap() {
        return dataSourceMap_;
    }

    protected void setDataSourceMap(HashMap<String, HashMap<String, JdbcMetaClass<?>>> dsMap) {
        dataSourceMap_ = dsMap;
    }

    protected <T> String getGroupType(T obj, String type, String name, Connection c, Connection meta) throws CpoException {
        String retType = type;
        if (PERSIST_GROUP.equals(retType)) {
            long objCount = this.existsObject(name, obj, c, meta);
            if (objCount == 0L) {
                retType = CREATE_GROUP;
            } else if (objCount == 1L) {
                retType = UPDATE_GROUP;
            } else {
                throw new CpoException("Cannot Persist Object To Multiple DataSource Objects");
            }
        }
        return retType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> JdbcMetaClass<T> getMetaClass(T obj, Connection c) throws CpoException {
        JdbcMetaClass<?> jmc = null;
        if (obj != null) {
            String requestedName;
            Class<?> requestedClass;
            Class<?> classObj = requestedClass = obj.getClass();
            String className = requestedName = requestedClass.getName();
            HashMap<String, HashMap<String, JdbcMetaClass<?>>> hashMap = this.getDataSourceMap();
            synchronized (hashMap) {
                HashMap<String, JdbcMetaClass<?>> metaClassMap = this.getMetaClassMap();
                jmc = metaClassMap.get(className);
                while (jmc == null && classObj != null) {
                    try {
                        jmc = this.loadMetaClass(requestedClass, className, c);
                        jmc.setName(requestedName);
                        metaClassMap.put(requestedName, jmc);
                        Logger.getLogger((String)requestedName).debug((Object)("Loading Class:" + requestedName));
                    }
                    catch (CpoException ce) {
                        jmc = null;
                        classObj = classObj.getSuperclass();
                        className = classObj.getName();
                    }
                }
                if (jmc == null) {
                    throw new CpoException("No Metadata found for class:" + requestedName);
                }
            }
        }
        return jmc;
    }

    protected HashMap<String, JdbcMetaClass<?>> getMetaClassMap() {
        String dataSourceName;
        HashMap<String, HashMap<String, JdbcMetaClass<?>>> dataSourceMap = this.getDataSourceMap();
        HashMap<String, JdbcMetaClass<Object>> metaClassMap = dataSourceMap.get(dataSourceName = this.getMetaDataSourceName());
        if (metaClassMap == null) {
            metaClassMap = new HashMap();
            dataSourceMap.put(dataSourceName, metaClassMap);
        }
        return metaClassMap;
    }

    protected Connection getReadConnection() throws CpoException {
        Connection connection = this.getStaticConnection();
        if (connection == null) {
            try {
                connection = !this.invalidReadConnection_ ? this.getReadDataSource().getConnection() : this.getWriteDataSource().getConnection();
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                this.invalidReadConnection_ = true;
                String msg = "getReadConnection(): failed";
                logger.error((Object)msg, (Throwable)e);
                try {
                    connection = this.getWriteDataSource().getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e2) {
                    msg = "getWriteConnection(): failed";
                    logger.error((Object)msg, (Throwable)e2);
                    throw new CpoException(msg, e2);
                }
            }
        }
        return connection;
    }

    protected void setReadDataSource(DataSource readDataSource) {
        this.readDataSource_ = readDataSource;
    }

    protected DataSource getReadDataSource() {
        return this.readDataSource_;
    }

    protected Connection getWriteConnection() throws CpoException {
        Connection connection = this.getStaticConnection();
        if (connection == null) {
            try {
                connection = this.getWriteDataSource().getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                String msg = "getWriteConnection(): failed";
                logger.error((Object)msg, (Throwable)e);
                throw new CpoException(msg, e);
            }
        }
        return connection;
    }

    protected Connection getStaticConnection() throws CpoException {
        return null;
    }

    protected boolean isStaticConnection(Connection c) {
        return false;
    }

    protected void setStaticConnection(Connection c) {
    }

    protected void setWriteDataSource(DataSource writeDataSource) {
        this.writeDataSource_ = writeDataSource;
    }

    protected DataSource getWriteDataSource() {
        return this.writeDataSource_;
    }

    protected Connection getMetaConnection() throws CpoException {
        Connection connection;
        try {
            connection = this.getMetaDataSource().getConnection();
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            String msg = "getMetaConnection(): failed";
            logger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        return connection;
    }

    protected void setMetaDataSource(DataSource metaDataSource) {
        this.metaDataSource_ = metaDataSource;
    }

    protected DataSource getMetaDataSource() {
        return this.metaDataSource_;
    }

    protected void setMetaDataSourceName(String metaDataSourceName) {
        this.metaDataSourceName_ = metaDataSourceName;
    }

    protected String getMetaDataSourceName() {
        return this.metaDataSourceName_;
    }

    protected void closeConnection(Connection connection) {
        try {
            if (this.isStaticConnection(connection)) {
                this.clearConnectionBusy(connection);
            } else if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void commitConnection(Connection connection) {
        try {
            if (connection != null && !this.isStaticConnection(connection)) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void rollbackConnection(Connection connection) {
        try {
            if (connection != null && !this.isStaticConnection(connection)) {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected <T, C> T processExecuteGroup(String name, C criteria, T result) throws CpoException {
        Connection c = null;
        Connection meta = null;
        T obj = null;
        try {
            c = this.getWriteConnection();
            meta = this.metaEqualsWrite_ ? c : this.getMetaConnection();
            obj = this.processExecuteGroup(name, criteria, result, c, meta);
            this.commitConnection(c);
        }
        catch (Exception e) {
            try {
                this.rollbackConnection(c);
            }
            catch (Exception re) {
                // empty catch block
            }
            if (e instanceof CpoException) {
                throw (CpoException)e;
            }
            throw new CpoException("processExecuteGroup(String name, Object criteria, Object result) failed", e);
        }
        finally {
            this.closeConnection(c);
            this.closeConnection(meta);
        }
        return obj;
    }

    protected <T, C> T processExecuteGroup(String name, C criteria, T result, Connection conn, Connection metaCon) throws CpoException {
        Statement cstmt = null;
        JdbcQuery jq = null;
        T returnObject = null;
        Logger localLogger = criteria == null ? logger : Logger.getLogger((String)criteria.getClass().getName());
        JdbcCallableStatementFactory jcsf = null;
        try {
            JdbcMetaClass<C> jmcCriteria = this.getMetaClass(criteria, metaCon);
            JdbcMetaClass<T> jmcResult = this.getMetaClass(result, metaCon);
            ArrayList<JdbcQuery> queryGroup = jmcCriteria.getQueryGroup(EXECUTE_GROUP, name);
            localLogger.info((Object)("===================processExecuteGroup (" + name + ") Count<" + queryGroup.size() + ">========================="));
            Class<T> jmcClass = jmcResult.getJmcClass();
            try {
                returnObject = jmcClass.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new CpoException("Unable to access the constructor of the Return Object", iae);
            }
            catch (InstantiationException iae) {
                throw new CpoException("Unable to instantiate Return Object", iae);
            }
            for (int i = 0; i < queryGroup.size(); ++i) {
                jq = queryGroup.get(i);
                jcsf = new JdbcCallableStatementFactory(conn, this, jq, criteria);
                localLogger.debug((Object)("Executing Call:" + jmcCriteria.getName() + ":" + name));
                cstmt = jcsf.getCallableStatement();
                cstmt.execute();
                jcsf.release();
                localLogger.debug((Object)("Processing Call:" + jmcCriteria.getName() + ":" + name));
                ArrayList<JdbcParameter> parameters = jcsf.getOutParameters();
                if (!parameters.isEmpty()) {
                    for (int j = 0; j < parameters.size(); ++j) {
                        JdbcParameter parameter = parameters.get(j);
                        if (!parameter.isOutParameter()) continue;
                        JdbcAttribute attribute = parameter.getAttribute();
                        attribute.invokeSetter(returnObject, (CallableStatement)cstmt, j + 1);
                    }
                }
                cstmt.close();
            }
        }
        catch (SQLException e) {
            String msg = "ProcessExecuteGroup(String name, Object criteria, Object result, Connection conn) failed. SQL=";
            if (jq != null) {
                msg = msg + jq.getText();
            }
            localLogger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        finally {
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (Exception e) {}
            }
            if (jcsf != null) {
                jcsf.release();
            }
        }
        return returnObject;
    }

    protected <T> T processSelectGroup(T obj, String groupName) throws CpoException {
        Connection c = null;
        Connection meta = null;
        T result = null;
        try {
            c = this.getReadConnection();
            meta = this.metaEqualsWrite_ ? c : this.getMetaConnection();
            result = this.processSelectGroup(obj, groupName, c, meta);
            this.commitConnection(c);
        }
        catch (Exception e) {
            try {
                this.rollbackConnection(c);
            }
            catch (Exception re) {
                // empty catch block
            }
            if (e instanceof CpoException) {
                throw (CpoException)e;
            }
            throw new CpoException("processSelectGroup(Object obj, String groupName) failed", e);
        }
        finally {
            this.closeConnection(c);
            this.closeConnection(meta);
        }
        return result;
    }

    protected <T> T processSelectGroup(T obj, String groupName, Connection con, Connection metaCon) throws CpoException {
        Statement ps = null;
        ResultSet rs = null;
        T criteriaObj = obj;
        boolean recordsExist = false;
        Logger localLogger = obj == null ? logger : Logger.getLogger((String)obj.getClass().getName());
        int recordCount = 0;
        int attributesSet = 0;
        T rObj = null;
        try {
            JdbcMetaClass<T> jmc = this.getMetaClass(criteriaObj, metaCon);
            ArrayList<JdbcQuery> queryGroup = jmc.getQueryGroup(RETRIEVE_GROUP, groupName);
            HashMap<String, JdbcAttribute> jmcAttrMap = jmc.getAttributeMap();
            localLogger.info((Object)("=================== Class=<" + criteriaObj.getClass() + "> Type=<" + RETRIEVE_GROUP + "> Name=<" + groupName + "> ========================="));
            try {
                rObj = jmc.getJmcClass().newInstance();
            }
            catch (IllegalAccessException iae) {
                if (obj != null) {
                    localLogger.error((Object)("=================== Could not access default constructor for Class=<" + obj.getClass() + "> =================="));
                } else {
                    localLogger.error((Object)"=================== Could not access default constructor for class ==================");
                }
                throw new CpoException("Unable to access the constructor of the Return Object", iae);
            }
            catch (InstantiationException iae) {
                throw new CpoException("Unable to instantiate Return Object", iae);
            }
            for (int i = 0; i < queryGroup.size(); ++i) {
                JdbcQuery jq = queryGroup.get(i);
                JdbcPreparedStatementFactory jpsf = new JdbcPreparedStatementFactory(con, this, jmc, jq, criteriaObj);
                ps = jpsf.getPreparedStatement();
                rs = ps.executeQuery();
                jpsf.release();
                if (rs.isBeforeFirst()) {
                    JdbcAttribute attribute;
                    ResultSetMetaData rsmd = rs.getMetaData();
                    if (rsmd.getColumnCount() == 2 && "CPO_ATTRIBUTE".equalsIgnoreCase(rsmd.getColumnName(1)) && "CPO_VALUE".equalsIgnoreCase(rsmd.getColumnName(2))) {
                        while (rs.next()) {
                            recordsExist = true;
                            ++recordCount;
                            attribute = jmcAttrMap.get(rs.getString(1));
                            if (attribute == null) continue;
                            attribute.invokeSetter(rObj, rs, 2);
                            ++attributesSet;
                        }
                    } else if (rs.next()) {
                        recordsExist = true;
                        ++recordCount;
                        for (int k = 1; k <= rsmd.getColumnCount(); ++k) {
                            attribute = jmcAttrMap.get(rsmd.getColumnName(k));
                            if (attribute == null) continue;
                            attribute.invokeSetter(rObj, rs, k);
                            ++attributesSet;
                        }
                        if (rs.next()) {
                            String msg = "ProcessSelectGroup(Object, String) failed: Multiple Records Returned";
                            localLogger.error((Object)msg);
                            throw new CpoException(msg);
                        }
                    }
                    criteriaObj = rObj;
                }
                rs.close();
                rs = null;
                ps.close();
                ps = null;
            }
            if (!recordsExist) {
                rObj = null;
                localLogger.info((Object)("=================== 0 Records - 0 Attributes - Class=<" + criteriaObj.getClass() + "> Type=<" + RETRIEVE_GROUP + "> Name=<" + groupName + "> ========================="));
            } else {
                localLogger.info((Object)("=================== " + recordCount + " Records - " + attributesSet + " Attributes - Class=<" + criteriaObj.getClass() + ">  Type=<" + RETRIEVE_GROUP + "> Name=<" + groupName + "> ========================="));
            }
        }
        catch (SQLException e) {
            String msg = "ProcessSeclectGroup(Object) failed: " + e.getMessage();
            localLogger.error((Object)msg, (Throwable)e);
            rObj = null;
            throw new CpoException(msg, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
        }
        return rObj;
    }

    protected <T, C> Collection<T> processSelectGroup(String name, C criteria, T result, CpoWhere where, Collection<CpoOrderBy> orderBy, boolean useRetrieve) throws CpoException {
        Connection con = null;
        Connection meta = null;
        CpoArrayResultSet resultSet = new CpoArrayResultSet();
        try {
            con = this.getReadConnection();
            meta = this.metaEqualsWrite_ ? con : this.getMetaConnection();
            this.processSelectGroup(name, criteria, result, where, orderBy, con, meta, useRetrieve, resultSet);
            this.commitConnection(con);
        }
        catch (Exception e) {
            try {
                this.rollbackConnection(con);
            }
            catch (Exception re) {
                // empty catch block
            }
            if (e instanceof CpoException) {
                throw (CpoException)e;
            }
            throw new CpoException("processSelectGroup(String name, Object criteria, Object result,CpoWhere where, Collection orderBy, boolean useRetrieve) failed", e);
        }
        finally {
            this.closeConnection(con);
            this.closeConnection(meta);
        }
        return resultSet;
    }

    protected <T, C> void processSelectGroup(String name, C criteria, T result, CpoWhere where, Collection<CpoOrderBy> orderBy, boolean useRetrieve, CpoResultSet<T> resultSet) throws CpoException {
        Connection con = null;
        Connection meta = null;
        try {
            con = this.getReadConnection();
            meta = this.metaEqualsWrite_ ? con : this.getMetaConnection();
            this.processSelectGroup(name, criteria, result, where, orderBy, con, meta, useRetrieve, resultSet);
            this.commitConnection(con);
        }
        catch (Exception e) {
            try {
                this.rollbackConnection(con);
            }
            catch (Exception re) {
                // empty catch block
            }
            if (e instanceof CpoException) {
                throw (CpoException)e;
            }
            throw new CpoException("processSelectGroup(String name, Object criteria, Object result,CpoWhere where, Collection orderBy, boolean useRetrieve) failed", e);
        }
        finally {
            this.closeConnection(con);
            this.closeConnection(meta);
        }
    }

    protected <T, C> void processSelectGroup(String name, C criteria, T result, CpoWhere where, Collection<CpoOrderBy> orderBy, Connection con, Connection metaCon, boolean useRetrieve, CpoResultSet<T> resultSet) throws CpoException {
        Logger localLogger = criteria == null ? logger : Logger.getLogger((String)criteria.getClass().getName());
        Statement ps = null;
        ResultSet rs = null;
        ArrayList<BindAttribute> bindValues = new ArrayList<BindAttribute>();
        try {
            ArrayList<JdbcQuery> queryGroup;
            JdbcMetaClass<C> jmcCriteria = this.getMetaClass(criteria, metaCon);
            JdbcMetaClass<T> jmcResult = this.getMetaClass(result, metaCon);
            if (useRetrieve) {
                localLogger.info((Object)("=================== Class=<" + criteria.getClass() + "> Type=<" + RETRIEVE_GROUP + "> Name=<" + name + "> ========================="));
                queryGroup = jmcCriteria.getQueryGroup(RETRIEVE_GROUP, name);
            } else {
                localLogger.info((Object)("=================== Class=<" + criteria.getClass() + "> Type=<" + LIST_GROUP + "> Name=<" + name + "> ========================="));
                queryGroup = jmcCriteria.getQueryGroup(LIST_GROUP, name);
            }
            for (int i = 0; i < queryGroup.size(); ++i) {
                int k;
                JdbcQuery jq = queryGroup.get(i);
                JdbcPreparedStatementFactory jpsf = new JdbcPreparedStatementFactory(con, this, jmcCriteria, jq, criteria, where, orderBy, bindValues);
                ps = jpsf.getPreparedStatement();
                ps.setFetchSize(resultSet.getFetchSize());
                localLogger.debug((Object)"Retrieving Records");
                rs = ps.executeQuery();
                jpsf.release();
                localLogger.debug((Object)"Processing Records");
                ResultSetMetaData rsmd = rs.getMetaData();
                Class<T> jmcClass = jmcResult.getJmcClass();
                HashMap<String, JdbcAttribute> jmcAttrMap = jmcResult.getAttributeMap();
                int columnCount = rsmd.getColumnCount();
                JdbcAttribute[] attributes = new JdbcAttribute[columnCount + 1];
                for (k = 1; k <= columnCount; ++k) {
                    attributes[k] = jmcAttrMap.get(rsmd.getColumnName(k));
                }
                while (rs.next()) {
                    T obj;
                    try {
                        obj = jmcClass.newInstance();
                    }
                    catch (IllegalAccessException iae) {
                        if (result != null) {
                            localLogger.error((Object)("=================== Could not access default constructor for Class=<" + result.getClass() + "> =================="));
                        } else {
                            localLogger.error((Object)"=================== Could not access default constructor for class ==================");
                        }
                        throw new CpoException("Unable to access the constructor of the Return Object", iae);
                    }
                    catch (InstantiationException iae) {
                        throw new CpoException("Unable to instantiate Return Object", iae);
                    }
                    for (k = 1; k <= columnCount; ++k) {
                        if (attributes[k] == null) continue;
                        attributes[k].invokeSetter(obj, rs, k);
                    }
                    try {
                        resultSet.put(obj);
                    }
                    catch (InterruptedException e) {
                        localLogger.error((Object)"Retriever Thread was interrupted", (Throwable)e);
                        break;
                    }
                }
                try {
                    rs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    ps.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                localLogger.info((Object)("=================== " + resultSet.size() + " Records - Class=<" + criteria.getClass() + "> Type=<" + LIST_GROUP + "> Name=<" + name + "> Result=<" + result.getClass() + "> ===================="));
            }
        }
        catch (SQLException e) {
            String msg = "ProcessSelectGroup(String name, Object criteria, Object result, CpoWhere where, Collection orderBy, Connection con) failed. Error:";
            localLogger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected <T> long processUpdateGroup(T obj, String groupType, String groupName) throws CpoException {
        Connection c = null;
        Connection meta = null;
        long updateCount = 0L;
        try {
            c = this.getWriteConnection();
            meta = this.metaEqualsWrite_ ? c : this.getMetaConnection();
            updateCount = this.processUpdateGroup(obj, groupType, groupName, c, meta);
            this.commitConnection(c);
        }
        catch (Exception e) {
            try {
                this.rollbackConnection(c);
            }
            catch (Exception re) {
                // empty catch block
            }
            if (e instanceof CpoException) {
                throw (CpoException)e;
            }
            throw new CpoException("processUdateGroup(Object obj, String groupType, String groupName) failed", e);
        }
        finally {
            this.closeConnection(c);
            this.closeConnection(meta);
        }
        return updateCount;
    }

    protected <T> long processUpdateGroup(T obj, String groupType, String groupName, Connection con, Connection metaCon) throws CpoException {
        Logger localLogger = obj == null ? logger : Logger.getLogger((String)obj.getClass().getName());
        Statement ps = null;
        JdbcQuery jq = null;
        JdbcPreparedStatementFactory jpsf = null;
        long updateCount = 0L;
        try {
            JdbcMetaClass<T> jmc = this.getMetaClass(obj, metaCon);
            ArrayList<JdbcQuery> queryGroup = jmc.getQueryGroup(this.getGroupType(obj, groupType, groupName, con, metaCon), groupName);
            localLogger.info((Object)("=================== Class=<" + obj.getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> ========================="));
            int numRows = 0;
            for (int i = 0; i < queryGroup.size(); ++i) {
                jq = queryGroup.get(i);
                jpsf = new JdbcPreparedStatementFactory(con, this, jmc, jq, obj);
                ps = jpsf.getPreparedStatement();
                numRows += ps.executeUpdate();
                jpsf.release();
                ps.close();
            }
            localLogger.info((Object)("=================== " + numRows + " Updates - Class=<" + obj.getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> ========================="));
            if (numRows > 0) {
                ++updateCount;
            }
        }
        catch (SQLException e) {
            String msg = "ProcessUpdateGroup failed:" + groupType + "," + groupName + "," + obj.getClass().getName();
            localLogger.error((Object)("bound values:" + this.parameterToString(jq)));
            localLogger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
            if (jpsf != null) {
                jpsf.release();
            }
        }
        return updateCount;
    }

    protected <T> long processBatchUpdateGroup(T[] arr, String groupType, String groupName, Connection con, Connection metaCon) throws CpoException {
        Statement ps = null;
        JdbcQuery jq = null;
        JdbcPreparedStatementFactory jpsf = null;
        long updateCount = 0L;
        Logger localLogger = logger;
        try {
            JdbcMetaClass<T> jmc = this.getMetaClass(arr[0], metaCon);
            ArrayList<JdbcQuery> queryGroup = jmc.getQueryGroup(this.getGroupType(arr[0], groupType, groupName, con, metaCon), groupName);
            localLogger = Logger.getLogger((String)jmc.getJmcClass().getName());
            int numRows = 0;
            if (queryGroup.size() == 1) {
                int j;
                localLogger.info((Object)("=================== BATCH - Class=<" + arr[0].getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> ========================="));
                jq = queryGroup.get(0);
                jpsf = new JdbcPreparedStatementFactory(con, this, jmc, jq, arr[0]);
                ps = jpsf.getPreparedStatement();
                ps.addBatch();
                for (j = 1; j < arr.length; ++j) {
                    jpsf.bindParameters(arr[j]);
                    ps.addBatch();
                }
                int[] updates = ps.executeBatch();
                jpsf.release();
                ps.close();
                for (j = 0; j < updates.length; ++j) {
                    if (updates[j] > 0) {
                        numRows += updates[j];
                        continue;
                    }
                    if (updates[j] != -2) continue;
                    ++numRows;
                }
                localLogger.info((Object)("=================== BATCH - " + numRows + " Updates - Class=<" + arr[0].getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> ========================="));
            } else {
                localLogger.info((Object)("=================== Class=<" + arr[0].getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> ========================="));
                for (int j = 0; j < arr.length; ++j) {
                    for (int i = 0; i < queryGroup.size(); ++i) {
                        jq = queryGroup.get(i);
                        jpsf = new JdbcPreparedStatementFactory(con, this, jmc, jq, arr[j]);
                        ps = jpsf.getPreparedStatement();
                        numRows += ps.executeUpdate();
                        jpsf.release();
                        ps.close();
                    }
                }
                localLogger.info((Object)("=================== " + numRows + " Updates - Class=<" + arr[0].getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> ========================="));
            }
            if (numRows > 0) {
                updateCount = numRows;
            }
        }
        catch (SQLException e) {
            String msg = "ProcessUpdateGroup failed:" + groupType + "," + groupName + "," + arr[0].getClass().getName();
            localLogger.error((Object)("bound values:" + this.parameterToString(jq)));
            localLogger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
            if (jpsf != null) {
                jpsf.release();
            }
        }
        return updateCount;
    }

    protected <T> long processUpdateGroup(Collection<T> coll, String groupType, String groupName) throws CpoException {
        Connection c = null;
        Connection meta = null;
        long updateCount = 0L;
        try {
            c = this.getWriteConnection();
            meta = this.metaEqualsWrite_ ? c : this.getMetaConnection();
            updateCount = this.processUpdateGroup(coll, groupType, groupName, c, meta);
            this.commitConnection(c);
        }
        catch (Exception e) {
            try {
                this.rollbackConnection(c);
            }
            catch (Exception re) {
                // empty catch block
            }
            if (e instanceof CpoException) {
                throw (CpoException)e;
            }
            throw new CpoException("processUpdateGroup(Collection coll, String groupType, String groupName) failed", e);
        }
        finally {
            this.closeConnection(c);
            this.closeConnection(meta);
        }
        return updateCount;
    }

    protected <T> long processUpdateGroup(Collection<T> coll, String groupType, String groupName, Connection con, Connection meta) throws CpoException {
        long updateCount = 0L;
        if (!coll.isEmpty()) {
            int i;
            Object[] arr = coll.toArray();
            Object obj1 = arr[0];
            boolean allEqual = true;
            for (i = 1; i < arr.length; ++i) {
                if (obj1.getClass().getName().equals(arr[i].getClass().getName())) continue;
                allEqual = false;
                break;
            }
            if (allEqual && this.batchUpdatesSupported_ && !PERSIST_GROUP.equals(groupType)) {
                updateCount = this.processBatchUpdateGroup(arr, groupType, groupName, con, meta);
            } else {
                for (i = 0; i < arr.length; ++i) {
                    updateCount += this.processUpdateGroup(arr[i], groupType, groupName, con, meta);
                }
            }
        }
        return updateCount;
    }

    private <T> void loadAttributeMap(String name, Connection c, JdbcMetaClass<T> jmc) throws CpoException {
        block23: {
            String select = "select cam.column_name, cam.attribute, cc.class_id, cam.column_type, cam.db_table, cam.db_column, cam.transform_class from ";
            String table1 = "cpo_attribute_map cam, ";
            String table2 = "cpo_class cc where cc.name = ? and cam.class_id = cc.class_id";
            String sql = select + this.getDbTablePrefix() + table1 + this.getDbTablePrefix() + table2;
            PreparedStatement ps = null;
            ResultSet rs = null;
            logger.debug((Object)("loadAttribute Sql <" + sql + ">"));
            boolean failed = false;
            StringBuffer failedMessage = new StringBuffer();
            if (c != null && jmc != null) {
                Logger localLogger = Logger.getLogger((String)jmc.getJmcClass().getName());
                try {
                    ps = c.prepareStatement(sql);
                    ps.setString(1, name);
                    rs = ps.executeQuery();
                    HashMap<String, JdbcAttribute> aMap = jmc.getAttributeMap();
                    HashMap<String, JdbcAttribute> cMap = jmc.getColumnMap();
                    if (rs.next()) {
                        String classId = rs.getString(3);
                        jmc.setClassId(classId);
                        do {
                            try {
                                String dbType = rs.getString(4);
                                JdbcAttribute attribute = new JdbcAttribute(jmc, rs.getString(2), dbType, rs.getString(1), rs.getString(5), rs.getString(6), rs.getString(7));
                                aMap.put(rs.getString(1), attribute);
                                cMap.put(attribute.getName(), attribute);
                            }
                            catch (CpoException ce) {
                                failed = true;
                                String msg = ce.getLocalizedMessage();
                                if (msg == null && ce.getCause() != null) {
                                    msg = ce.getCause().getLocalizedMessage();
                                }
                                failedMessage.append(msg);
                            }
                        } while (rs.next());
                        if (failed) {
                            throw new CpoException("Error processing Attributes for:" + name + failedMessage.toString());
                        }
                        break block23;
                    }
                    throw new CpoException("No Attributes found for class:" + name);
                }
                catch (CpoException ce) {
                    String msg = "loadAttributeMap() failed:'" + sql + "' classname:" + name;
                    localLogger.error((Object)msg, (Throwable)ce);
                    throw ce;
                }
                catch (Exception e) {
                    String msg = "loadAttributeMap() failed:'" + sql + "' classname:" + name;
                    localLogger.error((Object)msg, (Throwable)e);
                    throw new CpoException(msg, e);
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {}
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
    }

    private <T> JdbcMetaClass<T> loadMetaClass(Class<T> objClass, String name, Connection c) throws CpoException {
        JdbcMetaClass<T> jmc = new JdbcMetaClass<T>(objClass, name);
        this.loadAttributeMap(name, c, jmc);
        this.loadQueryGroups(c, jmc);
        return jmc;
    }

    private <T> void loadQueryGroups(Connection c, JdbcMetaClass<T> jmc) throws CpoException {
        String id = null;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select ");
        sqlBuffer.append(" innr.group_type,innr.name,innr.query_id,innr.query_seq as query_seq,cqt.sql_text,innr.param_seq as param_seq,  cam.attribute, cam.column_name, cam.column_type, innr.param_type ");
        sqlBuffer.append("from ");
        sqlBuffer.append(this.getDbTablePrefix());
        sqlBuffer.append("cpo_query_text cqt,  ");
        sqlBuffer.append("  (select cqg.group_type, cqg.name, cq.query_id, cq.seq_no as query_seq,cqp.seq_no as param_seq, cqp.attribute_id, cqp.param_type,cq.text_id,cq.seq_no,cqg.group_id ");
        sqlBuffer.append("from ");
        sqlBuffer.append(this.getDbTablePrefix());
        sqlBuffer.append("cpo_query_group cqg, ");
        sqlBuffer.append(this.getDbTablePrefix());
        sqlBuffer.append("cpo_query cq ");
        sqlBuffer.append("   left outer join ");
        sqlBuffer.append(this.getDbTablePrefix());
        sqlBuffer.append("cpo_query_parameter cqp ");
        sqlBuffer.append("   on cq.query_id = cqp.query_id ");
        sqlBuffer.append("   where cqg.class_id = ? ");
        sqlBuffer.append("   and cqg.group_id = cq.group_id ) innr ");
        sqlBuffer.append(" left outer join ");
        sqlBuffer.append(this.getDbTablePrefix());
        sqlBuffer.append("cpo_attribute_map cam on innr.attribute_id = cam.attribute_id ");
        sqlBuffer.append("where cqt.text_id = innr.text_id ");
        sqlBuffer.append("order by innr.group_id asc, innr.query_seq asc, innr.param_seq  asc");
        String sql = sqlBuffer.toString();
        logger.debug((Object)("loadQueryGroup Sql <" + sql + ">"));
        PreparedStatement ps = null;
        ResultSet rs = null;
        int oldSeq = 1000;
        JdbcQuery jq = null;
        String groupType = null;
        if (c != null && jmc != null) {
            Logger localLogger = Logger.getLogger((String)jmc.getJmcClass().getName());
            try {
                id = jmc.getClassId();
                ps = c.prepareStatement(sql);
                ps.setString(1, id);
                rs = ps.executeQuery();
                while (rs.next()) {
                    JdbcAttribute attribute;
                    int newSeq = rs.getInt(6);
                    if (newSeq <= oldSeq) {
                        jq = new JdbcQuery();
                        jq.setQueryId(rs.getString(3));
                        jq.setText(rs.getString(5));
                        jq.setName(rs.getString(2));
                        jq.setType(rs.getString(1));
                        jmc.addQueryToGroup(jq);
                        localLogger.debug((Object)("Added QueryGroup:" + jmc.getName() + ":" + jq.getType() + ":" + jq.getName()));
                    }
                    if ((attribute = jmc.getAttributeMap().get(rs.getString(8))) == null) {
                        newSeq = 1000;
                        localLogger.debug((Object)("No Parameters for " + groupType + ":" + jq.getName()));
                    } else {
                        JdbcParameter parameter = new JdbcParameter(attribute, rs.getString(10));
                        jq.getParameterList().add(parameter);
                        localLogger.debug((Object)("Added Parameter:" + attribute.getName() + parameter.getType()));
                    }
                    oldSeq = newSeq;
                }
            }
            catch (SQLException e) {
                String msg = "loadQueryGroups() falied:" + sql + ":" + id;
                localLogger.error((Object)msg, (Throwable)e);
                throw new CpoException(msg, e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private String parameterToString(JdbcQuery jq) {
        StringBuffer sb = new StringBuffer("Parameter list for ");
        if (jq == null) {
            return " null query.";
        }
        sb.append(jq.getName() + " " + jq.getType());
        ArrayList<JdbcParameter> parameters = jq.getParameterList();
        for (int j = 1; j <= parameters.size(); ++j) {
            JdbcParameter parameter = parameters.get(j - 1);
            if (parameter == null) continue;
            try {
                JdbcAttribute attribute = parameter.getAttribute();
                Class<?> c = attribute.getGetters()[0].getReturnType();
                int type = attribute.getJavaSqlType();
                if (c != null) {
                    sb.append(" col" + j + ":" + c.getName() + " type:" + type + " ");
                    continue;
                }
                sb.append(j + ":null type:" + type + " ");
                continue;
            }
            catch (Exception e) {
                String msg = "parameterToString() Failed:";
                logger.error((Object)msg);
            }
        }
        return sb.toString();
    }

    @Override
    public CpoTrxAdapter getCpoTrxAdapter() throws CpoException {
        return new JdbcCpoTrxAdapter(this.getMetaDataSource(), this.getMetaDataSourceName(), this.getWriteConnection(), this.batchUpdatesSupported_, this.getDbTablePrefix());
    }

    public String getDbTablePrefix() {
        return this.dbTablePrefix;
    }

    public void setDbTablePrefix(String dbTablePrefix) {
        this.dbTablePrefix = dbTablePrefix;
    }

    protected boolean isConnectionBusy(Connection c) {
        return false;
    }

    protected void setConnectionBusy(Connection c) {
    }

    protected void clearConnectionBusy(Connection c) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RetrieverThread<T, C>
    extends Thread {
        String name;
        C criteria;
        T result;
        CpoWhere where;
        Collection<CpoOrderBy> orderBy;
        boolean useRetrieve;
        CpoBlockingResultSet<T> resultSet;
        Thread callingThread = null;

        public RetrieverThread(String name, C criteria, T result, CpoWhere where, Collection<CpoOrderBy> orderBy, boolean useRetrieve, CpoBlockingResultSet<T> resultSet) {
            this.name = name;
            this.criteria = criteria;
            this.result = result;
            this.where = where;
            this.orderBy = orderBy;
            this.useRetrieve = useRetrieve;
            this.resultSet = resultSet;
            this.callingThread = Thread.currentThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                JdbcCpoAdapter.this.processSelectGroup(this.name, this.criteria, this.result, this.where, this.orderBy, false, this.resultSet);
            }
            catch (CpoException e) {
                e.printStackTrace();
            }
            finally {
                this.resultSet.setDone(true);
                this.callingThread.interrupt();
            }
        }
    }
}

