/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.io.CharArrayWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import oracle.sql.CLOB;
import org.apache.log4j.Logger;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.transform.jdbc.OracleTemporaryClob;

public class TransformClob {
    private static Logger logger = Logger.getLogger((String)TransformClob.class.getName());

    public char[] transformIn(Clob clob) throws CpoException {
        char[] buffChars = new char[1024];
        char[] retChars = null;
        int length = 0;
        CharArrayWriter caw = new CharArrayWriter();
        if (clob != null) {
            try {
                Reader is = clob.getCharacterStream();
                while ((length = is.read(buffChars)) != -1) {
                    caw.write(buffChars, 0, length);
                }
                is.close();
                retChars = caw.toCharArray();
            }
            catch (Exception e) {
                logger.debug((Object)"Error in transform blob", (Throwable)e);
                throw new CpoException(e);
            }
        }
        return retChars;
    }

    public Clob transformOut(JdbcPreparedStatementFactory jpsf, char[] attributeObject) throws CpoException {
        CLOB newClob = null;
        try {
            if (attributeObject != null) {
                newClob = CLOB.createTemporary((Connection)jpsf.getPreparedStatement().getConnection(), (boolean)false, (int)10);
                jpsf.AddReleasible(new OracleTemporaryClob(newClob));
                Writer cos = newClob.setCharacterStream(0L);
                cos.write(attributeObject);
                cos.close();
            }
        }
        catch (Exception e) {
            String msg = "Error CLOBing Char Array";
            logger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        return newClob;
    }
}

