/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import oracle.sql.BLOB;
import org.apache.log4j.Logger;
import org.synchronoss.cpo.CpoByteArrayInputStream;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.transform.jdbc.OracleTemporaryBlob;

public class TransformGZipBlob {
    private static Logger logger = Logger.getLogger((String)TransformGZipBlob.class.getName());

    public byte[] transformIn(Blob blob) throws CpoException {
        byte[] buffBytes = new byte[1024];
        byte[] retBytes = null;
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (blob != null) {
            try {
                InputStream bis = blob.getBinaryStream();
                if (bis != null) {
                    CpoByteArrayInputStream cbais = CpoByteArrayInputStream.getCpoStream(bis);
                    if (cbais.getLength() > 0) {
                        GZIPInputStream gzis = new GZIPInputStream(cbais);
                        while ((length = gzis.read(buffBytes)) != -1) {
                            bos.write(buffBytes, 0, length);
                        }
                        bos.flush();
                        bos.close();
                        gzis.close();
                        cbais.close();
                        retBytes = bos.toByteArray();
                    } else {
                        retBytes = new byte[]{};
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error in transform GZipBlob", (Throwable)e);
                throw new CpoException(e);
            }
        }
        return retBytes;
    }

    public Blob transformOut(JdbcPreparedStatementFactory jpsf, byte[] attributeObject) throws CpoException {
        BLOB newBlob = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (attributeObject != null) {
                GZIPOutputStream os = new GZIPOutputStream(baos);
                os.write(attributeObject);
                os.flush();
                os.close();
                newBlob = BLOB.createTemporary((Connection)jpsf.getPreparedStatement().getConnection(), (boolean)false, (int)10);
                jpsf.AddReleasible(new OracleTemporaryBlob(newBlob));
                OutputStream bos = newBlob.setBinaryStream(0L);
                bos.write(baos.toByteArray());
                bos.close();
            }
        }
        catch (Exception e) {
            String msg = "Error GZipping Byte Array";
            logger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        return newBlob;
    }
}

