/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.DataSourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverDataSourceInfo
implements DataSourceInfo,
DataSource {
    private static final int URL_CONNECTION = 1;
    private static final int URL_PROPS_CONNECTION = 2;
    private static final int URL_USER_PASSWORD_CONNECTION = 3;
    private int connectionType = 0;
    private String dataSourceName = null;
    private String tablePrefix = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private Properties properties = null;
    private PrintWriter printWriter_ = null;
    private int timeout_ = 0;
    private Object LOCK = new Object();

    public DriverDataSourceInfo(String driver, String url) throws CpoException {
        this.loadDriver(driver);
        this.connectionType = 1;
        this.url = url;
        this.dataSourceName = url;
    }

    public DriverDataSourceInfo(String driver, String url, String tablePrefix) throws CpoException {
        this.loadDriver(driver);
        this.connectionType = 1;
        this.url = url;
        this.dataSourceName = url;
        if (tablePrefix != null) {
            this.tablePrefix = tablePrefix;
        }
    }

    public DriverDataSourceInfo(String driver, String url, Properties properties) throws CpoException {
        this.loadDriver(driver);
        this.connectionType = 2;
        this.url = url;
        this.properties = properties;
        this.dataSourceName = this.BuildDataSourceName(url, properties);
    }

    public DriverDataSourceInfo(String driver, String url, Properties properties, String tablePrefix) throws CpoException {
        this.loadDriver(driver);
        this.connectionType = 2;
        this.url = url;
        this.properties = properties;
        this.dataSourceName = this.BuildDataSourceName(url, properties);
        if (tablePrefix != null) {
            this.tablePrefix = tablePrefix;
        }
    }

    public DriverDataSourceInfo(String driver, String url, String username, String password) throws CpoException {
        this.loadDriver(driver);
        this.connectionType = 3;
        this.url = url;
        this.username = username;
        this.password = password;
        this.dataSourceName = url + username;
    }

    public DriverDataSourceInfo(String driver, String url, String username, String password, String tablePrefix) throws CpoException {
        this.loadDriver(driver);
        this.connectionType = 3;
        this.url = url;
        this.username = username;
        this.password = password;
        this.dataSourceName = url + username;
        if (tablePrefix != null) {
            this.tablePrefix = tablePrefix;
        }
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public String getTablePrefix() {
        return this.tablePrefix;
    }

    @Override
    public DataSource getDataSource() throws CpoException {
        return this;
    }

    private String BuildDataSourceName(String url, Properties properties) {
        StringBuilder dsName = new StringBuilder(url);
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        for (Object key : treeMap.keySet()) {
            dsName.append((String)key);
            dsName.append("=");
            dsName.append(properties.getProperty((String)key));
        }
        return dsName.toString();
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.makeNewConnection();
    }

    private Connection makeNewConnection() throws SQLException {
        Connection connection = null;
        switch (this.connectionType) {
            case 1: {
                connection = DriverManager.getConnection(this.url);
                break;
            }
            case 2: {
                connection = DriverManager.getConnection(this.url, this.properties);
                break;
            }
            case 3: {
                connection = DriverManager.getConnection(this.url, this.username, this.password);
                break;
            }
            default: {
                throw new SQLException("Invalid Connection Type");
            }
        }
        return connection;
    }

    public synchronized String toString() {
        StringBuilder info = new StringBuilder();
        info.append("JdbcDataSource(");
        info.append(this.dataSourceName);
        info.append(")");
        return info.toString();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter_;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter_ = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.timeout_ = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.timeout_;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private void loadDriver(String driver) throws CpoException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException cnfe) {
            throw new CpoException("Could Not Load Driver" + driver);
        }
    }
}

