/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoByteArrayInputStream;
import org.synchronoss.cpo.CpoCharArrayReader;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.JavaSqlMethod;
import org.synchronoss.cpo.jdbc.JavaSqlMethods;
import org.synchronoss.cpo.jdbc.JavaSqlTypes;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcMetaClass;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;

public class JdbcAttribute
implements Serializable,
Cloneable {
    private static Logger logger = LoggerFactory.getLogger((String)JdbcAttribute.class.getName());
    private static final long serialVersionUID = 1L;
    private String name_ = null;
    private String getterName_ = null;
    private String setterName_ = null;
    private Method[] getters_ = null;
    private Method[] setters_ = null;
    private String dbTable_ = null;
    private String dbColumn_ = null;
    private String dbName_ = null;
    private int javaSqlType_ = 0;
    private Object transformObject_ = null;
    private Method transformIn_ = null;
    private Method transformPSOut_ = null;
    private Method transformCSOut_ = null;
    private boolean hasTransformIn = false;
    private boolean hasTransformPS = false;
    private boolean hasTransformCS = false;

    public JdbcAttribute() {
    }

    public <T> JdbcAttribute(JdbcMetaClass<T> jmc, String name, String javaSqlTypeName, String dbName, String dbTable, String dbColumn, String transformClass) throws CpoException {
        LoggerFactory.getLogger((String)jmc.getJmcClass().getName()).debug("Adding Attribute for class " + jmc.getJmcClass().getName() + ": " + name + "(" + dbName + "," + dbTable + "," + dbColumn + "," + transformClass + ")");
        this.setName(name);
        this.setTransformClass(transformClass);
        this.initMethods(jmc);
        this.setDbName(dbName);
        this.setDbTable(dbTable);
        this.setDbColumn(dbColumn);
        this.setJavaSqlType(JavaSqlTypes.getJavaSqlType(javaSqlTypeName));
    }

    protected void setName(String name) {
        this.name_ = name;
    }

    protected void setDbName(String dbName) {
        this.dbName_ = dbName;
    }

    protected void setDbTable(String dbTable) {
        this.dbTable_ = dbTable;
    }

    protected void setDbColumn(String dbColumn) {
        this.dbColumn_ = dbColumn;
    }

    protected String getName() {
        return this.name_;
    }

    protected String getDbName() {
        return this.dbName_;
    }

    protected String getDbTable() {
        return this.dbTable_;
    }

    protected String getDbColumn() {
        return this.dbColumn_;
    }

    protected Method[] getGetters() {
        return this.getters_;
    }

    protected Method[] getSetters() {
        return this.setters_;
    }

    protected void setGetters(Method[] getters) {
        this.getters_ = getters;
    }

    protected void setSetters(Method[] setters) {
        this.setters_ = setters;
    }

    protected String getGetterName() {
        return this.getterName_;
    }

    protected String getSetterName() {
        return this.setterName_;
    }

    protected void setGetterName(String getterName) {
        this.getterName_ = getterName;
    }

    protected void setSetterName(String setterName) {
        this.setterName_ = setterName;
    }

    private <T> void initMethods(JdbcMetaClass<T> jmc) throws CpoException {
        StringBuilder failedMessage = new StringBuilder();
        this.setGetterName(JdbcAttribute.buildMethodName("get", this.getName()));
        this.setSetterName(JdbcAttribute.buildMethodName("set", this.getName()));
        try {
            this.setGetters(JdbcAttribute.findMethods(jmc, this.getGetterName(), 0, true));
        }
        catch (CpoException ce1) {
            failedMessage.append(ce1.getMessage());
        }
        try {
            this.setSetters(JdbcAttribute.findMethods(jmc, this.getSetterName(), 1, false));
        }
        catch (Exception ce2) {
            failedMessage.append(ce2.getMessage());
        }
        if (failedMessage.length() > 0) {
            throw new CpoException(failedMessage.toString());
        }
    }

    protected static <T> Method[] findMethods(JdbcMetaClass<T> jmc, String methodName, int args, boolean hasReturn) throws CpoException {
        Method[] ret;
        block5: {
            Method[] m = null;
            int count = 0;
            int[] idx = null;
            ret = null;
            try {
                int i;
                m = jmc.getJmcClass().getMethods();
                idx = new int[m.length];
                for (i = 0; i < m.length; ++i) {
                    if (!m[i].getName().equals(methodName) || m[i].getParameterTypes().length != args || (hasReturn || m[i].getReturnType() != Void.TYPE) && (!hasReturn || m[i].getReturnType() == Void.TYPE)) continue;
                    idx[count++] = i;
                }
                if (count > 0) {
                    ret = new Method[count];
                    for (i = 0; i < count; ++i) {
                        ret[i] = m[idx[i]];
                    }
                    break block5;
                }
                throw new Exception();
            }
            catch (Exception e) {
                throw new CpoException("findMethod() Failed - Method Not Found: " + methodName);
            }
        }
        return ret;
    }

    protected static String buildMethodName(String prefix, String base) {
        StringBuilder methodName = new StringBuilder();
        methodName.append(prefix);
        methodName.append(base);
        methodName.setCharAt(3, Character.toUpperCase(methodName.charAt(3)));
        return methodName.toString();
    }

    public void invokeSetter(Object obj, ResultSet rs, int idx) throws CpoException {
        Logger localLogger;
        JavaSqlMethod<?> jdbcMethod = null;
        Object param = null;
        Class<?> paramClass = null;
        Logger logger = localLogger = obj == null ? JdbcAttribute.logger : LoggerFactory.getLogger((String)obj.getClass().getName());
        if (this.getSetters().length == 0) {
            throw new CpoException("There are no setters");
        }
        if (this.hasTransformIn) {
            localLogger.info("Calling Transform In:" + this.transformIn_.getDeclaringClass().getName());
            jdbcMethod = JavaSqlMethods.getJavaSqlMethod(this.transformIn_.getParameterTypes()[0]);
            try {
                param = jdbcMethod.getRsGetter().invoke((Object)rs, new Integer(idx));
                param = this.transformIn(param);
                paramClass = this.transformIn_.getReturnType();
            }
            catch (IllegalAccessException iae) {
                localLogger.debug("Error Invoking ResultSet Method: " + ExceptionHelper.getLocalizedMessage(iae));
                throw new CpoException(iae);
            }
            catch (InvocationTargetException ite) {
                localLogger.debug("Error Invoking ResultSet Method: " + ExceptionHelper.getLocalizedMessage(ite));
                throw new CpoException(ite.getCause());
            }
        }
        for (int i = 0; i < this.getSetters().length; ++i) {
            try {
                if (!this.hasTransformIn) {
                    jdbcMethod = JavaSqlMethods.getJavaSqlMethod(this.getSetters()[i].getParameterTypes()[0]);
                    param = jdbcMethod.getRsGetter().invoke((Object)rs, new Integer(idx));
                    paramClass = jdbcMethod.getJavaSqlMethodClass();
                }
                if (!this.getSetters()[i].getParameterTypes()[0].isAssignableFrom(paramClass) && !this.isPrimitiveAssignableFrom(this.getSetters()[i].getParameterTypes()[0], paramClass)) continue;
                this.getSetters()[i].invoke(obj, param);
                return;
            }
            catch (IllegalAccessException iae) {
                localLogger.debug("Error Invoking Setter Method: " + ExceptionHelper.getLocalizedMessage(iae));
                continue;
            }
            catch (InvocationTargetException ite) {
                localLogger.debug("Error Invoking Setter Method: " + ExceptionHelper.getLocalizedMessage(ite));
            }
        }
        throw new CpoException("invokeSetter: Could not find a Setter for " + obj.getClass() + ": Column<" + this.getDbName() + "> Attribute<" + this.getName() + ">");
    }

    public void invokeSetter(Object obj, CallableStatement cs, int idx) throws CpoException {
        Logger localLogger;
        JavaSqlMethod<?> jdbcMethod = null;
        Object param = null;
        Class<?> paramClass = null;
        Logger logger = localLogger = obj == null ? JdbcAttribute.logger : LoggerFactory.getLogger((String)obj.getClass().getName());
        if (this.getSetters().length == 0) {
            throw new CpoException("There are no setters");
        }
        if (this.hasTransformCS) {
            localLogger.info("Calling Transform In:" + this.transformIn_.getDeclaringClass().getName());
            jdbcMethod = JavaSqlMethods.getJavaSqlMethod(this.transformIn_.getParameterTypes()[0]);
            try {
                param = jdbcMethod.getCsGetter().invoke((Object)cs, new Integer(idx));
                param = this.transformIn(param);
                paramClass = this.transformIn_.getReturnType();
            }
            catch (IllegalAccessException iae) {
                localLogger.debug("Error Invoking CallableStatement Method: " + ExceptionHelper.getLocalizedMessage(iae));
                throw new CpoException(iae);
            }
            catch (InvocationTargetException ite) {
                localLogger.debug("Error Invoking CallableStatement Method: " + ExceptionHelper.getLocalizedMessage(ite));
                throw new CpoException(ite.getCause());
            }
        }
        for (int i = 0; i < this.getSetters().length; ++i) {
            try {
                if (!this.hasTransformCS) {
                    jdbcMethod = JavaSqlMethods.getJavaSqlMethod(this.getSetters()[i].getParameterTypes()[0]);
                    param = jdbcMethod.getCsGetter().invoke((Object)cs, new Integer(idx));
                    paramClass = jdbcMethod.getJavaSqlMethodClass();
                }
                if (!this.getSetters()[i].getParameterTypes()[0].isAssignableFrom(paramClass)) continue;
                this.getSetters()[i].invoke(obj, param);
                return;
            }
            catch (IllegalAccessException iae) {
                localLogger.debug("Error Invoking Setter Method: " + ExceptionHelper.getLocalizedMessage(iae));
                continue;
            }
            catch (InvocationTargetException ite) {
                localLogger.debug("Error Invoking Setter Method: " + ExceptionHelper.getLocalizedMessage(ite));
            }
        }
        throw new CpoException("invokeSetter: Could not find a Setter for " + obj.getClass());
    }

    public void invokeGetter(JdbcCallableStatementFactory jcsf, Object obj, int idx) throws CpoException {
        Object param = null;
        JavaSqlMethod<?> jdbcMethod = null;
        Logger localLogger = obj == null ? logger : LoggerFactory.getLogger((String)obj.getClass().getName());
        try {
            if (this.hasTransformPS) {
                localLogger.info("Calling Transform Out:" + this.transformCSOut_.getDeclaringClass().getName());
                param = this.transformOut(jcsf, this.getGetters()[0].invoke(obj, (Object[])null));
                jdbcMethod = JavaSqlMethods.getJavaSqlMethod(this.transformCSOut_.getReturnType());
            } else {
                jdbcMethod = JavaSqlMethods.getJavaSqlMethod(this.getGetters()[0].getReturnType());
                param = this.getGetters()[0].invoke(obj, (Object[])null);
            }
            int length = 0;
            localLogger.info(this.dbName_ + "=" + param);
            switch (jdbcMethod.getMethodType()) {
                case 0: {
                    jdbcMethod.getCsSetter().invoke((Object)jcsf.getCallableStatement(), new Integer(idx), param);
                    break;
                }
                case 1: {
                    CpoByteArrayInputStream cbis = CpoByteArrayInputStream.getCpoStream((InputStream)param);
                    jdbcMethod.getCsSetter().invoke((Object)jcsf.getCallableStatement(), new Integer(idx), cbis, new Integer(length));
                    break;
                }
                case 2: {
                    CpoCharArrayReader ccar = CpoCharArrayReader.getCpoReader((Reader)param);
                    jdbcMethod.getCsSetter().invoke((Object)jcsf.getCallableStatement(), new Integer(idx), ccar, new Integer(length));
                }
            }
            return;
        }
        catch (IllegalAccessException iae) {
            localLogger.debug("Error Invoking Getter Method: " + ExceptionHelper.getLocalizedMessage(iae));
        }
        catch (InvocationTargetException ite) {
            localLogger.debug("Error Invoking Getter Method: " + ExceptionHelper.getLocalizedMessage(ite));
        }
        throw new CpoException("invokeGetter: Could not find a Getter for " + obj.getClass());
    }

    public void invokeGetter(JdbcPreparedStatementFactory jpsf, Object obj, int idx) throws CpoException {
        Object param = null;
        JavaSqlMethod<?> jdbcMethod = null;
        String msg = null;
        Logger localLogger = obj == null ? logger : LoggerFactory.getLogger((String)obj.getClass().getName());
        try {
            if (this.hasTransformPS) {
                localLogger.info("Calling Transform Out:" + this.transformPSOut_.getDeclaringClass().getName());
                param = this.transformOut(jpsf, this.getGetters()[0].invoke(obj, (Object[])null));
                jdbcMethod = JavaSqlMethods.getJavaSqlMethod(this.transformPSOut_.getReturnType());
                if (jdbcMethod == null) {
                    throw new CpoException("Error Retrieveing Jdbc Method for type: " + this.transformPSOut_.getReturnType().getName());
                }
            } else {
                jdbcMethod = JavaSqlMethods.getJavaSqlMethod(this.getGetters()[0].getReturnType());
                param = this.getGetters()[0].invoke(obj, (Object[])null);
                if (jdbcMethod == null) {
                    localLogger.debug("jdbcMethod is null");
                    throw new CpoException("Error Retrieveing Jdbc Method for type: " + this.getGetters()[0].getReturnType().getName());
                }
            }
        }
        catch (Exception e) {
            msg = "Error Invoking Getter Method: " + this.getGetters()[0].getReturnType().getName() + " " + this.getGetters()[0].getName() + "():" + ExceptionHelper.getLocalizedMessage(e);
        }
        if (msg == null) {
            localLogger.info(this.dbName_ + "=" + param);
            try {
                switch (jdbcMethod.getMethodType()) {
                    case 0: {
                        jdbcMethod.getPsSetter().invoke((Object)jpsf.getPreparedStatement(), new Integer(idx), param);
                        break;
                    }
                    case 1: {
                        CpoByteArrayInputStream cbais = CpoByteArrayInputStream.getCpoStream((InputStream)param);
                        jdbcMethod.getPsSetter().invoke((Object)jpsf.getPreparedStatement(), new Integer(idx), cbais, new Integer(cbais.getLength()));
                        break;
                    }
                    case 2: {
                        CpoCharArrayReader ccar = CpoCharArrayReader.getCpoReader((Reader)param);
                        jdbcMethod.getPsSetter().invoke((Object)jpsf.getPreparedStatement(), new Integer(idx), ccar, new Integer(ccar.getLength()));
                    }
                }
                return;
            }
            catch (Exception e) {
                msg = "Error Invoking Jdbc Method: " + jdbcMethod.getPsSetter().getName() + ":" + ExceptionHelper.getLocalizedMessage(e);
            }
        }
        if (msg != null) {
            localLogger.error(msg);
            throw new CpoException(msg);
        }
    }

    protected void setJavaSqlType(int type) {
        this.javaSqlType_ = type;
    }

    protected int getJavaSqlType() {
        return this.javaSqlType_;
    }

    protected void setTransformClass(String className) throws CpoException {
        block10: {
            Class<?> transformClass = null;
            Logger localLogger = className == null ? logger : LoggerFactory.getLogger((String)className);
            try {
                if (className == null || className.length() <= 0) break block10;
                try {
                }
                catch (Exception e) {
                    String msg = ExceptionHelper.getLocalizedMessage(e);
                    localLogger.error("Invalid Transform Class specified:<" + className + ">");
                    throw new CpoException("Invalid Transform Class specified:<" + className + ">:");
                }
                this.transformObject_ = transformClass.newInstance();
                for (transformClass = Class.forName(className); transformClass != null; transformClass = transformClass.getEnclosingClass()) {
                    for (Method m : transformClass.getDeclaredMethods()) {
                        if (m.isSynthetic() || m.isBridge()) continue;
                        if (!this.hasTransformIn && m.getName().equals("transformIn")) {
                            this.transformIn_ = m;
                            this.hasTransformIn = true;
                            continue;
                        }
                        if (!m.getName().equals("transformOut")) continue;
                        if (!this.hasTransformPS && m.getParameterTypes()[0].getName().equals("org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory")) {
                            this.transformPSOut_ = m;
                            this.hasTransformPS = true;
                            continue;
                        }
                        if (this.hasTransformCS || !m.getParameterTypes()[0].getName().equals("org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory")) continue;
                        this.transformCSOut_ = m;
                        this.hasTransformCS = true;
                    }
                }
                if (this.transformIn_ == null && this.transformPSOut_ == null && this.transformCSOut_ == null) {
                    localLogger.error("Invalid Transform Class specified:<" + className + ">: Abstract Methods not Found");
                    throw new CpoException("Invalid Transform Class specified:<" + className + ">: Abstract Methods not Found");
                }
            }
            catch (CpoException ce) {
                throw ce;
            }
            catch (Exception e) {
                localLogger.debug("Error Setting Transform Class: " + ExceptionHelper.getLocalizedMessage(e));
                this.transformObject_ = null;
                this.transformIn_ = null;
                this.transformCSOut_ = null;
                this.transformPSOut_ = null;
                throw new CpoException(e);
            }
        }
    }

    private void dumpMethod(Method m) {
        logger.debug("========================");
        logger.debug("===> Declaring Class: " + m.getDeclaringClass().getName());
        logger.debug("===> Method Signature: " + m.toString());
        logger.debug("===> Generic Signature: " + m.toGenericString());
        logger.debug("===> Method isBridge: " + m.isBridge());
        logger.debug("===> Method isSynthetic: " + m.isSynthetic());
        logger.debug("========================");
    }

    protected Object transformIn(Object datasourceObject) throws CpoException {
        Object retObj = datasourceObject;
        if (this.transformObject_ != null && this.transformIn_ != null) {
            try {
                retObj = this.transformIn_.invoke(this.transformObject_, datasourceObject);
            }
            catch (IllegalAccessException iae) {
                LoggerFactory.getLogger((String)this.transformIn_.getName()).error("Error Invoking transformIn: " + this.transformIn_.getName() + ExceptionHelper.getLocalizedMessage(iae));
                throw new CpoException(iae);
            }
            catch (InvocationTargetException ite) {
                LoggerFactory.getLogger((String)this.transformIn_.getName()).error("Error Invoking transformIn: " + this.transformIn_.getName() + ExceptionHelper.getLocalizedMessage(ite));
                throw new CpoException(ite.getCause());
            }
        }
        return retObj;
    }

    protected Object transformOut(JdbcPreparedStatementFactory jpsf, Object attributeObject) throws CpoException {
        Object retObj = attributeObject;
        if (this.transformObject_ != null && this.transformPSOut_ != null) {
            try {
                retObj = this.transformPSOut_.invoke(this.transformObject_, jpsf, attributeObject);
            }
            catch (IllegalAccessException iae) {
                LoggerFactory.getLogger((String)this.transformPSOut_.getName()).error("Error Invoking transformOut: " + this.transformPSOut_.getName() + ExceptionHelper.getLocalizedMessage(iae));
                throw new CpoException(iae);
            }
            catch (InvocationTargetException ite) {
                LoggerFactory.getLogger((String)this.transformPSOut_.getName()).error("Error Invoking transformOut: " + this.transformPSOut_.getName() + ExceptionHelper.getLocalizedMessage(ite));
                throw new CpoException(ite.getCause());
            }
        }
        return retObj;
    }

    protected Object transformOut(JdbcCallableStatementFactory jcsf, Object attributeObject) throws CpoException {
        Object retObj = attributeObject;
        if (this.transformObject_ != null && this.transformCSOut_ != null) {
            try {
                retObj = this.transformCSOut_.invoke(this.transformObject_, jcsf, attributeObject);
            }
            catch (IllegalAccessException iae) {
                LoggerFactory.getLogger((String)this.transformCSOut_.getName()).error("Error Invoking transformOut: " + this.transformCSOut_.getName() + ExceptionHelper.getLocalizedMessage(iae));
                throw new CpoException(iae);
            }
            catch (InvocationTargetException ite) {
                LoggerFactory.getLogger((String)this.transformCSOut_.getName()).error("Error Invoking transformOut: " + this.transformCSOut_.getName() + ExceptionHelper.getLocalizedMessage(ite));
                throw new CpoException(ite.getCause());
            }
        }
        return retObj;
    }

    private boolean isPrimitiveAssignableFrom(Class clazz, Class paramClass) {
        if (clazz.isPrimitive() ^ paramClass.isPrimitive()) {
            Class objClass;
            Class primClass;
            if (clazz.isPrimitive()) {
                primClass = clazz;
                objClass = paramClass;
            } else {
                primClass = paramClass;
                objClass = clazz;
            }
            if (objClass.getSimpleName().toLowerCase().startsWith(primClass.getSimpleName())) {
                for (Constructor<?> ctor : objClass.getConstructors()) {
                    Class<?>[] types = ctor.getParameterTypes();
                    if (types.length <= 0 || !types[0].isAssignableFrom(primClass)) continue;
                    return true;
                }
            } else {
                LoggerFactory.getLogger((String)this.getClass().getName()).debug("Wrapper Class:" + objClass.getName().toLowerCase() + "does not start with " + primClass.getName());
            }
        }
        return false;
    }
}

