/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.DataSourceInfo;

public class ClassDataSourceInfo
implements DataSourceInfo,
DataSource,
ConnectionEventListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private DataSource dataSource = null;
    private ConnectionPoolDataSource poolDataSource = null;
    private String dataSourceName = null;
    private String tablePrefix = null;
    private Map<String, String> properties = null;
    private PrintWriter printWriter_ = null;
    private int timeout_ = 0;
    private final Object LOCK = new Object();
    private Queue<PooledConnection> freeConnections = new LinkedList<PooledConnection>();
    private Queue<PooledConnection> usedConnections = new LinkedList<PooledConnection>();

    public ClassDataSourceInfo(String className) throws CpoException {
        this.loadClass(className);
        this.dataSourceName = className;
    }

    public ClassDataSourceInfo(String className, String tablePrefix) throws CpoException {
        this.loadClass(className);
        this.dataSourceName = className;
        if (tablePrefix != null) {
            this.tablePrefix = tablePrefix;
        }
    }

    public ClassDataSourceInfo(String className, Map<String, String> properties) throws CpoException {
        this.loadClass(className);
        this.dataSourceName = this.BuildDataSourceName(className, properties);
        this.setClassProperties(properties);
    }

    public ClassDataSourceInfo(String className, Map<String, String> properties, String tablePrefix) throws CpoException {
        this.loadClass(className);
        this.dataSourceName = this.BuildDataSourceName(className, properties);
        this.setClassProperties(properties);
        if (tablePrefix != null) {
            this.tablePrefix = tablePrefix;
        }
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public String getTablePrefix() {
        return this.tablePrefix;
    }

    @Override
    public DataSource getDataSource() throws CpoException {
        return this.dataSource;
    }

    private String BuildDataSourceName(String s, Map<String, String> properties) {
        StringBuilder dsName = new StringBuilder(s);
        TreeMap<String, String> treeMap = new TreeMap<String, String>(properties);
        for (String key : treeMap.keySet()) {
            dsName.append(key);
            dsName.append("=");
            dsName.append(properties.get(key));
        }
        return dsName.toString();
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.makeNewConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection makeNewConnection() throws SQLException {
        PooledConnection pooledConn = null;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.freeConnections.isEmpty()) {
                pooledConn = this.freeConnections.poll();
            } else {
                pooledConn = this.poolDataSource.getPooledConnection();
                pooledConn.addConnectionEventListener(this);
            }
            this.usedConnections.add(pooledConn);
        }
        return pooledConn.getConnection();
    }

    public synchronized String toString() {
        StringBuilder info = new StringBuilder();
        info.append("JdbcDataSource(");
        info.append(this.dataSourceName);
        info.append(")");
        return info.toString();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter_;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter_ = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.timeout_ = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.timeout_;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private void loadClass(String className) throws CpoException {
        block6: {
            try {
                Class<?> dsClass = Class.forName(className);
                Object ds = dsClass.newInstance();
                if (ds instanceof ConnectionPoolDataSource) {
                    this.poolDataSource = (ConnectionPoolDataSource)ds;
                    this.dataSource = this;
                    break block6;
                }
                if (ds instanceof DataSource) {
                    this.dataSource = (DataSource)ds;
                    break block6;
                }
                throw new CpoException(className + "is not a DataSource");
            }
            catch (ClassNotFoundException cnfe) {
                throw new CpoException("Could Not Find Class" + className, cnfe);
            }
            catch (InstantiationException ie) {
                throw new CpoException("Could Not Instantiate Class" + className, ie);
            }
            catch (IllegalAccessException iae) {
                throw new CpoException("Could Not Access Class" + className, iae);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ConnectionEvent ce) {
        Object object = this.LOCK;
        synchronized (object) {
            PooledConnection pc = (PooledConnection)ce.getSource();
            if (this.usedConnections.remove(pc)) {
                this.freeConnections.add(pc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionErrorOccurred(ConnectionEvent ce) {
        Object object = this.LOCK;
        synchronized (object) {
            PooledConnection pc = (PooledConnection)ce.getSource();
            if (!this.usedConnections.remove(pc)) {
                this.freeConnections.remove(pc);
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        for (PooledConnection pc : this.freeConnections) {
            pc.removeConnectionEventListener(this);
            try {
                pc.close();
            }
            catch (SQLException se) {}
        }
        for (PooledConnection pc : this.usedConnections) {
            pc.removeConnectionEventListener(this);
            try {
                pc.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void setClassProperties(Map<String, String> properties) {
        CommonDataSource ds = this.dataSource;
        if (this.poolDataSource != null) {
            ds = this.poolDataSource;
        }
        for (String key : properties.keySet()) {
            this.setObjectProperty(ds, key, properties.get(key));
        }
    }

    private void setObjectProperty(Object obj, String key, String value) {
        String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
        try {
            Method setter = obj.getClass().getMethod(methodName, String.class);
            setter.invoke(obj, value);
        }
        catch (NoSuchMethodException nsme) {
            this.logger.error("Could not find setter Method:" + methodName + " for property:" + key, (Throwable)nsme);
        }
        catch (InvocationTargetException ite) {
            this.logger.error("Error Invoking setter Method:" + methodName, (Throwable)ite);
        }
        catch (IllegalAccessException iae) {
            this.logger.error("Error accessing setter Method:" + methodName, (Throwable)iae);
        }
    }
}

