/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoNativeQuery;
import org.synchronoss.cpo.CpoOrderBy;
import org.synchronoss.cpo.CpoReleasible;
import org.synchronoss.cpo.CpoWhere;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.BindAttribute;
import org.synchronoss.cpo.jdbc.JavaSqlMethod;
import org.synchronoss.cpo.jdbc.JavaSqlMethods;
import org.synchronoss.cpo.jdbc.JdbcAttribute;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;
import org.synchronoss.cpo.jdbc.JdbcCpoOrderBy;
import org.synchronoss.cpo.jdbc.JdbcCpoWhere;
import org.synchronoss.cpo.jdbc.JdbcMetaClass;
import org.synchronoss.cpo.jdbc.JdbcParameter;
import org.synchronoss.cpo.jdbc.JdbcQuery;
import org.synchronoss.cpo.jdbc.JdbcWhereBuilder;

public class JdbcPreparedStatementFactory
implements CpoReleasible {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)JdbcPreparedStatementFactory.class.getName());
    private Logger localLogger = null;
    private PreparedStatement ps_ = null;
    private ArrayList<CpoReleasible> releasibles = new ArrayList();
    private static final String WHERE_MARKER = "__CPO_WHERE__";
    private static final String ORDERBY_MARKER = "__CPO_ORDERBY__";

    private JdbcPreparedStatementFactory() {
    }

    public <T> JdbcPreparedStatementFactory(Connection conn, JdbcCpoAdapter jca, JdbcMetaClass<T> jmcCriteria, JdbcQuery jq, T obj, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeQuery> nativeQueries) throws CpoException {
        List<BindAttribute> bindValues = this.getBindValues(jq, obj);
        String sql = this.buildSql(jmcCriteria, jq.getText(), wheres, orderBy, nativeQueries, bindValues);
        this.localLogger = obj == null ? logger : LoggerFactory.getLogger((String)obj.getClass().getName());
        this.localLogger.debug("JdbcQuery SQL = <" + sql + ">");
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            this.localLogger.error("Error Instantiating JdbcPreparedStatementFactory SQL=<" + sql + ">" + ExceptionHelper.getLocalizedMessage(se));
            throw new CpoException(se);
        }
        this.setPreparedStatement(pstmt);
        this.setBindValues(bindValues);
    }

    private <T> String buildSql(JdbcMetaClass<T> jmc, String sql, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeQuery> nativeQueries, List<BindAttribute> bindValues) throws CpoException {
        StringBuilder sqlText = new StringBuilder();
        sqlText.append(sql);
        if (wheres != null) {
            for (CpoWhere where : wheres) {
                JdbcWhereBuilder<T> jwb = new JdbcWhereBuilder<T>(jmc);
                JdbcCpoWhere jcw = (JdbcCpoWhere)where;
                try {
                    jcw.acceptDFVisitor(jwb);
                }
                catch (Exception e) {
                    throw new CpoException("Unable to build WHERE clause", e);
                }
                if (sqlText.indexOf(jcw.getName()) == -1) {
                    sqlText.append(" ");
                    sqlText.append(jwb.getWhereClause());
                    bindValues.addAll(jwb.getBindValues());
                    continue;
                }
                sqlText = this.replaceMarker(sqlText, jcw.getName(), jwb, bindValues);
            }
        }
        if (orderBy != null) {
            HashMap<String, StringBuilder> mapOrderBy = new HashMap<String, StringBuilder>();
            try {
                for (CpoOrderBy ob : orderBy) {
                    StringBuilder sb = (StringBuilder)mapOrderBy.get(ob.getName());
                    if (sb == null) {
                        sb = new StringBuilder(" ORDER BY ");
                        mapOrderBy.put(ob.getName(), sb);
                    } else {
                        sb.append(",");
                    }
                    sb.append(((JdbcCpoOrderBy)ob).toString(jmc));
                }
            }
            catch (CpoException ce) {
                throw new CpoException("Error Processing OrderBy Attribute<" + ExceptionHelper.getLocalizedMessage(ce) + "> not Found. JDBC Query=<" + sqlText.toString() + ">");
            }
            Set entries = mapOrderBy.entrySet();
            for (Map.Entry entry : entries) {
                if (sqlText.indexOf((String)entry.getKey()) == -1) {
                    sqlText.append(((StringBuilder)entry.getValue()).toString());
                    continue;
                }
                sqlText = this.replaceMarker(sqlText, (String)entry.getKey(), ((StringBuilder)entry.getValue()).toString());
            }
        }
        if (nativeQueries != null) {
            for (CpoNativeQuery cnq : nativeQueries) {
                if (cnq.getMarker() == null || sqlText.indexOf(cnq.getMarker()) == -1) {
                    if (cnq.getNativeText() == null || cnq.getNativeText().length() <= 0) continue;
                    sqlText.append(" ");
                    sqlText.append(cnq.getNativeText());
                    continue;
                }
                sqlText = this.replaceMarker(sqlText, cnq.getMarker(), cnq.getNativeText());
            }
        }
        sqlText = this.replaceMarker(sqlText, WHERE_MARKER, "");
        sqlText = this.replaceMarker(sqlText, ORDERBY_MARKER, "");
        return sqlText.toString();
    }

    private StringBuilder replaceMarker(StringBuilder source, String marker, String replace) {
        int attrOffset = 0;
        int fromIndex = 0;
        int mLength = marker.length();
        String replaceText = replace == null ? "" : replace;
        int rLength = replaceText.length();
        if (source != null && source.length() > 0) {
            while ((attrOffset = source.indexOf(marker, fromIndex)) != -1) {
                source.replace(attrOffset, attrOffset + mLength, replaceText);
                fromIndex = attrOffset + rLength;
            }
        }
        return source;
    }

    private <T> StringBuilder replaceMarker(StringBuilder source, String marker, JdbcWhereBuilder<T> jwb, List<BindAttribute> bindValues) {
        int attrOffset = 0;
        int fromIndex = 0;
        int mLength = marker.length();
        String replace = jwb.getWhereClause();
        int rLength = replace.length();
        Collection<BindAttribute> jwbBindValues = jwb.getBindValues();
        if (source != null && source.length() > 0) {
            while ((attrOffset = source.indexOf(marker, fromIndex)) != -1) {
                source.replace(attrOffset, attrOffset + mLength, replace);
                fromIndex = attrOffset + rLength;
                bindValues.addAll(this.countBindMarkers(source.substring(0, attrOffset)), jwbBindValues);
            }
        }
        return source;
    }

    private int countBindMarkers(String source) {
        StringReader reader = null;
        int rc = -1;
        int qMarks = 0;
        boolean inDoubleQuotes = false;
        boolean inSingleQuotes = false;
        if (source != null) {
            reader = new StringReader(source);
            try {
                do {
                    if ((char)(rc = reader.read()) == '\'') {
                        inSingleQuotes = !inSingleQuotes;
                        continue;
                    }
                    if ((char)rc == '\"') {
                        inDoubleQuotes = !inDoubleQuotes;
                        continue;
                    }
                    if (inSingleQuotes || inDoubleQuotes || (char)rc != '?') continue;
                    ++qMarks;
                } while (rc != -1);
            }
            catch (Exception e) {
                logger.error("error counting bind markers");
            }
        }
        return qMarks;
    }

    public PreparedStatement getPreparedStatement() {
        return this.ps_;
    }

    protected void setPreparedStatement(PreparedStatement ps) {
        this.ps_ = ps;
    }

    public void AddReleasible(CpoReleasible releasible) {
        if (releasible != null) {
            this.releasibles.add(releasible);
        }
    }

    @Override
    public void release() throws CpoException {
        for (CpoReleasible releasible : this.releasibles) {
            try {
                releasible.release();
            }
            catch (CpoException ce) {
                this.localLogger.error("Error Releasing Prepared Statement Transform Object", (Throwable)ce);
                throw ce;
            }
        }
    }

    protected List<BindAttribute> getBindValues(JdbcQuery jq, Object obj) throws CpoException {
        ArrayList<BindAttribute> bindValues = new ArrayList<BindAttribute>();
        ArrayList<JdbcParameter> parameters = jq.getParameterList();
        JdbcParameter parameter = null;
        for (int j = 0; j < parameters.size(); ++j) {
            parameter = parameters.get(j);
            if (parameter == null) {
                throw new CpoException("JdbcParameter is null!");
            }
            bindValues.add(new BindAttribute(parameter.getAttribute(), obj));
        }
        return bindValues;
    }

    protected void setBindValues(Collection<BindAttribute> bindValues) throws CpoException {
        if (bindValues != null) {
            int index = 1;
            for (BindAttribute bindAttr : bindValues) {
                Object bindObject = bindAttr.getBindObject();
                JdbcAttribute ja = bindAttr.getJdbcAttribute();
                JavaSqlMethod<?> jsm = null;
                if (bindAttr.isIn() && bindObject instanceof Collection) {
                    Iterator i$ = ((Collection)bindObject).iterator();
                    if (i$.hasNext()) {
                        Object obj = i$.next();
                        jsm = JavaSqlMethods.getJavaSqlMethod(obj.getClass());
                    }
                } else {
                    jsm = JavaSqlMethods.getJavaSqlMethod(bindObject.getClass());
                }
                if (jsm != null) {
                    try {
                        if (ja == null) {
                            this.localLogger.debug(bindAttr.getName() + "=" + bindObject);
                        } else {
                            this.localLogger.debug(ja.getDbName() + "=" + bindObject);
                        }
                        if (bindAttr.isIn() && bindObject instanceof Collection) {
                            for (Object obj : (Collection)bindObject) {
                                jsm.getPsSetter().invoke((Object)this.getPreparedStatement(), index++, obj);
                            }
                            continue;
                        }
                        jsm.getPsSetter().invoke((Object)this.getPreparedStatement(), index++, bindObject);
                        continue;
                    }
                    catch (IllegalAccessException iae) {
                        this.localLogger.error("Error Accessing Prepared Statement Setter: " + ExceptionHelper.getLocalizedMessage(iae));
                        throw new CpoException(iae);
                    }
                    catch (InvocationTargetException ite) {
                        this.localLogger.error("Error Invoking Prepared Statement Setter: " + ExceptionHelper.getLocalizedMessage(ite));
                        throw new CpoException(ite.getCause());
                    }
                }
                ja.invokeGetter(this, bindObject, index++);
            }
        }
    }
}

