/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import org.synchronoss.cpo.INodeVisitor;
import org.synchronoss.cpo.Node;
import org.synchronoss.cpo.jdbc.BindAttribute;
import org.synchronoss.cpo.jdbc.JdbcAttribute;
import org.synchronoss.cpo.jdbc.JdbcCpoWhere;
import org.synchronoss.cpo.jdbc.JdbcMetaClass;

public class JdbcWhereBuilder<T>
implements INodeVisitor {
    private StringBuilder whereClause = new StringBuilder();
    private JdbcMetaClass<T> jmc = null;
    private Collection<BindAttribute> bindValues = new ArrayList<BindAttribute>();

    public String getWhereClause() {
        return this.whereClause.toString();
    }

    public Collection<BindAttribute> getBindValues() {
        return this.bindValues;
    }

    private JdbcWhereBuilder() {
    }

    public JdbcWhereBuilder(JdbcMetaClass<T> jmc) {
        this.jmc = jmc;
    }

    @Override
    public boolean visitBegin(Node node) throws Exception {
        JdbcCpoWhere jcw = (JdbcCpoWhere)node;
        this.whereClause.append(jcw.toString(this.jmc));
        if (jcw.hasParent() || jcw.getLogical() != -1) {
            this.whereClause.append(" (");
        } else {
            this.whereClause.append(" ");
        }
        return true;
    }

    @Override
    public boolean visitMiddle(Node node) throws Exception {
        return true;
    }

    @Override
    public boolean visitEnd(Node node) throws Exception {
        JdbcCpoWhere jcw = (JdbcCpoWhere)node;
        if (jcw.hasParent() || jcw.getLogical() != -1) {
            this.whereClause.append(")");
        }
        return true;
    }

    @Override
    public boolean visit(Node node) throws Exception {
        JdbcCpoWhere jcw = (JdbcCpoWhere)node;
        JdbcAttribute attribute = null;
        this.whereClause.append(jcw.toString(this.jmc));
        if (jcw.getValue() != null) {
            attribute = this.jmc.getColumnMap().get(jcw.getAttribute());
            if (attribute == null) {
                attribute = this.jmc.getColumnMap().get(jcw.getRightAttribute());
            }
            if (attribute == null) {
                this.bindValues.add(new BindAttribute(jcw.getAttribute() == null ? jcw.getRightAttribute() : jcw.getAttribute(), jcw.getValue(), jcw.getComparison() == 4));
            } else {
                this.bindValues.add(new BindAttribute(attribute, jcw.getValue(), jcw.getComparison() == 4));
            }
        }
        return true;
    }
}

