/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.io.CharArrayWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import oracle.sql.CLOB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.transform.Transform;
import org.synchronoss.cpo.transform.jdbc.OracleTemporaryClob;

public class TransformClob
implements Transform<Clob, char[]> {
    private static Logger logger = LoggerFactory.getLogger((String)TransformClob.class.getName());

    @Override
    public char[] transformIn(Clob clob) throws CpoException {
        char[] buffChars = new char[1024];
        char[] retChars = null;
        int length = 0;
        CharArrayWriter caw = new CharArrayWriter();
        if (clob != null) {
            try {
                Reader is = clob.getCharacterStream();
                while ((length = is.read(buffChars)) != -1) {
                    caw.write(buffChars, 0, length);
                }
                is.close();
                retChars = caw.toCharArray();
            }
            catch (Exception e) {
                logger.debug("Error in transform blob", (Throwable)e);
                throw new CpoException(e);
            }
        }
        return retChars;
    }

    @Override
    public Clob transformOut(JdbcPreparedStatementFactory jpsf, char[] attributeObject) throws CpoException {
        CLOB newClob = null;
        try {
            if (attributeObject != null) {
                newClob = CLOB.createTemporary((Connection)jpsf.getPreparedStatement().getConnection(), (boolean)false, (int)10);
                jpsf.AddReleasible(new OracleTemporaryClob(newClob));
                Writer cos = newClob.setCharacterStream(0L);
                cos.write(attributeObject);
                cos.close();
            }
        }
        catch (Exception e) {
            String msg = "Error CLOBing Char Array";
            logger.error(msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        return newClob;
    }

    @Override
    public Clob transformOut(JdbcCallableStatementFactory jpsf, char[] attributeObject) throws CpoException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

