/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpoBlockingResultSet<E>
implements CpoResultSet<E>,
Iterator<E> {
    private static Logger logger = LoggerFactory.getLogger((String)CpoBlockingResultSet.class.getName());
    private static final long serialVersionUID = 1L;
    private int capacity = 0;
    private final ThreadLocal<E> tlObj = new ThreadLocal();
    private LinkedBlockingQueue<E> lbq = null;
    private final Set<Thread> producers = new HashSet<Thread>();
    private final Set<Thread> consumers = new HashSet<Thread>();
    private boolean done = false;

    private CpoBlockingResultSet() {
    }

    public CpoBlockingResultSet(int capacity) {
        this.capacity = capacity;
        this.lbq = new LinkedBlockingQueue(capacity);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.producers.add(Thread.currentThread());
        logger.debug("Put Called");
        this.lbq.put(e);
    }

    @Override
    public boolean hasNext() {
        logger.debug("hasNext Called");
        if (this.tlObj.get() != null || this.lbq.size() > 0) {
            return true;
        }
        if (this.lbq.size() == 0) {
            Thread.currentThread();
            if (Thread.interrupted()) {
                return false;
            }
        }
        try {
            this.tlObj.set(this.lbq.take());
        }
        catch (InterruptedException ie) {
            logger.error("CpoBlockingResultSet.hasNext() - Interrupted and bailing out");
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.lbq.size();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E next() throws NoSuchElementException {
        logger.debug("next Called");
        E ret = this.tlObj.get();
        if (ret == null) {
            if (this.lbq.size() == 0) {
                Thread.currentThread();
                if (Thread.interrupted()) {
                    throw new NoSuchElementException();
                }
            }
            try {
                ret = this.take();
            }
            catch (InterruptedException ie) {
                logger.error("CpoBlockingResultSet.next() - Interrupted and bailing out");
                throw new NoSuchElementException();
            }
        } else {
            this.tlObj.set(null);
        }
        return ret;
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    @Override
    public E take() throws InterruptedException {
        this.consumers.add(Thread.currentThread());
        logger.debug("Take Called");
        return this.lbq.take();
    }

    @Override
    public void cancel() {
        for (Thread t : this.consumers) {
            t.interrupt();
        }
        for (Thread t : this.producers) {
            t.interrupt();
        }
    }

    @Override
    public int getFetchSize() {
        return this.capacity;
    }
}

