/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.encrypt.Encryptor;
import org.synchronoss.cpo.encrypt.EncryptorFactory;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformStringToEncryptedString
implements Transform<String, String> {
    private static Logger logger = LoggerFactory.getLogger((String)TransformStringToEncryptedString.class.getName());
    private static Encryptor encryptor = null;
    private static String encLock = "lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformStringToEncryptedString() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        logger.debug("in contructor TransformStringToEncryptedString()");
        String string = encLock;
        synchronized (string) {
            if (encryptor == null) {
                encryptor = EncryptorFactory.getEncryptor();
            }
        }
    }

    @Override
    public String transformIn(String inString) throws CpoException {
        logger.debug("ENTERING transformIn: " + inString);
        if (inString != null) {
            try {
                inString = encryptor.decrypt(inString);
            }
            catch (Exception ex) {
                throw new CpoException(ex.getMessage());
            }
        }
        return inString;
    }

    @Override
    public String transformOut(JdbcPreparedStatementFactory jpsf, String outString) throws CpoException {
        logger.debug("ENTERING transformOut: " + outString);
        if (outString != null) {
            try {
                logger.debug("....");
                outString = encryptor.encrypt(outString);
                logger.debug("EXITING transformOut: " + outString);
            }
            catch (Exception ex) {
                throw new CpoException(ex.getMessage());
            }
        }
        return outString;
    }

    @Override
    public String transformOut(JdbcCallableStatementFactory jpsf, String attributeObject) throws CpoException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

