/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.DataSourceInfo;

public class JndiDataSourceInfo
implements DataSourceInfo {
    private DataSource dataSource = null;
    private String jndiName = null;
    private Context jndiCtx = null;
    private String dataSourceName = null;
    private String tablePrefix = null;
    private Object LOCK = new Object();

    public JndiDataSourceInfo(String jndiName) {
        this.jndiName = jndiName;
        this.dataSourceName = jndiName;
    }

    public JndiDataSourceInfo(String jndiName, String tablePrefix) {
        this.jndiName = jndiName;
        this.dataSourceName = jndiName;
        if (tablePrefix != null) {
            this.tablePrefix = tablePrefix;
        }
    }

    public JndiDataSourceInfo(String jndiName, Context ctx) {
        this.jndiName = jndiName;
        this.dataSourceName = jndiName;
        this.jndiCtx = ctx;
    }

    public JndiDataSourceInfo(String jndiName, Context ctx, String tablePrefix) {
        this.jndiName = jndiName;
        this.dataSourceName = jndiName;
        this.jndiCtx = ctx;
        if (tablePrefix != null) {
            this.tablePrefix = tablePrefix;
        }
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public String getTablePrefix() {
        return this.tablePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource() throws CpoException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        Object object = this.LOCK;
        synchronized (object) {
            try {
                if (this.jndiCtx == null) {
                    this.jndiCtx = new InitialContext();
                }
                this.dataSource = (DataSource)this.jndiCtx.lookup(this.jndiName);
            }
            catch (Exception e) {
                throw new CpoException("Error instantiating DataSource", e);
            }
        }
        return this.dataSource;
    }
}

