/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.encrypt.Encryptor;
import org.synchronoss.cpo.encrypt.EncryptorFactory;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;

public class TransformDateToEncryptedString {
    private static Logger logger = Logger.getLogger((String)TransformDateToEncryptedString.class.getName());
    private static Encryptor encryptor = null;
    private static String encLock = "lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformDateToEncryptedString() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = encLock;
        synchronized (string) {
            if (encryptor == null) {
                encryptor = EncryptorFactory.getEncryptor();
            }
        }
    }

    public Timestamp transformIn(String inDateString) throws CpoException {
        logger.debug((Object)"ENTERING transformIn");
        Timestamp inDate = null;
        if (inDateString != null) {
            try {
                logger.debug((Object)("encrypted string from db is " + inDateString));
                String dbDateString = encryptor.decrypt(inDateString);
                logger.debug((Object)("decrypted string is " + dbDateString));
                inDate = Timestamp.valueOf(dbDateString);
                logger.debug((Object)("Timestamp is " + inDate));
            }
            catch (Exception e) {
                throw new CpoException(e.getMessage());
            }
        }
        return inDate;
    }

    public String transformOut(JdbcPreparedStatementFactory jpsf, Timestamp tsOut) throws CpoException {
        String outString = null;
        logger.debug((Object)"ENTERING transformOut");
        if (tsOut != null) {
            try {
                String encString = tsOut.toString();
                logger.debug((Object)("String to encrypt is " + encString));
                outString = encryptor.encrypt(encString);
            }
            catch (Exception e) {
                throw new CpoException(e.getMessage());
            }
        }
        return outString;
    }
}

