/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import org.apache.log4j.Logger;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.encrypt.Encryptor;
import org.synchronoss.cpo.encrypt.EncryptorFactory;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;

public class TransformStringToEncryptedString {
    private static Logger logger = Logger.getLogger((String)TransformStringToEncryptedString.class.getName());
    private static Encryptor encryptor = null;
    private static String encLock = "lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformStringToEncryptedString() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        logger.debug((Object)"in contructor TransformStringToEncryptedString()");
        String string = encLock;
        synchronized (string) {
            if (encryptor == null) {
                encryptor = EncryptorFactory.getEncryptor();
            }
        }
    }

    public String transformIn(String inString) throws CpoException {
        logger.debug((Object)("ENTERING transformIn: " + inString));
        if (inString != null) {
            try {
                inString = encryptor.decrypt(inString);
            }
            catch (Exception ex) {
                throw new CpoException(ex.getMessage());
            }
        }
        return inString;
    }

    public String transformOut(JdbcPreparedStatementFactory jpsf, String outString) throws CpoException {
        logger.debug((Object)("ENTERING transformOut: " + outString));
        if (outString != null) {
            try {
                logger.debug((Object)"....");
                outString = encryptor.encrypt(outString);
                logger.debug((Object)("EXITING transformOut: " + outString));
            }
            catch (Exception ex) {
                throw new CpoException(ex.getMessage());
            }
        }
        return outString;
    }
}

