/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import oracle.sql.BLOB;
import org.apache.log4j.Logger;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.transform.jdbc.OracleTemporaryBlob;

public class TransformBlob {
    private static Logger logger = Logger.getLogger((String)TransformBlob.class.getName());

    public byte[] transformIn(Blob blob) throws CpoException {
        byte[] buffBytes = new byte[1024];
        byte[] retBytes = null;
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (blob != null) {
            logger.debug((Object)"BLOB IS NOT NULL");
            try {
                InputStream is = blob.getBinaryStream();
                while ((length = is.read(buffBytes)) != -1) {
                    bos.write(buffBytes, 0, length);
                }
                is.close();
                retBytes = bos.toByteArray();
                logger.debug((Object)("Got " + retBytes.length + " bytes"));
            }
            catch (Exception e) {
                logger.debug((Object)"Error in transform blob", (Throwable)e);
                throw new CpoException(e);
            }
        }
        return retBytes;
    }

    public Blob transformOut(JdbcPreparedStatementFactory jpsf, byte[] attributeObject) throws CpoException {
        BLOB newBlob = null;
        try {
            if (attributeObject != null) {
                newBlob = BLOB.createTemporary((Connection)jpsf.getPreparedStatement().getConnection(), (boolean)false, (int)10);
                jpsf.AddReleasible(new OracleTemporaryBlob(newBlob));
                OutputStream os = newBlob.setBinaryStream(0L);
                os.write(attributeObject);
                os.close();
            }
        }
        catch (Exception e) {
            String msg = "Error BLOBing Byte Array";
            logger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        return newBlob;
    }
}

