/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;

public class TransformGZipBytes {
    private static Logger logger = Logger.getLogger((String)TransformGZipBytes.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] transformIn(byte[] inBytes) throws CpoException {
        byte[] buffBytes = new byte[1024];
        byte[] retBytes = null;
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (inBytes == null) return retBytes;
        if (inBytes.length <= 0) return new byte[0];
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(inBytes);
            if (bis == null) return retBytes;
            GZIPInputStream gzis = new GZIPInputStream(bis);
            while ((length = gzis.read(buffBytes)) != -1) {
                bos.write(buffBytes, 0, length);
            }
            bos.flush();
            bos.close();
            gzis.close();
            ((InputStream)bis).close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)"Error in transform GZipBytes", (Throwable)e);
            throw new CpoException(e);
        }
    }

    public byte[] transformOut(JdbcPreparedStatementFactory jpsf, byte[] attributeObject) throws CpoException {
        byte[] retBytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (attributeObject != null) {
                if (attributeObject.length > 0) {
                    GZIPOutputStream os = new GZIPOutputStream(baos);
                    os.write(attributeObject);
                    os.flush();
                    os.close();
                    baos.flush();
                    baos.close();
                    retBytes = baos.toByteArray();
                } else {
                    retBytes = new byte[]{};
                }
            }
        }
        catch (Exception e) {
            String msg = "Error GZipping Byte Array";
            logger.error((Object)msg, (Throwable)e);
            throw new CpoException(msg, e);
        }
        return retBytes;
    }
}

