/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo;

import java.math.BigInteger;
import java.net.InetAddress;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUID {
    private static GUID guid;
    private SecureRandom seeder;
    SecureRandom sr;
    String guidMidValue;
    private static Logger OUT;

    private GUID() {
        this.initGuid();
    }

    private void initGuid() {
        try {
            this.seeder = SecureRandom.getInstance("SHA1PRNG");
            this.seeder.generateSeed(20);
            this.sr = SecureRandom.getInstance("SHA1PRNG");
            byte[] newSeed = new byte[20];
            this.seeder.nextBytes(newSeed);
            this.sr.setSeed(newSeed);
            StringBuffer tmpBuffer = new StringBuffer();
            InetAddress inet = InetAddress.getLocalHost();
            byte[] bytes = inet.getAddress();
            String hexInetAddress = GUID.hexFormat(new BigInteger(bytes).intValue());
            String thisHashCode = GUID.hexFormat(this.hashCode());
            tmpBuffer.append("-");
            tmpBuffer.append(hexInetAddress.substring(0, 4));
            tmpBuffer.append("-");
            tmpBuffer.append(hexInetAddress.substring(4));
            tmpBuffer.append("-");
            tmpBuffer.append(thisHashCode.substring(0, 4));
            tmpBuffer.append("-");
            tmpBuffer.append(thisHashCode.substring(4));
            this.guidMidValue = tmpBuffer.toString();
        }
        catch (Exception e) {
            OUT.debug("initGuid: " + e.getMessage());
        }
    }

    static GUID getInstance() {
        if (guid == null) {
            guid = new GUID();
        }
        return guid;
    }

    public static String getGUID() {
        GUID guid = GUID.getInstance();
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = guid.sr.nextInt();
        String retVal = GUID.hexFormat(timeLow) + guid.guidMidValue + GUID.hexFormat(node);
        OUT.debug("getGUID(): " + retVal);
        return retVal;
    }

    private static String hexFormat(int trgt) {
        String s = Integer.toHexString(trgt);
        int sz = s.length();
        if (sz == 8) {
            return s;
        }
        int fill = 8 - sz;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < fill; ++i) {
            buf.append('0');
        }
        buf.append(s);
        return buf.toString();
    }

    static {
        OUT = LoggerFactory.getLogger(GUID.class);
    }
}

