/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import org.synchronoss.cpo.ChildNodeException;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoWhere;
import org.synchronoss.cpo.Node;
import org.synchronoss.cpo.jdbc.JdbcAttribute;
import org.synchronoss.cpo.jdbc.JdbcMetaClass;

public class JdbcCpoWhere
extends Node
implements CpoWhere {
    private static final long serialVersionUID = 1L;
    static final String[] comparisons = new String[]{"=", "<", ">", "<>", "IN", "LIKE", "<=", ">=", "EXISTS", "IS NULL"};
    static final String[] logicals = new String[]{"AND", "OR"};
    private int comparison = -1;
    private int logical = -1;
    private String attribute = null;
    private String rightAttribute = null;
    private Object value = null;
    private String attributeFunction = null;
    private String rightAttributeFunction = null;
    private String valueFunction = null;
    private boolean not = false;
    private String staticValue_ = null;
    private String name = "__CPO_WHERE__";

    public <T> JdbcCpoWhere(int logical, String attr, int comp, T value) {
        this.setLogical(logical);
        this.setAttribute(attr);
        this.setComparison(comp);
        this.setValue(value);
    }

    public <T> JdbcCpoWhere(int logical, String attr, int comp, T value, boolean not) {
        this.setLogical(logical);
        this.setAttribute(attr);
        this.setComparison(comp);
        this.setValue(value);
        this.setNot(not);
    }

    public JdbcCpoWhere() {
    }

    @Override
    public void setComparison(int i) {
        this.comparison = i < 0 || i >= comparisons.length ? -1 : i;
    }

    @Override
    public int getComparison() {
        return this.comparison;
    }

    @Override
    public void setLogical(int i) {
        this.logical = i < 0 || i >= logicals.length ? -1 : i;
    }

    @Override
    public int getLogical() {
        return this.logical;
    }

    @Override
    public void setAttribute(String s) {
        this.attribute = s;
    }

    @Override
    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public void setRightAttribute(String s) {
        this.rightAttribute = s;
    }

    @Override
    public String getRightAttribute() {
        return this.rightAttribute;
    }

    @Override
    public void setValue(Object s) {
        this.value = s;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setStaticValue(String staticValue) {
        this.staticValue_ = staticValue;
    }

    @Override
    public String getStaticValue() {
        return this.staticValue_;
    }

    @Override
    public boolean getNot() {
        return this.not;
    }

    @Override
    public void setNot(boolean b) {
        this.not = b;
    }

    public String toString(JdbcMetaClass<?> jmc) throws CpoException {
        String fullyQualifiedColumn;
        StringBuffer sb = new StringBuffer();
        JdbcAttribute attribute = null;
        if (this.getLogical() != -1) {
            sb.append(" ");
            sb.append(logicals[this.getLogical()]);
        } else if (!this.hasParent()) {
            sb.append("WHERE");
        }
        if (this.getNot()) {
            sb.append(" NOT");
        }
        if (this.getAttribute() != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            fullyQualifiedColumn = null;
            attribute = jmc.getColumnMap().get(this.getAttribute());
            fullyQualifiedColumn = attribute == null ? this.getAttribute() : this.buildColumnName(attribute);
            if (this.getAttributeFunction() != null) {
                if (attribute != null) {
                    sb.append(this.buildFunction(this.getAttributeFunction(), attribute.getName(), fullyQualifiedColumn.toString()));
                } else {
                    sb.append(this.getAttributeFunction());
                }
            } else {
                sb.append(fullyQualifiedColumn);
            }
        }
        if (this.getComparison() != -1) {
            sb.append(" ");
            sb.append(comparisons[this.getComparison()]);
        }
        if (this.getComparison() != 9 && (this.getValue() != null || this.getRightAttribute() != null || this.getStaticValue() != null)) {
            sb.append(" ");
            if (this.getValue() != null) {
                if (this.getValueFunction() != null) {
                    sb.append(this.buildFunction(this.getValueFunction(), attribute == null ? this.getAttribute() : attribute.getName(), "?"));
                } else {
                    sb.append("?");
                }
            } else if (this.getRightAttribute() != null) {
                attribute = jmc.getColumnMap().get(this.getRightAttribute());
                fullyQualifiedColumn = null;
                fullyQualifiedColumn = attribute == null ? this.getRightAttribute() : this.buildColumnName(attribute);
                if (this.getRightAttributeFunction() != null) {
                    sb.append(this.buildFunction(this.getRightAttributeFunction(), attribute == null ? this.getAttribute() : attribute.getName(), fullyQualifiedColumn));
                } else {
                    sb.append(fullyQualifiedColumn);
                }
            } else if (this.getStaticValue() != null) {
                sb.append(this.getStaticValue());
            }
        }
        return sb.toString();
    }

    @Override
    public void addWhere(CpoWhere cw) throws CpoException {
        try {
            this.addChild((Node)((Object)cw));
        }
        catch (ChildNodeException cne) {
            throw new CpoException("Error Adding Where Statement");
        }
    }

    @Override
    public void setAttributeFunction(String s) {
        this.attributeFunction = s;
    }

    @Override
    public String getAttributeFunction() {
        return this.attributeFunction;
    }

    @Override
    public void setValueFunction(String s) {
        this.valueFunction = s;
    }

    @Override
    public String getValueFunction() {
        return this.valueFunction;
    }

    @Override
    public void setRightAttributeFunction(String s) {
        this.rightAttributeFunction = s;
    }

    @Override
    public String getRightAttributeFunction() {
        return this.rightAttributeFunction;
    }

    private String buildFunction(String function, String match, String value) {
        StringBuffer sb = new StringBuffer();
        int attrOffset = 0;
        int fromIndex = 0;
        if (function != null && function.length() > 0) {
            while ((attrOffset = function.indexOf(match, fromIndex)) != -1) {
                sb.append(function.substring(0, attrOffset));
                sb.append(value);
                fromIndex += attrOffset + match.length();
            }
            sb.append(function.substring(fromIndex));
        }
        return sb.toString();
    }

    private String buildColumnName(JdbcAttribute attribute) {
        StringBuffer columnName = new StringBuffer();
        if (attribute.getDbTable() != null) {
            columnName.append(attribute.getDbTable());
            columnName.append(".");
        }
        if (attribute.getDbColumn() != null) {
            columnName.append(attribute.getDbColumn());
        } else {
            columnName.append(attribute.getDbName());
        }
        return columnName.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

