/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoResultSet;

public class CpoBlockingResultSet<E>
implements CpoResultSet<E>,
Iterator<E> {
    private static Logger logger = LoggerFactory.getLogger((String)CpoBlockingResultSet.class.getName());
    private static final long serialVersionUID = 1L;
    private int capacity = 0;
    private AtomicInteger aInt = new AtomicInteger(0);
    private ThreadLocal<E> tlObj = new ThreadLocal();
    LinkedBlockingQueue<E> lbq = null;
    HashMap<Thread, Thread> producers = new HashMap();
    HashMap<Thread, Thread> consumers = new HashMap();
    boolean done = false;

    public CpoBlockingResultSet(int capacity) {
        this.capacity = capacity;
        this.lbq = new LinkedBlockingQueue(capacity);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.producers.put(Thread.currentThread(), Thread.currentThread());
        logger.debug("Put Called");
        this.lbq.put(e);
        this.aInt.incrementAndGet();
    }

    @Override
    public boolean hasNext() {
        logger.debug("hasNext Called");
        E ret = this.tlObj.get();
        if (this.isDone() && this.lbq.size() == 0 && ret == null) {
            return false;
        }
        if (ret == null) {
            try {
                this.tlObj.set(this.take());
            }
            catch (InterruptedException ie) {
                if (!this.isDone()) {
                    Thread.currentThread().interrupt();
                    return false;
                }
                if (this.isDone() && this.lbq.size() == 0) {
                    return false;
                }
                try {
                    this.tlObj.set(this.take());
                }
                catch (InterruptedException ie2) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int size() {
        return this.aInt.get();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E next() throws NoSuchElementException {
        logger.debug("next Called");
        E ret = this.tlObj.get();
        if (ret == null) {
            try {
                ret = this.take();
            }
            catch (InterruptedException ie) {
                if (!this.isDone()) {
                    Thread.currentThread().interrupt();
                    throw new NoSuchElementException();
                }
                if (this.lbq.size() == 0) {
                    throw new NoSuchElementException();
                }
                try {
                    ret = this.take();
                }
                catch (InterruptedException ie2) {
                    Thread.currentThread().interrupt();
                    throw new NoSuchElementException();
                }
            }
        } else {
            this.tlObj.set(null);
        }
        return ret;
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    @Override
    public E take() throws InterruptedException {
        this.consumers.put(Thread.currentThread(), Thread.currentThread());
        logger.debug("Take Called");
        return this.lbq.take();
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    @Override
    public void cancel() {
        for (Thread t : this.consumers.values()) {
            t.interrupt();
        }
        for (Thread t : this.producers.values()) {
            t.interrupt();
        }
    }

    @Override
    public int getFetchSize() {
        return this.capacity;
    }
}

