/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.Context;

public class JdbcDataSourceInfo {
    protected static final int URL_CONNECTION = 1;
    protected static final int URL_PROPS_CONNECTION = 2;
    protected static final int URL_USER_PASSWORD_CONNECTION = 3;
    protected static final int JNDI_CONNECTION = 4;
    private int connectionType_ = 0;
    private String jndiName_ = null;
    private Context jndiCtx_ = null;
    private String driver_ = null;
    private String url_ = null;
    private String username_ = null;
    private String password_ = null;
    private Properties properties_ = null;
    private int maxConnections_ = 0;
    private int initialConnections_ = 0;
    private boolean waitIfBusy_ = false;
    private String dataSourceName = null;
    private String dbTablePrefix = "";

    private JdbcDataSourceInfo() {
    }

    public JdbcDataSourceInfo(String JndiName) {
        this.setConnectionType(4);
        this.setJndiName(JndiName);
        this.setDataSourceName(JndiName);
    }

    public JdbcDataSourceInfo(String JndiName, String tablePrefix) {
        this.setConnectionType(4);
        this.setJndiName(JndiName);
        this.setDataSourceName(JndiName);
        if (tablePrefix != null) {
            this.setDbTablePrefix(tablePrefix);
        }
    }

    public JdbcDataSourceInfo(String JndiName, Context ctx) {
        this.setConnectionType(4);
        this.setJndiName(JndiName);
        this.setJndiCtx(ctx);
        this.setDataSourceName(JndiName);
    }

    public JdbcDataSourceInfo(String JndiName, Context ctx, String tablePrefix) {
        this.setConnectionType(4);
        this.setJndiName(JndiName);
        this.setJndiCtx(ctx);
        this.setDataSourceName(JndiName);
        if (tablePrefix != null) {
            this.setDbTablePrefix(tablePrefix);
        }
    }

    public JdbcDataSourceInfo(String driver, String url, int initialConnections, int maxConnections, boolean waitIfBusy) throws SQLException {
        this.setDriver(driver);
        this.setUrl(url);
        this.setConnectionType(1);
        this.setInitialConnections(initialConnections);
        this.setMaxConnections(maxConnections);
        this.setWaitIfBusy(waitIfBusy);
        this.setDataSourceName(url);
    }

    public JdbcDataSourceInfo(String driver, String url, int initialConnections, int maxConnections, boolean waitIfBusy, String tablePrefix) throws SQLException {
        this.setDriver(driver);
        this.setUrl(url);
        this.setConnectionType(1);
        this.setInitialConnections(initialConnections);
        this.setMaxConnections(maxConnections);
        this.setWaitIfBusy(waitIfBusy);
        this.setDataSourceName(url);
        if (tablePrefix != null) {
            this.setDbTablePrefix(tablePrefix);
        }
    }

    public JdbcDataSourceInfo(String driver, String url, Properties properties, int initialConnections, int maxConnections, boolean waitIfBusy) throws SQLException {
        this.setDriver(driver);
        this.setUrl(url);
        this.setProperties(properties);
        this.setConnectionType(2);
        this.setInitialConnections(initialConnections);
        this.setMaxConnections(maxConnections);
        this.setWaitIfBusy(waitIfBusy);
        this.setDataSourceName(this.BuildDataSourceName(url, properties));
    }

    public JdbcDataSourceInfo(String driver, String url, Properties properties, int initialConnections, int maxConnections, boolean waitIfBusy, String tablePrefix) throws SQLException {
        this.setDriver(driver);
        this.setUrl(url);
        this.setProperties(properties);
        this.setConnectionType(2);
        this.setInitialConnections(initialConnections);
        this.setMaxConnections(maxConnections);
        this.setWaitIfBusy(waitIfBusy);
        this.setDataSourceName(this.BuildDataSourceName(url, properties));
        if (tablePrefix != null) {
            this.setDbTablePrefix(tablePrefix);
        }
    }

    public JdbcDataSourceInfo(String driver, String url, String username, String password, int initialConnections, int maxConnections, boolean waitIfBusy) throws SQLException {
        this.setConnectionType(3);
        this.setDriver(driver);
        this.setUrl(url);
        this.setUserName(username);
        this.setPassword(password);
        this.setInitialConnections(initialConnections);
        this.setMaxConnections(maxConnections);
        this.setWaitIfBusy(waitIfBusy);
        this.setDataSourceName(url + username);
    }

    public JdbcDataSourceInfo(String driver, String url, String username, String password, int initialConnections, int maxConnections, boolean waitIfBusy, String tablePrefix) throws SQLException {
        this.setConnectionType(3);
        this.setDriver(driver);
        this.setUrl(url);
        this.setUserName(username);
        this.setPassword(password);
        this.setInitialConnections(initialConnections);
        this.setMaxConnections(maxConnections);
        this.setWaitIfBusy(waitIfBusy);
        this.setDataSourceName(url + username);
        if (tablePrefix != null) {
            this.setDbTablePrefix(tablePrefix);
        }
    }

    public String getDriver() {
        return this.driver_;
    }

    public String getUrl() {
        return this.url_;
    }

    public String getUserName() {
        return this.username_;
    }

    public String getPassword() {
        return this.password_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public int getMaxConnections() {
        return this.maxConnections_;
    }

    public boolean getWaitIfBusy() {
        return this.waitIfBusy_;
    }

    public int getConnectionType() {
        return this.connectionType_;
    }

    protected void setDriver(String driver) {
        this.driver_ = driver;
    }

    protected void setUrl(String url) {
        this.url_ = url;
    }

    protected void setUserName(String username) {
        this.username_ = username;
    }

    protected void setPassword(String password) {
        this.password_ = password;
    }

    protected void setProperties(Properties properties) {
        this.properties_ = properties;
    }

    protected void setMaxConnections(int maxConnections) {
        this.maxConnections_ = maxConnections;
    }

    protected void setWaitIfBusy(boolean waitIfBusy) {
        this.waitIfBusy_ = waitIfBusy;
    }

    protected void setConnectionType(int connectionType) {
        this.connectionType_ = connectionType;
    }

    public Context getJndiCtx() {
        return this.jndiCtx_;
    }

    protected void setJndiCtx(Context jndiCtx_) {
        this.jndiCtx_ = jndiCtx_;
    }

    public String getJndiName() {
        return this.jndiName_;
    }

    protected void setJndiName(String jndiName_) {
        this.jndiName_ = jndiName_;
    }

    public int getInitialConnections() {
        return this.initialConnections_;
    }

    protected void setInitialConnections(int initialConnections_) {
        this.initialConnections_ = initialConnections_;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    protected void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDbTablePrefix() {
        return this.dbTablePrefix;
    }

    protected void setDbTablePrefix(String dbTablePrefix) {
        this.dbTablePrefix = dbTablePrefix;
    }

    private String BuildDataSourceName(String url, Properties properties) {
        StringBuffer dsName = new StringBuffer(url);
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        Iterator<Object> it = treeMap.values().iterator();
        while (it.hasNext()) {
            dsName.append((String)it.next());
        }
        return dsName.toString();
    }
}

