/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.JdbcAttribute;
import org.synchronoss.cpo.jdbc.JdbcQuery;

public class JdbcMetaClass<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Class<T> objClass = null;
    private String classId = null;
    private String name = null;
    private HashMap<String, JdbcAttribute> attributeMap = new HashMap();
    private HashMap<String, JdbcAttribute> columnMap = new HashMap();
    private HashMap<String, HashMap<String, ArrayList<JdbcQuery>>> queryGroups = new HashMap();

    public JdbcMetaClass(Class<T> c, String s) throws CpoException {
        this.setJmcClass(c);
        this.setName(s);
    }

    public String getClassId() {
        return this.classId;
    }

    public void setClassId(String s) {
        this.classId = s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public HashMap<String, JdbcAttribute> getAttributeMap() {
        return this.attributeMap;
    }

    public HashMap<String, JdbcAttribute> getColumnMap() {
        return this.columnMap;
    }

    public HashMap<String, HashMap<String, ArrayList<JdbcQuery>>> getQueryGroups() {
        return this.queryGroups;
    }

    public Class<T> getJmcClass() {
        return this.objClass;
    }

    public void setJmcClass(Class<T> c) {
        this.objClass = c;
    }

    public void addQueryToGroup(JdbcQuery jq) {
        HashMap<String, HashMap<String, ArrayList<JdbcQuery>>> qgs = this.getQueryGroups();
        String qgType = jq.getType();
        String qgName = jq.getName();
        HashMap<String, ArrayList<JdbcQuery>> qg = qgs.get(qgType);
        ArrayList<JdbcQuery> al = null;
        if (qg == null) {
            qg = new HashMap();
            qgs.put(qgType, qg);
        }
        if ((al = qg.get(qgName)) == null) {
            al = new ArrayList();
            qg.put(qgName, al);
        }
        al.add(jq);
    }

    public ArrayList<JdbcQuery> getQueryGroup(String qgType, String qgName) throws CpoException {
        HashMap<String, HashMap<String, ArrayList<JdbcQuery>>> qgs = this.getQueryGroups();
        HashMap<String, ArrayList<JdbcQuery>> qg = qgs.get(qgType);
        ArrayList<JdbcQuery> al = null;
        if (qg == null) {
            throw new CpoException("No <" + qgType + "> Query Group defined for " + this.name);
        }
        al = qg.get(qgName);
        if (al == null) {
            throw new CpoException(qgType + " Query Group <" + qgName + "> not defined for " + this.name);
        }
        return al;
    }
}

