/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.sql.Timestamp;
import java.util.Calendar;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformTimestampToCalendar
implements Transform<Timestamp, Calendar> {
    @Override
    public Calendar transformIn(Timestamp ts) throws CpoException {
        Calendar cal = null;
        if (ts != null) {
            cal = Calendar.getInstance();
            cal.setTimeInMillis(ts.getTime());
        }
        return cal;
    }

    @Override
    public Timestamp transformOut(JdbcCallableStatementFactory jcsf, Calendar cal) throws CpoException {
        Timestamp ts = null;
        if (cal != null) {
            ts = new Timestamp(cal.getTimeInMillis());
        }
        return ts;
    }

    @Override
    public Timestamp transformOut(JdbcPreparedStatementFactory jpsf, Calendar cal) throws CpoException {
        Timestamp ts = null;
        if (cal != null) {
            ts = new Timestamp(cal.getTimeInMillis());
        }
        return ts;
    }
}

