/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoTrxAdapter;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;

public class JdbcCpoTrxAdapter
extends JdbcCpoAdapter
implements CpoTrxAdapter {
    private static final long serialVersionUID = 1L;
    private Connection writeConnection_ = null;
    private static HashMap<Connection, Connection> busyMap_ = new HashMap();
    private static HashMap<Connection, Connection> dirtyMap_ = new HashMap();

    private JdbcCpoTrxAdapter() {
    }

    protected JdbcCpoTrxAdapter(DataSource metaSource, String metaSourceName, Connection c, boolean batchSupported, String dbTablePrefix) throws CpoException {
        super(metaSource, metaSourceName, batchSupported, dbTablePrefix);
        this.setStaticConnection(c);
    }

    @Override
    public void commit() throws CpoException {
        Connection writeConnection = this.getStaticConnection();
        if (writeConnection != null) {
            try {
                writeConnection.commit();
                this.clearConnectionBusy(writeConnection);
                this.clearConnectionDirty(writeConnection);
            }
            catch (SQLException se) {
                throw new CpoException(se.getMessage());
            }
        } else {
            throw new CpoException("Transaction Object has been Closed");
        }
    }

    @Override
    public void rollback() throws CpoException {
        Connection writeConnection = this.getStaticConnection();
        if (writeConnection != null) {
            try {
                writeConnection.rollback();
                this.clearConnectionBusy(writeConnection);
                this.clearConnectionDirty(writeConnection);
            }
            catch (Exception e) {
                throw new CpoException(e.getMessage());
            }
        } else {
            throw new CpoException("Transaction Object has been Closed");
        }
    }

    @Override
    public boolean isClosed() throws CpoException {
        Connection writeConnection = this.getStaticConnection();
        boolean closed = false;
        try {
            closed = writeConnection == null || writeConnection.isClosed();
        }
        catch (Exception e) {
            throw new CpoException(e.getMessage());
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CpoException {
        Connection writeConnection = this.getStaticConnection();
        if (writeConnection != null) {
            try {
                try {
                    if (this.isConnectionDirty(writeConnection)) {
                        writeConnection.rollback();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    writeConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.setStaticConnection(null);
                this.clearConnectionBusy(writeConnection);
                this.clearConnectionDirty(writeConnection);
            }
        }
    }

    protected void finalize() {
        Connection writeConnection = null;
        try {
            super.finalize();
            writeConnection = this.getStaticConnection();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (writeConnection != null && !writeConnection.isClosed()) {
                this.rollback();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (writeConnection != null && !writeConnection.isClosed()) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Connection getStaticConnection() throws CpoException {
        if (this.writeConnection_ != null) {
            if (this.isConnectionBusy(this.writeConnection_)) {
                throw new CpoException("Error Connection Busy");
            }
            this.setConnectionBusy(this.writeConnection_);
            this.setConnectionDirty(this.writeConnection_);
        }
        return this.writeConnection_;
    }

    @Override
    protected boolean isStaticConnection(Connection c) {
        return this.writeConnection_ == c;
    }

    @Override
    protected void setStaticConnection(Connection c) {
        this.writeConnection_ = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isConnectionBusy(Connection c) {
        HashMap<Connection, Connection> hashMap = busyMap_;
        synchronized (hashMap) {
            Connection test = busyMap_.get(c);
            return test != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setConnectionBusy(Connection c) {
        HashMap<Connection, Connection> hashMap = busyMap_;
        synchronized (hashMap) {
            busyMap_.put(c, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearConnectionBusy(Connection c) {
        HashMap<Connection, Connection> hashMap = busyMap_;
        synchronized (hashMap) {
            busyMap_.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isConnectionDirty(Connection c) {
        HashMap<Connection, Connection> hashMap = dirtyMap_;
        synchronized (hashMap) {
            Connection test = dirtyMap_.get(c);
            return test != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setConnectionDirty(Connection c) {
        HashMap<Connection, Connection> hashMap = dirtyMap_;
        synchronized (hashMap) {
            dirtyMap_.put(c, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearConnectionDirty(Connection c) {
        HashMap<Connection, Connection> hashMap = dirtyMap_;
        synchronized (hashMap) {
            dirtyMap_.remove(c);
        }
    }
}

