/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.synchronoss.cpo.ChildNodeException;
import org.synchronoss.cpo.INodeVisitor;
import org.synchronoss.cpo.Queue;

public class Node
implements Serializable,
Cloneable,
Comparable<Node> {
    private static final long serialVersionUID = 1L;
    private static final int CHILD_NODE = 0;
    private Node parent;
    private Node firstChild;
    private Node prevSibling;
    private Node nextSibling;
    private boolean allowChildren;

    protected Node() {
        this.release();
    }

    protected Node(int nodeType) {
        this.release();
        if (nodeType == 0) {
            this.allowChildren = false;
        }
    }

    public static Node createNode(int nodeType) {
        return new Node(nodeType);
    }

    public void release() {
        this.parent = null;
        this.firstChild = null;
        this.prevSibling = null;
        this.nextSibling = null;
        this.allowChildren = true;
    }

    protected void setAllowChildren(boolean ac) {
        this.allowChildren = ac;
    }

    public boolean getAllowChildren() {
        return this.allowChildren;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public void setPrevSibling(Node node) {
        this.prevSibling = node;
        node.nextSibling = this;
    }

    public void setNextSibling(Node node) {
        this.nextSibling = node;
        node.prevSibling = this;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public Node getPrevSibling() {
        return this.prevSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isLeaf() {
        return this.getFirstChild() == null;
    }

    public void addChild(Node node) throws ChildNodeException {
        Node lastChild = null;
        if (node != null) {
            if (!this.allowChildren) {
                throw new ChildNodeException();
            }
            if (this.getFirstChild() == null) {
                this.setFirstChild(node);
                this.getFirstChild().setPrevSibling(this.firstChild);
                this.getFirstChild().setNextSibling(this.firstChild);
            } else {
                lastChild = this.getFirstChild().getPrevSibling();
                if (lastChild != null) {
                    lastChild.setNextSibling(node);
                }
                node.setNextSibling(this.getFirstChild());
            }
            node.setParent(this);
        }
    }

    public void addChildSort(Node node) throws ChildNodeException {
        this.addChildSort(node, null);
    }

    public void addChildSort(Node node, Comparator<Node> c) throws ChildNodeException {
        Node lastChild = null;
        Node currNode = null;
        if (node != null) {
            if (!this.allowChildren) {
                throw new ChildNodeException();
            }
            if (this.isLeaf()) {
                this.setFirstChild(node);
                this.getFirstChild().setPrevSibling(node);
                this.getFirstChild().setNextSibling(node);
            } else {
                boolean added = false;
                currNode = this.getFirstChild();
                do {
                    if (this.doCompare(node, currNode, c) >= 0) continue;
                    node.setPrevSibling(currNode.getPrevSibling());
                    node.setNextSibling(currNode);
                    if (currNode == this.getFirstChild()) {
                        this.setFirstChild(node);
                    }
                    added = true;
                    break;
                } while ((currNode = currNode.getNextSibling()) != this.getFirstChild());
                if (!added) {
                    lastChild = this.getFirstChild().getPrevSibling();
                    if (lastChild != null) {
                        lastChild.setNextSibling(node);
                    }
                    node.setNextSibling(this.getFirstChild());
                }
            }
            node.setParent(this);
        }
    }

    protected int doCompare(Node n1, Node n2, Comparator<Node> c) {
        int rc = c != null ? c.compare(n1, n2) : (n1 == null && n1 == n2 ? 0 : n1.compareTo(n2));
        return rc;
    }

    public void insertSiblingBefore(Node node) throws ChildNodeException {
        if (node != null) {
            node.setPrevSibling(this.getPrevSibling());
            node.setNextSibling(this);
        }
    }

    public void insertSiblingAfter(Node node) {
        if (node != null) {
            node.setNextSibling(this.getNextSibling());
            node.setPrevSibling(this);
        }
    }

    public void insertParentBefore(Node node) throws ChildNodeException {
        if (node != null) {
            if (this.hasParent()) {
                this.getParentNode().addChild(node);
                this.getParentNode().removeChild(this);
            }
            node.addChild(this);
        }
    }

    public void insertParentAfter(Node node) throws ChildNodeException {
        if (node != null) {
            node.setFirstChild(this.getFirstChild());
            this.setFirstChild(null);
            this.addChild(node);
        }
    }

    public boolean removeChild(Node node) throws ChildNodeException {
        Node currNode = this.getFirstChild();
        boolean rc = false;
        if (!this.allowChildren) {
            throw new ChildNodeException();
        }
        if (node != null && !this.isLeaf()) {
            if (node == currNode && node == currNode.getNextSibling()) {
                this.setFirstChild(null);
                rc = true;
            } else {
                do {
                    if (currNode != node) continue;
                    if (node.getPrevSibling() != null) {
                        node.getPrevSibling().setNextSibling(node.getNextSibling());
                    }
                    if (node == this.getFirstChild()) {
                        this.setFirstChild(node.getNextSibling());
                    }
                    rc = true;
                    break;
                } while ((currNode = currNode.getNextSibling()) != this.getFirstChild());
            }
        }
        return rc;
    }

    public void removeChildNode() throws ChildNodeException {
        if (!this.isLeaf() && this.hasParent()) {
            Node parentLast = this.getParentNode().getFirstChild().getPrevSibling();
            Node thisLast = this.getFirstChild().getPrevSibling();
            parentLast.setNextSibling(this.getFirstChild());
            thisLast.setNextSibling(this.getParentNode().getFirstChild());
            this.getParentNode().removeChild(this);
        }
    }

    public void removeAll() throws ChildNodeException {
        if (this.hasParent()) {
            this.getParentNode().removeChild(this);
        }
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(Node node) throws ChildNodeException {
        if (!this.allowChildren) {
            throw new ChildNodeException();
        }
        this.firstChild = node;
    }

    public boolean acceptDFVisitor(INodeVisitor nv) throws Exception {
        boolean continueVisit = true;
        if (nv != null) {
            if (this.isLeaf()) {
                continueVisit = nv.visit(this);
            } else {
                continueVisit = nv.visitBegin(this);
                if (continueVisit) {
                    Node currNode = this.getFirstChild();
                    do {
                        if (!(continueVisit = currNode.acceptDFVisitor(nv))) continue;
                        if ((currNode = currNode.getNextSibling()) == this.getFirstChild()) break;
                        continueVisit = nv.visitMiddle(this);
                    } while (continueVisit);
                    if (continueVisit) {
                        continueVisit = nv.visitEnd(this);
                    }
                }
            }
        }
        return continueVisit;
    }

    public boolean acceptBFVisitor(INodeVisitor nv) throws Exception {
        Queue queue = new Queue();
        boolean continueVisit = true;
        if (nv != null) {
            queue.put(this);
            while (!queue.isEmpty()) {
                Node parentNode = (Node)queue.get();
                continueVisit = nv.visit(this);
                if (!continueVisit) break;
                if (parentNode.isLeaf()) continue;
                Node childNode = parentNode.getFirstChild();
                do {
                    queue.put(childNode);
                } while ((childNode = childNode.getNextSibling()) != parentNode.getFirstChild());
            }
        }
        return continueVisit;
    }

    public int getChildCount() {
        int count = 0;
        if (!this.isLeaf()) {
            Node currNode = this.getFirstChild();
            do {
                ++count;
            } while ((currNode = currNode.getNextSibling()) != this.getFirstChild());
        }
        return count;
    }

    public List<Node> getChildList() {
        ArrayList<Node> al = new ArrayList<Node>();
        if (!this.isLeaf()) {
            Node currNode = this.getFirstChild();
            do {
                al.add(currNode);
            } while ((currNode = currNode.getNextSibling()) != this.getFirstChild());
        }
        return al;
    }

    public Object clone() throws CloneNotSupportedException {
        Node thisClone = (Node)super.clone();
        thisClone.release();
        thisClone.setAllowChildren(this.getAllowChildren());
        if (!this.isLeaf()) {
            Node currNode = this.getFirstChild();
            do {
                try {
                    thisClone.addChild((Node)currNode.clone());
                }
                catch (ChildNodeException childNodeException) {
                    // empty catch block
                }
            } while ((currNode = currNode.getNextSibling()) != this.getFirstChild());
        }
        return thisClone;
    }

    @Override
    public int compareTo(Node o) {
        int rc = this.hashCode() < o.hashCode() ? -1 : (this.hashCode() > o.hashCode() ? 1 : 0);
        return rc;
    }

    public boolean equals(Node o) {
        return this == o;
    }
}

